/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.api.contract.impl;

import io.vertx.codegen.annotations.Fluent;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.api.contract.RouterFactory;
import io.vertx.ext.web.api.contract.RouterFactoryOptions;
import io.vertx.ext.web.api.validation.ValidationException;
import io.vertx.ext.web.handler.BodyHandler;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;

public abstract class BaseRouterFactory<Specification>
implements RouterFactory {
    public static final Handler<RoutingContext> DEFAULT_VALIDATION_FAILURE_HANDLER = routingContext -> {
        if (routingContext.failure() instanceof ValidationException) {
            routingContext.response().setStatusCode(400).setStatusMessage("Bad Request").end(routingContext.failure().getMessage());
        } else {
            routingContext.next();
        }
    };
    public static final Handler<RoutingContext> DEFAULT_NOT_IMPLEMENTED_HANDLER = routingContext -> routingContext.response().setStatusCode(501).setStatusMessage("Not Implemented").end();
    public static final Function<RoutingContext, JsonObject> DEFAULT_EXTRA_OPERATION_CONTEXT_PAYLOAD_MAPPER = null;
    protected Vertx vertx;
    protected Specification spec;
    protected RouterFactoryOptions options;
    private Handler<RoutingContext> validationFailureHandler;
    private Handler<RoutingContext> notImplementedFailureHandler;
    private BodyHandler bodyHandler;
    private List<Handler<RoutingContext>> globalHandlers;
    private Function<RoutingContext, JsonObject> extraOperationContextPayloadMapper;

    public BaseRouterFactory(Vertx vertx, Specification spec, RouterFactoryOptions options) {
        this.vertx = vertx;
        this.spec = spec;
        this.options = options;
        this.validationFailureHandler = DEFAULT_VALIDATION_FAILURE_HANDLER;
        this.notImplementedFailureHandler = DEFAULT_NOT_IMPLEMENTED_HANDLER;
        this.bodyHandler = BodyHandler.create();
        this.globalHandlers = new ArrayList<Handler<RoutingContext>>();
        this.extraOperationContextPayloadMapper = DEFAULT_EXTRA_OPERATION_CONTEXT_PAYLOAD_MAPPER;
    }

    public BaseRouterFactory(Vertx vertx, Specification spec) {
        this(vertx, spec, new RouterFactoryOptions());
    }

    @Override
    public RouterFactory setOptions(RouterFactoryOptions options) {
        this.options = options;
        return this;
    }

    @Override
    public RouterFactoryOptions getOptions() {
        return this.options;
    }

    @Override
    public Handler<RoutingContext> getValidationFailureHandler() {
        return this.validationFailureHandler;
    }

    @Override
    @Fluent
    public RouterFactory setValidationFailureHandler(Handler<RoutingContext> validationFailureHandler) {
        this.validationFailureHandler = validationFailureHandler;
        return this;
    }

    protected Handler<RoutingContext> getNotImplementedFailureHandler() {
        return this.notImplementedFailureHandler;
    }

    @Override
    @Fluent
    public RouterFactory setNotImplementedFailureHandler(Handler<RoutingContext> notImplementedFailureHandler) {
        this.notImplementedFailureHandler = notImplementedFailureHandler;
        return this;
    }

    protected BodyHandler getBodyHandler() {
        return this.bodyHandler;
    }

    @Override
    @Fluent
    public RouterFactory setBodyHandler(BodyHandler bodyHandler) {
        this.bodyHandler = bodyHandler;
        return this;
    }

    protected List<Handler<RoutingContext>> getGlobalHandlers() {
        return this.globalHandlers;
    }

    @Override
    @Fluent
    public RouterFactory addGlobalHandler(Handler<RoutingContext> globalHandler) {
        this.globalHandlers.add(globalHandler);
        return this;
    }

    protected Function<RoutingContext, JsonObject> getExtraOperationContextPayloadMapper() {
        return this.extraOperationContextPayloadMapper;
    }

    @Override
    @Fluent
    public RouterFactory setExtraOperationContextPayloadMapper(Function<RoutingContext, JsonObject> extraOperationContextPayloadMapper) {
        this.extraOperationContextPayloadMapper = extraOperationContextPayloadMapper;
        return this;
    }
}

