/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.api.validation.impl;

import io.vertx.ext.web.api.RequestParameter;
import io.vertx.ext.web.api.validation.ContainerDeserializer;
import io.vertx.ext.web.api.validation.ContainerSerializationStyle;
import io.vertx.ext.web.api.validation.ParameterTypeValidator;
import io.vertx.ext.web.api.validation.ValidationException;
import io.vertx.ext.web.api.validation.impl.ContainerTypeValidator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ObjectTypeValidator
extends ContainerTypeValidator<Map<String, String>> {
    Map<String, ObjectField> fieldsMap = new HashMap<String, ObjectField>();

    public ObjectTypeValidator(ContainerDeserializer collectionFormat, boolean exploded) {
        super(collectionFormat, exploded);
    }

    public void addField(String name, ParameterTypeValidator validator, boolean required) {
        this.fieldsMap.put(name, new ObjectField(validator, required));
    }

    @Override
    public RequestParameter isValid(String value) throws ValidationException {
        return this.validate((Map<String, String>)this.deserialize(value));
    }

    @Override
    public RequestParameter isValidCollection(List<String> value) throws ValidationException {
        return this.validate((Map<String, String>)this.deserialize(value.get(0)));
    }

    @Override
    protected Map<String, String> deserialize(String serialized) throws ValidationException {
        return this.getContainerDeserializer().deserializeObject(serialized);
    }

    @Override
    protected RequestParameter validate(Map<String, String> values) throws ValidationException {
        HashMap<String, RequestParameter> parsedParams = new HashMap<String, RequestParameter>();
        for (Map.Entry<String, ObjectField> field : this.fieldsMap.entrySet()) {
            if (!values.containsKey(field.getKey())) {
                if (field.getValue().required) {
                    throw ValidationException.ValidationExceptionFactory.generateObjectFieldNotFound(field.getKey());
                }
                if (field.getValue().validator.getDefault() == null) continue;
                parsedParams.put(field.getKey(), RequestParameter.create(field.getKey(), field.getValue().validator.getDefault()));
                continue;
            }
            RequestParameter param = field.getValue().validator.isValid(values.get(field.getKey()));
            param.setName(field.getKey());
            parsedParams.put(field.getKey(), param);
        }
        return RequestParameter.create(parsedParams);
    }

    public static class ObjectTypeValidatorFactory {
        public static ObjectTypeValidator createObjectTypeValidator(ContainerSerializationStyle collectionFormat, boolean exploded) {
            return new ObjectTypeValidator(collectionFormat.deserializer(), exploded);
        }

        public static ObjectTypeValidator createObjectTypeValidator(String collectionFormat, boolean exploded) {
            return new ObjectTypeValidator(ContainerSerializationStyle.getContainerStyle(collectionFormat).deserializer(), exploded);
        }
    }

    private static class ObjectField {
        private ParameterTypeValidator validator;
        private boolean required;

        public ObjectField(ParameterTypeValidator validator, boolean required) {
            this.validator = validator;
            this.required = required;
        }
    }
}

