/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.openapi.router.impl;

import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.ext.web.Route;
import io.vertx.ext.web.Router;
import io.vertx.ext.web.handler.AuthenticationHandler;
import io.vertx.ext.web.handler.ChainAuthHandler;
import io.vertx.ext.web.handler.OAuth2AuthHandler;
import io.vertx.ext.web.handler.SimpleAuthenticationHandler;
import io.vertx.ext.web.internal.handler.ScopedAuthentication;
import io.vertx.openapi.contract.Operation;
import io.vertx.openapi.contract.SecurityRequirement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

class AuthenticationHandlers {
    private static final AuthenticationHandler ANONYMOUS_SUCCESS_AUTH_HANDLER = SimpleAuthenticationHandler.create().authenticate(ctx -> Future.succeededFuture());
    private final Map<String, List<AuthenticationHandler>> securityHandlers = new HashMap<String, List<AuthenticationHandler>>();
    private final Map<String, OAuth2AuthHandler> callbackHandlers = new HashMap<String, OAuth2AuthHandler>();

    AuthenticationHandlers() {
    }

    protected void addRequirement(String name, AuthenticationHandler handler, String callback) {
        this.securityHandlers.computeIfAbsent(name, k -> new ArrayList()).add(handler);
        if (callback != null) {
            if (this.callbackHandlers.containsKey(callback)) {
                throw new IllegalStateException("Callback already in use: " + callback + " [only 1 callback per handler is allowed]");
            }
            this.callbackHandlers.put(callback, (OAuth2AuthHandler)handler);
        }
    }

    protected void solve(Operation operation, Route route, boolean failOnNotFound) {
        AuthenticationHandler authn = this.or(route, operation.getSecurityRequirements(), failOnNotFound);
        if (authn != null) {
            route.handler((Handler)authn);
        }
    }

    private List<AuthenticationHandler> resolveHandlers(Route route, String name, List<String> scopes, boolean failOnNotFound) {
        List<Object> authenticationHandlers = failOnNotFound ? Optional.ofNullable(this.securityHandlers.get(name)).orElseThrow(() -> new IllegalStateException("Missing security handler for: '" + name + "'")) : Optional.ofNullable(this.securityHandlers.get(name)).orElse(Collections.emptyList());
        if (!scopes.isEmpty()) {
            route.putMetadata("scopes", scopes);
            authenticationHandlers = authenticationHandlers.stream().map(authHandler -> {
                if (authHandler instanceof ScopedAuthentication) {
                    return ((ScopedAuthentication)authHandler).withScopes(scopes);
                }
                return authHandler;
            }).collect(Collectors.toList());
        }
        return authenticationHandlers;
    }

    private AuthenticationHandler and(Route route, SecurityRequirement securityRequirement, boolean failOnNotFound) {
        List<AuthenticationHandler> handlers = securityRequirement.getNames().stream().flatMap(name -> this.resolveHandlers(route, (String)name, securityRequirement.getScopes(name), failOnNotFound).stream()).collect(Collectors.toList());
        if (handlers.isEmpty()) {
            return null;
        }
        if (handlers.size() == 1) {
            return (AuthenticationHandler)handlers.get(0);
        }
        ChainAuthHandler authHandler = ChainAuthHandler.all();
        handlers.forEach(arg_0 -> ((ChainAuthHandler)authHandler).add(arg_0));
        return authHandler;
    }

    private AuthenticationHandler or(Route route, List<SecurityRequirement> securityRequirements, boolean failOnNotFound) {
        if (securityRequirements == null || securityRequirements.isEmpty()) {
            return null;
        }
        boolean emptyAuth = false;
        for (int i = 0; i < securityRequirements.size(); ++i) {
            if (!securityRequirements.get(i).isEmpty()) continue;
            emptyAuth = true;
            securityRequirements = new ArrayList<SecurityRequirement>(securityRequirements);
            securityRequirements.remove(i);
            break;
        }
        switch (securityRequirements.size()) {
            case 0: {
                return null;
            }
            case 1: {
                if (emptyAuth) break;
                return this.and(route, securityRequirements.get(0), failOnNotFound);
            }
        }
        ChainAuthHandler authHandler = ChainAuthHandler.any();
        securityRequirements.stream().map(securityRequirement -> this.and(route, (SecurityRequirement)securityRequirement, failOnNotFound)).filter(Objects::nonNull).forEach(arg_0 -> ((ChainAuthHandler)authHandler).add(arg_0));
        if (emptyAuth) {
            authHandler.add(ANONYMOUS_SUCCESS_AUTH_HANDLER);
        }
        return authHandler;
    }

    public void applyCallbackHandlers(Router router) {
        this.callbackHandlers.forEach((path, handler) -> handler.setupCallback(router.get(path)));
    }
}

