/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.templ.freemarker.impl;

import freemarker.template.AdapterTemplateModel;
import freemarker.template.ObjectWrapper;
import freemarker.template.SimpleCollection;
import freemarker.template.TemplateCollectionModel;
import freemarker.template.TemplateHashModelEx;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import freemarker.template.WrappingTemplateModel;
import io.vertx.core.json.JsonObject;

class JsonObjectAdapter
extends WrappingTemplateModel
implements TemplateHashModelEx,
AdapterTemplateModel {
    private final JsonObject jsonObject;

    public JsonObjectAdapter(JsonObject jsonObject, ObjectWrapper ow) {
        super(ow);
        this.jsonObject = jsonObject;
    }

    @Override
    public TemplateModel get(String key) throws TemplateModelException {
        Object value = this.jsonObject.getValue(key);
        return value == null ? null : this.wrap(value);
    }

    @Override
    public boolean isEmpty() {
        return this.jsonObject.isEmpty();
    }

    @Override
    public int size() {
        return this.jsonObject.size();
    }

    @Override
    public TemplateCollectionModel keys() {
        return new SimpleCollection(this.jsonObject.fieldNames(), this.getObjectWrapper());
    }

    @Override
    public TemplateCollectionModel values() {
        return new SimpleCollection(this.jsonObject.getMap().values(), this.getObjectWrapper());
    }

    public Object getAdaptedObject(Class hint) {
        return this.jsonObject;
    }
}

