/*
 * Decompiled with CFR 0.152.
 */
package is.codion.framework.db.http;

import is.codion.common.Serializer;
import is.codion.common.db.exception.DatabaseException;
import is.codion.framework.db.EntityConnection;
import is.codion.framework.db.http.AbstractHttpEntityConnection;
import is.codion.framework.domain.entity.Entity;
import is.codion.framework.domain.entity.EntityType;
import is.codion.framework.domain.entity.attribute.Column;
import is.codion.framework.domain.entity.condition.Condition;
import java.net.http.HttpClient;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;

final class DefaultHttpEntityConnection
extends AbstractHttpEntityConnection {
    DefaultHttpEntityConnection(AbstractHttpEntityConnection.DefaultBuilder builder) {
        super(builder, "/entities/ser/");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean transactionOpen() {
        try {
            HttpClient httpClient = this.httpClient;
            synchronized (httpClient) {
                return (Boolean)DefaultHttpEntityConnection.handleResponse(this.execute(this.createRequest("isTransactionOpen")));
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw DefaultHttpEntityConnection.logAndWrap(e);
        }
        catch (Exception e) {
            throw DefaultHttpEntityConnection.logAndWrap(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setQueryCacheEnabled(boolean queryCacheEnabled) {
        try {
            HttpClient httpClient = this.httpClient;
            synchronized (httpClient) {
                DefaultHttpEntityConnection.handleResponse(this.execute(this.createRequest("setQueryCacheEnabled", Serializer.serialize((Object)queryCacheEnabled))));
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw DefaultHttpEntityConnection.logAndWrap(e);
        }
        catch (Exception e) {
            throw DefaultHttpEntityConnection.logAndWrap(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isQueryCacheEnabled() {
        try {
            HttpClient httpClient = this.httpClient;
            synchronized (httpClient) {
                return (Boolean)DefaultHttpEntityConnection.handleResponse(this.execute(this.createRequest("isQueryCacheEnabled")));
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw DefaultHttpEntityConnection.logAndWrap(e);
        }
        catch (Exception e) {
            throw DefaultHttpEntityConnection.logAndWrap(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<Entity.Key> insert(Collection<? extends Entity> entities) throws DatabaseException {
        Objects.requireNonNull(entities);
        try {
            HttpClient httpClient = this.httpClient;
            synchronized (httpClient) {
                return (Collection)DefaultHttpEntityConnection.handleResponse(this.execute(this.createRequest("insert", Serializer.serialize(entities))));
            }
        }
        catch (DatabaseException e) {
            throw e;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw DefaultHttpEntityConnection.logAndWrap(e);
        }
        catch (Exception e) {
            throw DefaultHttpEntityConnection.logAndWrap(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<Entity> insertSelect(Collection<? extends Entity> entities) throws DatabaseException {
        Objects.requireNonNull(entities);
        try {
            HttpClient httpClient = this.httpClient;
            synchronized (httpClient) {
                return (Collection)DefaultHttpEntityConnection.handleResponse(this.execute(this.createRequest("insertSelect", Serializer.serialize(entities))));
            }
        }
        catch (DatabaseException e) {
            throw e;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw DefaultHttpEntityConnection.logAndWrap(e);
        }
        catch (Exception e) {
            throw DefaultHttpEntityConnection.logAndWrap(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(Collection<? extends Entity> entities) throws DatabaseException {
        Objects.requireNonNull(entities);
        try {
            HttpClient httpClient = this.httpClient;
            synchronized (httpClient) {
                DefaultHttpEntityConnection.handleResponse(this.execute(this.createRequest("update", Serializer.serialize(entities))));
            }
        }
        catch (DatabaseException e) {
            throw e;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw DefaultHttpEntityConnection.logAndWrap(e);
        }
        catch (Exception e) {
            throw DefaultHttpEntityConnection.logAndWrap(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<Entity> updateSelect(Collection<? extends Entity> entities) throws DatabaseException {
        Objects.requireNonNull(entities);
        try {
            HttpClient httpClient = this.httpClient;
            synchronized (httpClient) {
                return (Collection)DefaultHttpEntityConnection.handleResponse(this.execute(this.createRequest("updateSelect", Serializer.serialize(entities))));
            }
        }
        catch (DatabaseException e) {
            throw e;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw DefaultHttpEntityConnection.logAndWrap(e);
        }
        catch (Exception e) {
            throw DefaultHttpEntityConnection.logAndWrap(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int update(EntityConnection.Update update) throws DatabaseException {
        Objects.requireNonNull(update);
        try {
            HttpClient httpClient = this.httpClient;
            synchronized (httpClient) {
                return (Integer)DefaultHttpEntityConnection.handleResponse(this.execute(this.createRequest("updateByCondition", Serializer.serialize((Object)update))));
            }
        }
        catch (DatabaseException e) {
            throw e;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw DefaultHttpEntityConnection.logAndWrap(e);
        }
        catch (Exception e) {
            throw DefaultHttpEntityConnection.logAndWrap(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(Collection<Entity.Key> keys) throws DatabaseException {
        Objects.requireNonNull(keys);
        try {
            HttpClient httpClient = this.httpClient;
            synchronized (httpClient) {
                DefaultHttpEntityConnection.throwIfError(this.execute(this.createRequest("deleteByKey", Serializer.serialize(keys))));
            }
        }
        catch (DatabaseException e) {
            throw e;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw DefaultHttpEntityConnection.logAndWrap(e);
        }
        catch (Exception e) {
            throw DefaultHttpEntityConnection.logAndWrap(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int delete(Condition condition) throws DatabaseException {
        Objects.requireNonNull(condition);
        try {
            HttpClient httpClient = this.httpClient;
            synchronized (httpClient) {
                return (Integer)DefaultHttpEntityConnection.handleResponse(this.execute(this.createRequest("delete", Serializer.serialize((Object)condition))));
            }
        }
        catch (DatabaseException e) {
            throw e;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw DefaultHttpEntityConnection.logAndWrap(e);
        }
        catch (Exception e) {
            throw DefaultHttpEntityConnection.logAndWrap(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> List<T> select(Column<T> column, EntityConnection.Select select) throws DatabaseException {
        Objects.requireNonNull(column);
        Objects.requireNonNull(select);
        try {
            HttpClient httpClient = this.httpClient;
            synchronized (httpClient) {
                return (List)DefaultHttpEntityConnection.handleResponse(this.execute(this.createRequest("values", Serializer.serialize(Arrays.asList(column, select)))));
            }
        }
        catch (DatabaseException e) {
            throw e;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw DefaultHttpEntityConnection.logAndWrap(e);
        }
        catch (Exception e) {
            throw DefaultHttpEntityConnection.logAndWrap(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Entity> select(Collection<Entity.Key> keys) throws DatabaseException {
        Objects.requireNonNull(keys, "keys");
        try {
            HttpClient httpClient = this.httpClient;
            synchronized (httpClient) {
                return (List)DefaultHttpEntityConnection.handleResponse(this.execute(this.createRequest("selectByKey", Serializer.serialize(keys))));
            }
        }
        catch (DatabaseException e) {
            throw e;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw DefaultHttpEntityConnection.logAndWrap(e);
        }
        catch (Exception e) {
            throw DefaultHttpEntityConnection.logAndWrap(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Entity> select(EntityConnection.Select select) throws DatabaseException {
        Objects.requireNonNull(select, "select");
        try {
            HttpClient httpClient = this.httpClient;
            synchronized (httpClient) {
                return (List)DefaultHttpEntityConnection.handleResponse(this.execute(this.createRequest("select", Serializer.serialize((Object)select))));
            }
        }
        catch (DatabaseException e) {
            throw e;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw DefaultHttpEntityConnection.logAndWrap(e);
        }
        catch (Exception e) {
            throw DefaultHttpEntityConnection.logAndWrap(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<EntityType, Collection<Entity>> dependencies(Collection<? extends Entity> entities) throws DatabaseException {
        Objects.requireNonNull(entities, "entities");
        try {
            HttpClient httpClient = this.httpClient;
            synchronized (httpClient) {
                return (Map)DefaultHttpEntityConnection.handleResponse(this.execute(this.createRequest("dependencies", Serializer.serialize(entities))));
            }
        }
        catch (DatabaseException e) {
            throw e;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw DefaultHttpEntityConnection.logAndWrap(e);
        }
        catch (Exception e) {
            throw DefaultHttpEntityConnection.logAndWrap(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int count(EntityConnection.Count count) throws DatabaseException {
        Objects.requireNonNull(count);
        try {
            HttpClient httpClient = this.httpClient;
            synchronized (httpClient) {
                return (Integer)DefaultHttpEntityConnection.handleResponse(this.execute(this.createRequest("count", Serializer.serialize((Object)count))));
            }
        }
        catch (DatabaseException e) {
            throw e;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw DefaultHttpEntityConnection.logAndWrap(e);
        }
        catch (Exception e) {
            throw DefaultHttpEntityConnection.logAndWrap(e);
        }
    }
}

