/*
 * Decompiled with CFR 0.152.
 */
package is.codion.framework.db.http;

import is.codion.framework.db.AbstractEntityConnectionProvider;
import is.codion.framework.db.EntityConnection;
import is.codion.framework.db.http.DefaultHttpEntityConnectionProviderBuilder;
import is.codion.framework.db.http.HttpEntityConnection;
import is.codion.framework.db.http.HttpEntityConnectionProvider;
import java.util.Objects;
import java.util.concurrent.Executor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class DefaultHttpEntityConnectionProvider
extends AbstractEntityConnectionProvider
implements HttpEntityConnectionProvider {
    private static final Logger LOG = LoggerFactory.getLogger(HttpEntityConnectionProvider.class);
    private final String hostName;
    private final int port;
    private final int securePort;
    private final boolean https;
    private final boolean json;
    private final int socketTimeout;
    private final int connectTimeout;
    private final Executor executor;

    DefaultHttpEntityConnectionProvider(DefaultHttpEntityConnectionProviderBuilder builder) {
        super((AbstractEntityConnectionProvider.AbstractBuilder)builder);
        this.hostName = Objects.requireNonNull(builder.hostName, "hostName");
        this.port = builder.port;
        this.securePort = builder.securePort;
        this.https = builder.https;
        this.json = builder.json;
        this.socketTimeout = builder.socketTimeout;
        this.connectTimeout = builder.connectTimeout;
        this.executor = builder.executor;
    }

    public String connectionType() {
        return "http";
    }

    public String description() {
        return this.hostName;
    }

    protected EntityConnection connect() {
        try {
            LOG.debug("Initializing connection for {}", (Object)this.user());
            return HttpEntityConnection.builder().domainType(this.domainType()).hostName(this.hostName).port(this.port).securePort(this.securePort).user(this.user()).clientTypeId(this.clientTypeId()).clientId(this.clientId()).json(this.json).https(this.https).socketTimeout(this.socketTimeout).connectTimeout(this.connectTimeout).executor(this.executor).build();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected void close(EntityConnection connection) {
        connection.close();
    }
}

