/*
 * Decompiled with CFR 0.152.
 */
package is.codion.framework.db.http;

import is.codion.framework.db.AbstractEntityConnectionProvider;
import is.codion.framework.db.http.AbstractHttpEntityConnection;
import is.codion.framework.db.http.DefaultHttpEntityConnectionProvider;
import is.codion.framework.db.http.HttpEntityConnection;
import is.codion.framework.db.http.HttpEntityConnectionProvider;
import java.util.Objects;
import java.util.concurrent.Executor;

public final class DefaultHttpEntityConnectionProviderBuilder
extends AbstractEntityConnectionProvider.AbstractBuilder<HttpEntityConnectionProvider, HttpEntityConnectionProvider.Builder>
implements HttpEntityConnectionProvider.Builder {
    String hostName = (String)HttpEntityConnection.HOSTNAME.get();
    int port = (Integer)HttpEntityConnection.PORT.get();
    int securePort = (Integer)HttpEntityConnection.SECURE_PORT.get();
    boolean https = (Boolean)HttpEntityConnection.SECURE.get();
    boolean json = (Boolean)HttpEntityConnection.JSON.get();
    int socketTimeout = (Integer)HttpEntityConnection.SOCKET_TIMEOUT.get();
    int connectTimeout = (Integer)HttpEntityConnection.CONNECT_TIMEOUT.get();
    Executor executor = AbstractHttpEntityConnection.DEFAULT_EXECUTOR;

    public DefaultHttpEntityConnectionProviderBuilder() {
        super("http");
    }

    @Override
    public HttpEntityConnectionProvider.Builder hostName(String hostName) {
        this.hostName = Objects.requireNonNull(hostName);
        return this;
    }

    @Override
    public HttpEntityConnectionProvider.Builder port(int port) {
        this.port = port;
        return this;
    }

    @Override
    public HttpEntityConnectionProvider.Builder securePort(int securePort) {
        this.securePort = securePort;
        return this;
    }

    @Override
    public HttpEntityConnectionProvider.Builder https(boolean https) {
        this.https = https;
        return this;
    }

    @Override
    public HttpEntityConnectionProvider.Builder json(boolean json) {
        this.json = json;
        return this;
    }

    @Override
    public HttpEntityConnectionProvider.Builder socketTimeout(int socketTimeout) {
        this.socketTimeout = socketTimeout;
        return this;
    }

    @Override
    public HttpEntityConnectionProvider.Builder connectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
        return this;
    }

    @Override
    public HttpEntityConnectionProvider.Builder executor(Executor executor) {
        this.executor = Objects.requireNonNull(executor);
        return this;
    }

    public HttpEntityConnectionProvider build() {
        return new DefaultHttpEntityConnectionProvider(this);
    }
}

