/*
 * Decompiled with CFR 0.152.
 */
package is.codion.framework.db.http;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import is.codion.common.db.exception.DatabaseException;
import is.codion.framework.db.EntityConnection;
import is.codion.framework.db.http.AbstractHttpEntityConnection;
import is.codion.framework.domain.DomainType;
import is.codion.framework.domain.entity.Entity;
import is.codion.framework.domain.entity.EntityType;
import is.codion.framework.domain.entity.attribute.Column;
import is.codion.framework.domain.entity.condition.Condition;
import is.codion.framework.json.db.DatabaseObjectMapper;
import is.codion.framework.json.domain.EntityObjectMapper;
import is.codion.framework.json.domain.EntityObjectMapperFactory;
import java.io.IOException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

final class JsonHttpEntityConnection
extends AbstractHttpEntityConnection {
    private final ObjectMapper objectMapper;

    JsonHttpEntityConnection(AbstractHttpEntityConnection.DefaultBuilder builder) {
        super(builder, "/entities/json/");
        this.objectMapper = DatabaseObjectMapper.databaseObjectMapper((EntityObjectMapper)EntityObjectMapperFactory.instance((DomainType)this.entities().domainType()).entityObjectMapper(this.entities));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean transactionOpen() {
        try {
            HttpClient httpClient = this.httpClient;
            synchronized (httpClient) {
                return JsonHttpEntityConnection.handleJsonResponse(this.executeJson(this.createJsonRequest("isTransactionOpen")), this.objectMapper, Boolean.class);
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw JsonHttpEntityConnection.logAndWrap(e);
        }
        catch (Exception e) {
            throw JsonHttpEntityConnection.logAndWrap(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setQueryCacheEnabled(boolean queryCacheEnabled) {
        try {
            HttpClient httpClient = this.httpClient;
            synchronized (httpClient) {
                JsonHttpEntityConnection.handleResponse(this.execute(this.createJsonRequest("setQueryCacheEnabled", this.objectMapper.writeValueAsString((Object)queryCacheEnabled))));
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw JsonHttpEntityConnection.logAndWrap(e);
        }
        catch (Exception e) {
            throw JsonHttpEntityConnection.logAndWrap(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isQueryCacheEnabled() {
        try {
            HttpClient httpClient = this.httpClient;
            synchronized (httpClient) {
                return JsonHttpEntityConnection.handleJsonResponse(this.executeJson(this.createJsonRequest("isQueryCacheEnabled")), this.objectMapper, Boolean.class);
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw JsonHttpEntityConnection.logAndWrap(e);
        }
        catch (Exception e) {
            throw JsonHttpEntityConnection.logAndWrap(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<Entity.Key> insert(Collection<? extends Entity> entities) throws DatabaseException {
        Objects.requireNonNull(entities);
        try {
            HttpClient httpClient = this.httpClient;
            synchronized (httpClient) {
                return (Collection)JsonHttpEntityConnection.handleJsonResponse(this.executeJson(this.createJsonRequest("insert", this.objectMapper.writeValueAsString(entities))), this.objectMapper, EntityObjectMapper.KEY_LIST_REFERENCE);
            }
        }
        catch (DatabaseException e) {
            throw e;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw JsonHttpEntityConnection.logAndWrap(e);
        }
        catch (Exception e) {
            throw JsonHttpEntityConnection.logAndWrap(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<Entity> insertSelect(Collection<? extends Entity> entities) throws DatabaseException {
        Objects.requireNonNull(entities);
        try {
            HttpClient httpClient = this.httpClient;
            synchronized (httpClient) {
                return (Collection)JsonHttpEntityConnection.handleJsonResponse(this.executeJson(this.createJsonRequest("insertSelect", this.objectMapper.writeValueAsString(entities))), this.objectMapper, EntityObjectMapper.ENTITY_LIST_REFERENCE);
            }
        }
        catch (DatabaseException e) {
            throw e;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw JsonHttpEntityConnection.logAndWrap(e);
        }
        catch (Exception e) {
            throw JsonHttpEntityConnection.logAndWrap(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(Collection<? extends Entity> entities) throws DatabaseException {
        Objects.requireNonNull(entities);
        try {
            HttpClient httpClient = this.httpClient;
            synchronized (httpClient) {
                JsonHttpEntityConnection.throwIfError(this.executeJson(this.createJsonRequest("update", this.objectMapper.writeValueAsString(entities))));
            }
        }
        catch (DatabaseException e) {
            throw e;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw JsonHttpEntityConnection.logAndWrap(e);
        }
        catch (Exception e) {
            throw JsonHttpEntityConnection.logAndWrap(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<Entity> updateSelect(Collection<? extends Entity> entities) throws DatabaseException {
        Objects.requireNonNull(entities);
        try {
            HttpClient httpClient = this.httpClient;
            synchronized (httpClient) {
                return (Collection)JsonHttpEntityConnection.handleJsonResponse(this.executeJson(this.createJsonRequest("updateSelect", this.objectMapper.writeValueAsString(entities))), this.objectMapper, EntityObjectMapper.ENTITY_LIST_REFERENCE);
            }
        }
        catch (DatabaseException e) {
            throw e;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw JsonHttpEntityConnection.logAndWrap(e);
        }
        catch (Exception e) {
            throw JsonHttpEntityConnection.logAndWrap(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int update(EntityConnection.Update update) throws DatabaseException {
        Objects.requireNonNull(update);
        try {
            HttpClient httpClient = this.httpClient;
            synchronized (httpClient) {
                return JsonHttpEntityConnection.handleJsonResponse(this.executeJson(this.createJsonRequest("updateByCondition", this.objectMapper.writeValueAsString((Object)update))), this.objectMapper, Integer.class);
            }
        }
        catch (DatabaseException e) {
            throw e;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw JsonHttpEntityConnection.logAndWrap(e);
        }
        catch (Exception e) {
            throw JsonHttpEntityConnection.logAndWrap(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(Collection<Entity.Key> keys) throws DatabaseException {
        Objects.requireNonNull(keys);
        try {
            HttpClient httpClient = this.httpClient;
            synchronized (httpClient) {
                JsonHttpEntityConnection.throwIfError(this.executeJson(this.createJsonRequest("deleteByKey", this.objectMapper.writeValueAsString(keys))));
            }
        }
        catch (DatabaseException e) {
            throw e;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw JsonHttpEntityConnection.logAndWrap(e);
        }
        catch (Exception e) {
            throw JsonHttpEntityConnection.logAndWrap(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int delete(Condition condition) throws DatabaseException {
        Objects.requireNonNull(condition);
        try {
            HttpClient httpClient = this.httpClient;
            synchronized (httpClient) {
                return JsonHttpEntityConnection.handleJsonResponse(this.executeJson(this.createJsonRequest("delete", this.objectMapper.writeValueAsString((Object)condition))), this.objectMapper, Integer.class);
            }
        }
        catch (DatabaseException e) {
            throw e;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw JsonHttpEntityConnection.logAndWrap(e);
        }
        catch (Exception e) {
            throw JsonHttpEntityConnection.logAndWrap(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> List<T> select(Column<T> column, EntityConnection.Select select) throws DatabaseException {
        Objects.requireNonNull(column);
        Objects.requireNonNull(select);
        try {
            ObjectNode node = this.objectMapper.createObjectNode();
            node.set("column", this.objectMapper.valueToTree((Object)column.name()));
            node.set("entityType", this.objectMapper.valueToTree((Object)column.entityType().name()));
            node.set("condition", this.objectMapper.valueToTree((Object)select));
            HttpClient httpClient = this.httpClient;
            synchronized (httpClient) {
                return (List)JsonHttpEntityConnection.handleJsonResponse(this.executeJson(this.createJsonRequest("values", node.toString())), this.objectMapper, (JavaType)this.objectMapper.getTypeFactory().constructCollectionType(List.class, column.type().valueClass()));
            }
        }
        catch (DatabaseException e) {
            throw e;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw JsonHttpEntityConnection.logAndWrap(e);
        }
        catch (Exception e) {
            throw JsonHttpEntityConnection.logAndWrap(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Entity> select(Collection<Entity.Key> keys) throws DatabaseException {
        Objects.requireNonNull(keys, "keys");
        try {
            HttpClient httpClient = this.httpClient;
            synchronized (httpClient) {
                return (List)JsonHttpEntityConnection.handleJsonResponse(this.executeJson(this.createJsonRequest("selectByKey", this.objectMapper.writeValueAsString(keys))), this.objectMapper, EntityObjectMapper.ENTITY_LIST_REFERENCE);
            }
        }
        catch (DatabaseException e) {
            throw e;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw JsonHttpEntityConnection.logAndWrap(e);
        }
        catch (Exception e) {
            throw JsonHttpEntityConnection.logAndWrap(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Entity> select(EntityConnection.Select select) throws DatabaseException {
        Objects.requireNonNull(select, "select");
        try {
            HttpClient httpClient = this.httpClient;
            synchronized (httpClient) {
                return (List)JsonHttpEntityConnection.handleJsonResponse(this.executeJson(this.createJsonRequest("select", this.objectMapper.writeValueAsString((Object)select))), this.objectMapper, EntityObjectMapper.ENTITY_LIST_REFERENCE);
            }
        }
        catch (DatabaseException e) {
            throw e;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw JsonHttpEntityConnection.logAndWrap(e);
        }
        catch (Exception e) {
            throw JsonHttpEntityConnection.logAndWrap(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<EntityType, Collection<Entity>> dependencies(Collection<? extends Entity> entities) throws DatabaseException {
        Objects.requireNonNull(entities, "entities");
        try {
            HashMap<EntityType, Collection<Entity>> dependencies = new HashMap<EntityType, Collection<Entity>>();
            DomainType domainType = this.entities().domainType();
            HttpClient httpClient = this.httpClient;
            synchronized (httpClient) {
                Map<String, Collection<Entity>> dependencyMap = JsonHttpEntityConnection.handleJsonResponse(this.executeJson(this.createJsonRequest("dependencies", this.objectMapper.writeValueAsString(entities))), this.objectMapper, new TypeReference<Map<String, Collection<Entity>>>(){});
                dependencyMap.forEach((entityTypeName, deps) -> dependencies.put(domainType.entityType(entityTypeName), (Collection<Entity>)deps));
                return dependencies;
            }
        }
        catch (DatabaseException e) {
            throw e;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw JsonHttpEntityConnection.logAndWrap(e);
        }
        catch (Exception e) {
            throw JsonHttpEntityConnection.logAndWrap(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int count(EntityConnection.Count count) throws DatabaseException {
        Objects.requireNonNull(count);
        try {
            HttpClient httpClient = this.httpClient;
            synchronized (httpClient) {
                return JsonHttpEntityConnection.handleJsonResponse(this.executeJson(this.createJsonRequest("count", this.objectMapper.writeValueAsString((Object)count))), this.objectMapper, Integer.class);
            }
        }
        catch (DatabaseException e) {
            throw e;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw JsonHttpEntityConnection.logAndWrap(e);
        }
        catch (Exception e) {
            throw JsonHttpEntityConnection.logAndWrap(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> HttpResponse<T> executeJson(HttpRequest operation) throws IOException, InterruptedException {
        HttpClient httpClient = this.httpClient;
        synchronized (httpClient) {
            return this.httpClient.send(operation, HttpResponse.BodyHandlers.ofByteArray());
        }
    }

    private HttpRequest createJsonRequest(String path) {
        return HttpRequest.newBuilder().timeout(this.socketTimeout).uri(URI.create(this.baseurl + path)).POST(HttpRequest.BodyPublishers.noBody()).headers(this.headers).build();
    }

    private HttpRequest createJsonRequest(String path, String data) {
        return HttpRequest.newBuilder().timeout(this.socketTimeout).uri(URI.create(this.baseurl + path)).POST(HttpRequest.BodyPublishers.ofString(data)).headers(this.headers).build();
    }

    private static <T> T handleJsonResponse(HttpResponse<?> response, ObjectMapper mapper, TypeReference<T> typeReference) throws Exception {
        JsonHttpEntityConnection.throwIfError(response);
        return (T)mapper.readValue(new String((byte[])response.body(), StandardCharsets.UTF_8), typeReference);
    }

    private static <T> T handleJsonResponse(HttpResponse<?> response, ObjectMapper mapper, Class<T> valueClass) throws Exception {
        JsonHttpEntityConnection.throwIfError(response);
        return (T)mapper.readValue(new String((byte[])response.body(), StandardCharsets.UTF_8), valueClass);
    }

    private static <T> T handleJsonResponse(HttpResponse<?> response, ObjectMapper mapper, JavaType javaType) throws Exception {
        JsonHttpEntityConnection.throwIfError(response);
        return (T)mapper.readValue(new String((byte[])response.body(), StandardCharsets.UTF_8), javaType);
    }
}

