/*
 * Decompiled with CFR 0.152.
 */
package javax.help.plaf.basic;

import com.sun.java.help.impl.JHelpPrintHandler;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Vector;
import javax.help.HelpModel;
import javax.help.HelpSet;
import javax.help.HelpUtilities;
import javax.help.JHelp;
import javax.help.JHelpContentViewer;
import javax.help.JHelpNavigator;
import javax.help.Map;
import javax.help.SwingHelpUtilities;
import javax.help.event.HelpModelEvent;
import javax.help.event.HelpModelListener;
import javax.help.plaf.HelpUI;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.plaf.ComponentUI;

public class BasicHelpUI
extends HelpUI
implements PropertyChangeListener,
Serializable {
    protected JHelp help;
    protected JToolBar toolbar;
    protected JSplitPane splitPane;
    protected JTabbedPane tabbedPane;
    protected Vector navs = new Vector();
    private Vector history = new Vector();
    private int historyIndex = -1;
    private static Dimension PREF_SIZE = new Dimension(600, 600);
    private static Dimension MIN_SIZE = new Dimension(300, 200);
    static boolean noPageSetup;
    static boolean on1dot1;
    private ImageIcon prev = this.getIcon("images/prev.gif");
    private ImageIcon next = this.getIcon("images/next.gif");
    private ImageIcon print = this.getIcon("images/print.gif");
    private ImageIcon pageSetup = this.getIcon("images/pageSetup.gif");
    private JButton prevButton;
    private JButton nextButton;
    private JButton printButton;
    private JButton pageSetupButton;
    private int dividerLocation = 0;
    private final double dividerLocationRatio = 0.3;
    private IdChangeListener changeListener = new IdChangeListener();
    private static boolean debug;
    static /* synthetic */ Class class$java$awt$Toolkit;
    static /* synthetic */ Class class$java$awt$datatransfer$DataFlavor;
    static /* synthetic */ Class class$javax$help$HelpModel;
    static /* synthetic */ Class class$java$awt$Component;
    static /* synthetic */ Class class$javax$help$plaf$basic$BasicHelpUI;

    static {
        on1dot1 = false;
        noPageSetup = false;
        try {
            Method method = (class$java$awt$Toolkit != null ? class$java$awt$Toolkit : (class$java$awt$Toolkit = BasicHelpUI.class$("java.awt.Toolkit"))).getMethod("getMaximumCursorColors", null);
            noPageSetup = method == null;
            on1dot1 = method == null;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            noPageSetup = true;
            on1dot1 = true;
        }
        if (!noPageSetup) {
            String[] stringArray;
            boolean bl = false;
            try {
                stringArray = (class$java$awt$datatransfer$DataFlavor != null ? class$java$awt$datatransfer$DataFlavor : (class$java$awt$datatransfer$DataFlavor = BasicHelpUI.class$("java.awt.datatransfer.DataFlavor"))).getMethod("getTextPlainUnicodeFlavor", null);
                bl = stringArray == null;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                bl = true;
            }
            stringArray = new String[]{""};
            stringArray[0] = System.getProperty("os.name");
            if (stringArray[0] != null && (stringArray[0].indexOf("Solaris") != -1 || stringArray[0].indexOf("SunOS") != -1) && bl) {
                noPageSetup = true;
            }
        }
        debug = false;
    }

    public BasicHelpUI(JHelp jHelp) {
        BasicHelpUI.debug("createUI - sort of");
    }

    public void addNavigator(JHelpNavigator jHelpNavigator) {
        BasicHelpUI.debug("addNavigator");
        this.navs.addElement(jHelpNavigator);
        Icon icon = jHelpNavigator.getIcon();
        if (icon != null) {
            this.tabbedPane.addTab("", icon, jHelpNavigator, jHelpNavigator.getNavigatorLabel());
        } else {
            String string = jHelpNavigator.getName();
            if (string == null) {
                string = "<unknown>";
            }
            this.tabbedPane.addTab(string, icon, jHelpNavigator);
        }
        this.tabbedPane.setVisible(this.help.isNavigatorDisplayed());
        this.help.invalidate();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if ((double)BasicHelpUI.this.dividerLocation == 0.0) {
                    Dimension dimension = BasicHelpUI.this.splitPane.getSize();
                    if (dimension.width != 0) {
                        BasicHelpUI.this.splitPane.setDividerLocation((int)((double)(dimension.width - BasicHelpUI.this.splitPane.getDividerSize()) * 0.3));
                    }
                    BasicHelpUI.this.dividerLocation = BasicHelpUI.this.splitPane.getDividerLocation();
                }
            }
        });
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private void computeHistoryButtons() {
        BasicHelpUI.debug("computeHistoryButtons");
        BasicHelpUI.debug("  historyIndex" + this.historyIndex);
        BasicHelpUI.debug("  history.size" + this.history.size());
        this.prevButton.setEnabled(this.historyIndex > 0);
        this.nextButton.setEnabled(this.historyIndex < this.history.size() - 1);
    }

    protected JToolBar createToolBar(Locale locale) {
        this.toolbar = new JToolBar();
        this.prevButton = new JButton(this.prev);
        this.prevButton.setEnabled(false);
        this.prevButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                BasicHelpUI.this.goBack();
            }
        });
        this.prevButton.setToolTipText(HelpUtilities.getString(locale, "tip.previous"));
        this.nextButton = new JButton(this.next);
        this.nextButton.setEnabled(false);
        this.nextButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                BasicHelpUI.this.goForward();
            }
        });
        this.nextButton.setToolTipText(HelpUtilities.getString(locale, "tip.next"));
        try {
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager != null) {
                securityManager.checkPrintJobAccess();
            }
            JHelpPrintHandler jHelpPrintHandler = null;
            this.printButton = new JButton(this.print);
            try {
                if (on1dot1) {
                    Class<?> clazz = Class.forName("com.sun.java.help.impl.JHelpPrintHandler");
                    Constructor<?> constructor = clazz.getConstructor(class$javax$help$HelpModel != null ? class$javax$help$HelpModel : (class$javax$help$HelpModel = BasicHelpUI.class$("javax.help.HelpModel")), class$java$awt$Component != null ? class$java$awt$Component : (class$java$awt$Component = BasicHelpUI.class$("java.awt.Component")));
                    jHelpPrintHandler = (JHelpPrintHandler)constructor.newInstance(this.getModel(), this.printButton);
                } else {
                    Class<?> clazz = Class.forName("com.sun.java.help.impl.JHelpPrintHandler1_2");
                    Constructor<?> constructor = clazz.getConstructor(class$javax$help$HelpModel != null ? class$javax$help$HelpModel : (class$javax$help$HelpModel = BasicHelpUI.class$("javax.help.HelpModel")), class$java$awt$Component != null ? class$java$awt$Component : (class$java$awt$Component = BasicHelpUI.class$("java.awt.Component")));
                    jHelpPrintHandler = (JHelpPrintHandler)constructor.newInstance(this.getModel(), this.printButton);
                }
            }
            catch (Throwable throwable) {}
            this.printButton.addActionListener(jHelpPrintHandler);
            this.printButton.setToolTipText(HelpUtilities.getString(locale, "tip.print"));
            this.pageSetupButton = null;
            if (!noPageSetup) {
                this.pageSetupButton = new JButton(this.pageSetup);
                jHelpPrintHandler.handlePageSetup(this.pageSetupButton);
                this.pageSetupButton.addActionListener(jHelpPrintHandler);
                this.pageSetupButton.setToolTipText(HelpUtilities.getString(locale, "tip.pageSetup"));
            }
        }
        catch (SecurityException securityException) {}
        this.toolbar.add(this.prevButton);
        this.toolbar.add(this.nextButton);
        this.toolbar.add(new JToolBar.Separator());
        if (this.printButton != null) {
            this.toolbar.add(this.printButton);
        }
        if (this.pageSetupButton != null) {
            this.toolbar.add(this.pageSetupButton);
        }
        return this.toolbar;
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new BasicHelpUI((JHelp)jComponent);
    }

    private static void debug(String string) {
        if (debug) {
            System.out.println("BasicHelpUI: " + string);
        }
    }

    private void discardHistory() {
        this.history.setSize(0);
        this.historyIndex = -1;
        this.prevButton.setEnabled(false);
        this.nextButton.setEnabled(false);
    }

    public JHelpNavigator getCurrentNavigator() {
        return (JHelpNavigator)this.tabbedPane.getSelectedComponent();
    }

    public Enumeration getHelpNavigators() {
        return this.navs.elements();
    }

    public static ImageIcon getIcon(Class clazz, String string) {
        ImageIcon imageIcon = null;
        try {
            imageIcon = SwingHelpUtilities.getImageIcon(clazz, string);
        }
        catch (Exception exception) {}
        if (debug || imageIcon == null) {
            System.err.println("GetIcon");
            System.err.println("  name: " + string);
            System.err.println("  klass: " + clazz);
            URL uRL = clazz.getResource(string);
            System.err.println("  URL is " + uRL);
            System.err.println("  ImageIcon is " + imageIcon);
        }
        return imageIcon;
    }

    private ImageIcon getIcon(String string) {
        return BasicHelpUI.getIcon(class$javax$help$plaf$basic$BasicHelpUI != null ? class$javax$help$plaf$basic$BasicHelpUI : (class$javax$help$plaf$basic$BasicHelpUI = BasicHelpUI.class$("javax.help.plaf.basic.BasicHelpUI")), string);
    }

    public Dimension getMaximumSize(JComponent jComponent) {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    public Dimension getMinimumSize(JComponent jComponent) {
        return MIN_SIZE;
    }

    protected HelpModel getModel() {
        if (this.help == null) {
            return null;
        }
        return this.help.getModel();
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        return PREF_SIZE;
    }

    protected void goBack() {
        this.gotoHistoryEntry(this.historyIndex - 1);
    }

    protected void goForward() {
        this.gotoHistoryEntry(this.historyIndex + 1);
    }

    private void gotoHistoryEntry(int n) {
        BasicHelpUI.debug("gotoHistoryEntry(" + n + ")");
        HelpModel helpModel = this.getModel();
        if (helpModel == null) {
            return;
        }
        if (n < 0 || n >= this.history.size()) {
            this.discardHistory();
            return;
        }
        HelpModelEvent helpModelEvent = (HelpModelEvent)this.history.elementAt(n);
        this.historyIndex = n - 1;
        Map.ID iD = helpModelEvent.getID();
        URL uRL = helpModelEvent.getURL();
        if (iD != null) {
            try {
                BasicHelpUI.debug("  setCurrentID" + iD);
                helpModel.setCurrentID(iD);
                return;
            }
            catch (Exception exception) {}
        }
        if (uRL != null) {
            try {
                BasicHelpUI.debug("  setCurrentURL" + uRL);
                helpModel.setCurrentURL(uRL);
                return;
            }
            catch (Exception exception) {}
        }
        this.discardHistory();
    }

    public void installUI(JComponent jComponent) {
        BasicHelpUI.debug("installUI");
        this.help = (JHelp)jComponent;
        this.help.setLayout(new BorderLayout());
        this.help.addPropertyChangeListener(this);
        HelpModel helpModel = this.getModel();
        if (helpModel != null) {
            helpModel.addHelpModelListener(this.changeListener);
        }
        this.toolbar = this.createToolBar(HelpUtilities.getLocale(jComponent));
        this.toolbar.setFloatable(false);
        this.help.add("North", this.toolbar);
        this.tabbedPane = new JTabbedPane();
        this.tabbedPane.setVisible(false);
        this.splitPane = new JSplitPane(1, false, this.tabbedPane, this.help.getContentViewer());
        this.splitPane.setOneTouchExpandable(true);
        this.help.add("Center", this.splitPane);
        this.rebuild();
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        BasicHelpUI.debug("propertyChange: " + propertyChangeEvent.getPropertyName());
        if (propertyChangeEvent.getSource() == this.help) {
            String string = propertyChangeEvent.getPropertyName();
            if (string.equals("helpModel")) {
                this.rebuild();
            } else if (string.equals("font")) {
                BasicHelpUI.debug("Font change");
                Font font = (Font)propertyChangeEvent.getNewValue();
                this.help.getContentViewer().setFont(font);
                this.help.getContentViewer().invalidate();
                Enumeration enumeration = this.help.getHelpNavigators();
                while (enumeration.hasMoreElements()) {
                    JHelpNavigator jHelpNavigator = (JHelpNavigator)enumeration.nextElement();
                    jHelpNavigator.setFont(font);
                }
            } else if (string.equals("navigatorDisplayed")) {
                this.tabbedPane.setVisible((Boolean)propertyChangeEvent.getNewValue());
            }
        }
    }

    private void rebuild() {
        HelpModel helpModel = this.getModel();
        if (helpModel == null) {
            return;
        }
        this.discardHistory();
        HelpSet helpSet = helpModel.getHelpSet();
        JHelpContentViewer jHelpContentViewer = this.help.getContentViewer();
        try {
            Map.ID iD = helpSet.getHomeID();
            jHelpContentViewer.setCurrentID(iD);
            Map map = helpSet.getCombinedMap();
            URL uRL = map.getURLFromID(iD);
        }
        catch (MalformedURLException malformedURLException) {
            BasicHelpUI.debug("No HomeID found - ignoring it...");
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    public void removeNavigator(JHelpNavigator jHelpNavigator) {
        BasicHelpUI.debug("removeNavigator");
        this.navs.removeElement(jHelpNavigator);
        this.tabbedPane.remove(jHelpNavigator);
        this.help.invalidate();
    }

    public void setCurrentNavigator(JHelpNavigator jHelpNavigator) {
        if (jHelpNavigator == (JHelpNavigator)this.tabbedPane.getSelectedComponent()) {
            return;
        }
        int n = this.navs.size();
        int n2 = 0;
        while (n2 < n) {
            JHelpNavigator jHelpNavigator2 = (JHelpNavigator)this.navs.elementAt(n2);
            if (jHelpNavigator2 == jHelpNavigator) {
                this.tabbedPane.setSelectedIndex(n2);
                return;
            }
            ++n2;
        }
        throw new IllegalArgumentException("JHelpNavigator must be added first");
    }

    public void uninstallUI(JComponent jComponent) {
        BasicHelpUI.debug("uninstallUI");
        this.help.removePropertyChangeListener(this);
        this.help.setLayout(null);
        this.help.removeAll();
        HelpModel helpModel = this.getModel();
        if (helpModel != null) {
            helpModel.removeHelpModelListener(this.changeListener);
        }
        this.help = null;
        this.toolbar = null;
    }

    private class IdChangeListener
    implements HelpModelListener {
        IdChangeListener() {
        }

        public void idChanged(HelpModelEvent helpModelEvent) {
            BasicHelpUI.debug("idChanged(" + helpModelEvent + ")");
            BasicHelpUI.debug("  historyIndex==" + BasicHelpUI.this.historyIndex);
            BasicHelpUI.debug("  history.size==" + BasicHelpUI.this.history.size());
            if (BasicHelpUI.this.historyIndex == BasicHelpUI.this.history.size() - 1) {
                BasicHelpUI.this.history.addElement(helpModelEvent);
                BasicHelpUI basicHelpUI = BasicHelpUI.this;
                basicHelpUI.historyIndex = basicHelpUI.historyIndex + 1;
                BasicHelpUI.this.computeHistoryButtons();
                return;
            }
            if (BasicHelpUI.this.historyIndex >= -1 && BasicHelpUI.this.historyIndex < BasicHelpUI.this.history.size() - 1) {
                BasicHelpUI basicHelpUI = BasicHelpUI.this;
                basicHelpUI.historyIndex = basicHelpUI.historyIndex + 1;
                HelpModelEvent helpModelEvent2 = (HelpModelEvent)BasicHelpUI.this.history.elementAt(BasicHelpUI.this.historyIndex);
                if (helpModelEvent2 == null) {
                    BasicHelpUI.this.discardHistory();
                    return;
                }
                if (helpModelEvent2.getID() != null && helpModelEvent.getID() != null && helpModelEvent2.getID().equals(helpModelEvent.getID())) {
                    BasicHelpUI.this.computeHistoryButtons();
                    return;
                }
                if (helpModelEvent2.getURL() != null && helpModelEvent.getURL() != null && helpModelEvent2.getURL().sameFile(helpModelEvent.getURL())) {
                    BasicHelpUI.this.computeHistoryButtons();
                    return;
                }
                BasicHelpUI.this.history.setSize(BasicHelpUI.this.historyIndex);
                BasicHelpUI.this.history.addElement(helpModelEvent);
                BasicHelpUI.this.computeHistoryButtons();
            }
        }
    }
}

