/*
 * Decompiled with CFR 0.152.
 */
package javax.faces.validator;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.application.FacesMessage;
import javax.faces.component.PartialStateHolder;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.validator.MessageFactory;
import javax.faces.validator.Validator;
import javax.faces.validator.ValidatorException;
import javax.faces.validator.ValueExpressionAnalyzer;
import javax.faces.validator.ValueReference;
import javax.validation.ConstraintViolation;
import javax.validation.MessageInterpolator;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.ValidatorContext;
import javax.validation.ValidatorFactory;
import javax.validation.groups.Default;

public class BeanValidator
implements Validator,
PartialStateHolder {
    private static final Logger LOGGER = Logger.getLogger("javax.faces.validator", "javax.faces.LogStrings");
    private String validationGroups;
    private transient Class[] cachedValidationGroups;
    public static final String VALIDATOR_ID = "javax.faces.Bean";
    public static final String MESSAGE_ID = "javax.faces.validator.BeanValidator.MESSAGE";
    public static final String VALIDATOR_FACTORY_KEY = "javax.faces.validator.beanValidator.ValidatorFactory";
    public static final String VALIDATION_GROUPS_DELIMITER = ",";
    public static final String EMPTY_VALIDATION_GROUPS_PATTERN = "^[\\W,]*$";
    public static final String DISABLE_DEFAULT_BEAN_VALIDATOR_PARAM_NAME = "javax.faces.validator.DISABLE_DEFAULT_BEAN_VALIDATOR";
    private boolean initialState;
    private boolean transientValue = false;

    public void setValidationGroups(String validationGroups) {
        this.clearInitialState();
        if (validationGroups != null && validationGroups.matches(EMPTY_VALIDATION_GROUPS_PATTERN)) {
            validationGroups = null;
        }
        if (validationGroups == null && this.validationGroups != null || validationGroups != null && !validationGroups.equals(this.validationGroups)) {
            this.cachedValidationGroups = null;
        }
        this.validationGroups = validationGroups;
    }

    public String getValidationGroups() {
        return this.validationGroups;
    }

    public void validate(FacesContext context, UIComponent component, Object value) {
        ValidatorFactory validatorFactory;
        ValueExpression valueExpression = component.getValueExpression("value");
        if (valueExpression == null) {
            return;
        }
        Object cachedObject = context.getExternalContext().getApplicationMap().get(VALIDATOR_FACTORY_KEY);
        if (cachedObject instanceof ValidatorFactory) {
            validatorFactory = (ValidatorFactory)cachedObject;
        } else {
            try {
                validatorFactory = Validation.buildDefaultValidatorFactory();
            }
            catch (ValidationException e) {
                throw new FacesException("Could not build a default Bean Validator factory", e);
            }
            context.getExternalContext().getApplicationMap().put(VALIDATOR_FACTORY_KEY, validatorFactory);
        }
        ValidatorContext validatorContext = validatorFactory.usingContext();
        JsfAwareMessageInterpolator jsfMessageInterpolator = new JsfAwareMessageInterpolator(context, validatorFactory.getMessageInterpolator());
        validatorContext.messageInterpolator((MessageInterpolator)jsfMessageInterpolator);
        javax.validation.Validator beanValidator = validatorContext.getValidator();
        Class[] validationGroupsArray = this.parseValidationGroups(this.getValidationGroups());
        ValueExpressionAnalyzer expressionAnalyzer = new ValueExpressionAnalyzer(valueExpression);
        ValueReference valueReference = expressionAnalyzer.getReference(context.getELContext());
        if (valueReference == null) {
            return;
        }
        if (this.isResolvable(valueReference, valueExpression)) {
            Set violations = null;
            try {
                violations = beanValidator.validateValue(valueReference.getBaseClass(), valueReference.getProperty(), value, validationGroupsArray);
            }
            catch (IllegalArgumentException iae) {
                String failureMessage = "Unable to validate expression " + valueExpression.getExpressionString() + " using Bean Validation.  Unable to get value of expression. " + " Message from Bean Validation: " + iae.getMessage();
                LOGGER.fine(failureMessage);
            }
            if (violations != null && !violations.isEmpty()) {
                ValidatorException toThrow;
                if (1 == violations.size()) {
                    ConstraintViolation violation = (ConstraintViolation)violations.iterator().next();
                    toThrow = new ValidatorException(MessageFactory.getMessage(context, MESSAGE_ID, violation.getMessage(), MessageFactory.getLabel(context, component)));
                } else {
                    LinkedHashSet<FacesMessage> messages = new LinkedHashSet<FacesMessage>(violations.size());
                    for (ConstraintViolation violation : violations) {
                        messages.add(MessageFactory.getMessage(context, MESSAGE_ID, violation.getMessage(), MessageFactory.getLabel(context, component)));
                    }
                    toThrow = new ValidatorException(messages);
                }
                throw toThrow;
            }
        }
    }

    private boolean isResolvable(ValueReference ref, ValueExpression valueExpression) {
        Boolean result = null;
        String failureMessage = null;
        if (null == valueExpression) {
            failureMessage = "Unable to validate expression using Bean Validation.  Expression must not be null.";
            result = false;
        } else if (null == ref) {
            failureMessage = "Unable to validate expression " + valueExpression.getExpressionString() + " using Bean Validation.  Unable to get value of expression.";
            result = false;
        } else {
            Class baseClass = ref.getBaseClass();
            if (null != baseClass && (Map.class.isAssignableFrom(baseClass) || Collection.class.isAssignableFrom(baseClass) || Array.class.isAssignableFrom(baseClass))) {
                failureMessage = "Unable to validate expression " + valueExpression.getExpressionString() + " using Bean Validation.  Expression evaluates to a Map, List or array.";
                result = false;
            }
        }
        result = null != result ? result : true;
        if (!result.booleanValue()) {
            LOGGER.fine(failureMessage);
        }
        return result;
    }

    private Class[] parseValidationGroups(String validationGroupsStr) {
        String[] classNames;
        if (this.cachedValidationGroups != null) {
            return this.cachedValidationGroups;
        }
        if (validationGroupsStr == null) {
            this.cachedValidationGroups = new Class[]{Default.class};
            return this.cachedValidationGroups;
        }
        ArrayList validationGroupsList = new ArrayList();
        for (String className : classNames = validationGroupsStr.split(VALIDATION_GROUPS_DELIMITER)) {
            if ((className = className.trim()).length() == 0) continue;
            if (className.equals(Default.class.getName())) {
                validationGroupsList.add(Default.class);
                continue;
            }
            try {
                validationGroupsList.add(Class.forName(className, false, Thread.currentThread().getContextClassLoader()));
            }
            catch (ClassNotFoundException e1) {
                try {
                    validationGroupsList.add(Class.forName(className));
                }
                catch (ClassNotFoundException e2) {
                    throw new FacesException("Validation group not found: " + className);
                }
            }
        }
        this.cachedValidationGroups = validationGroupsList.toArray(new Class[validationGroupsList.size()]);
        return this.cachedValidationGroups;
    }

    public Object saveState(FacesContext context) {
        if (!this.initialStateMarked()) {
            Object[] values = new Object[]{this.validationGroups};
            return values;
        }
        return null;
    }

    public void restoreState(FacesContext context, Object state) {
        if (state != null) {
            Object[] values = (Object[])state;
            this.validationGroups = (String)values[0];
        }
    }

    public void markInitialState() {
        this.initialState = true;
    }

    public boolean initialStateMarked() {
        return this.initialState;
    }

    public void clearInitialState() {
        this.initialState = false;
    }

    public boolean isTransient() {
        return this.transientValue;
    }

    public void setTransient(boolean transientValue) {
        this.transientValue = transientValue;
    }

    private static class JsfAwareMessageInterpolator
    implements MessageInterpolator {
        private FacesContext context;
        private MessageInterpolator delegate;

        public JsfAwareMessageInterpolator(FacesContext context, MessageInterpolator delegate) {
            this.context = context;
            this.delegate = delegate;
        }

        public String interpolate(String message, MessageInterpolator.Context context) {
            Locale locale = this.context.getViewRoot().getLocale();
            if (locale == null) {
                locale = Locale.getDefault();
            }
            return this.delegate.interpolate(message, context, locale);
        }

        public String interpolate(String message, MessageInterpolator.Context context, Locale locale) {
            return this.delegate.interpolate(message, context, locale);
        }
    }
}

