/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.javax.sip.parser;

import gov.nist.core.Debug;
import gov.nist.core.InternalErrorHandler;
import gov.nist.javax.sip.header.ContentLength;
import gov.nist.javax.sip.message.SIPMessage;
import gov.nist.javax.sip.parser.Pipeline;
import gov.nist.javax.sip.parser.SIPMessageListener;
import gov.nist.javax.sip.parser.StringMsgParser;
import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;

public final class PipelinedMsgParser
implements Runnable {
    protected SIPMessageListener sipMessageListener;
    private Thread mythread;
    private Pipeline rawInputStream;
    private int maxMessageSize;
    private int sizeCounter;
    private static int uid = 0;

    protected PipelinedMsgParser() {
    }

    private static synchronized int getNewUid() {
        return uid++;
    }

    public PipelinedMsgParser(SIPMessageListener sipMessageListener, Pipeline in, boolean debug, int maxMessageSize) {
        this();
        this.sipMessageListener = sipMessageListener;
        this.rawInputStream = in;
        this.maxMessageSize = maxMessageSize;
        this.mythread = new Thread(this);
        this.mythread.setName("PipelineThread-" + PipelinedMsgParser.getNewUid());
    }

    public PipelinedMsgParser(SIPMessageListener mhandler, Pipeline in, int maxMsgSize) {
        this(mhandler, in, false, maxMsgSize);
    }

    public PipelinedMsgParser(Pipeline in) {
        this(null, in, false, 0);
    }

    public void processInput() {
        this.mythread.start();
    }

    protected Object clone() {
        PipelinedMsgParser p = new PipelinedMsgParser();
        p.rawInputStream = this.rawInputStream;
        p.sipMessageListener = this.sipMessageListener;
        Thread mythread = new Thread(p);
        mythread.setName("PipelineThread");
        return p;
    }

    public void setMessageListener(SIPMessageListener mlistener) {
        this.sipMessageListener = mlistener;
    }

    private String readLine(InputStream inputStream) throws IOException {
        char ch;
        StringBuffer retval = new StringBuffer("");
        do {
            int i;
            if ((i = inputStream.read()) == -1) {
                throw new IOException("End of stream");
            }
            ch = (char)i;
            if (this.maxMessageSize > 0) {
                --this.sizeCounter;
                if (this.sizeCounter <= 0) {
                    throw new IOException("Max size exceeded!");
                }
            }
            if (ch == '\r') continue;
            retval.append(ch);
        } while (ch != '\n');
        return retval.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Pipeline inputStream = this.rawInputStream;
        while (true) {
            try {
                SIPMessage sipMessage;
                while (true) {
                    block36: {
                        String line1;
                        this.sizeCounter = this.maxMessageSize;
                        StringBuffer inputBuffer = new StringBuffer();
                        if (Debug.parserDebug) {
                            Debug.println("Starting parse!");
                        }
                        String line2 = null;
                        try {
                            while ((line1 = this.readLine(inputStream)).equals("\n")) {
                                if (!Debug.parserDebug) continue;
                                Debug.println("Discarding blank line. ");
                            }
                        }
                        catch (IOException ex) {
                            Debug.printStackTrace(ex);
                            this.rawInputStream.stopTimer();
                            Object var15_18 = null;
                            try {
                                inputStream.close();
                            }
                            catch (IOException e) {
                                InternalErrorHandler.handleException(e);
                            }
                            return;
                        }
                        inputBuffer.append(line1);
                        this.rawInputStream.startTimer();
                        Debug.println("Reading Input Stream");
                        try {
                            do {
                                line2 = this.readLine(inputStream);
                                inputBuffer.append(line2);
                            } while (!line2.trim().equals(""));
                        }
                        catch (IOException ex) {
                            this.rawInputStream.stopTimer();
                            Debug.printStackTrace(ex);
                            Object var15_19 = null;
                            try {
                                inputStream.close();
                            }
                            catch (IOException e) {
                                InternalErrorHandler.handleException(e);
                            }
                            return;
                        }
                        this.rawInputStream.stopTimer();
                        inputBuffer.append(line2);
                        StringMsgParser smp = new StringMsgParser(this.sipMessageListener);
                        smp.readBody = false;
                        sipMessage = null;
                        try {
                            if (Debug.debug) {
                                Debug.println("About to parse : " + inputBuffer.toString());
                            }
                            if ((sipMessage = smp.parseSIPMessage(inputBuffer.toString())) == null) {
                                this.rawInputStream.stopTimer();
                            }
                            break block36;
                        }
                        catch (ParseException ex) {
                            Debug.logError("Detected a parse error", ex);
                        }
                        continue;
                    }
                    if (Debug.debug) {
                        Debug.println("Completed parsing message");
                    }
                    ContentLength cl = (ContentLength)sipMessage.getContentLength();
                    int contentLength = 0;
                    contentLength = cl != null ? cl.getContentLength() : 0;
                    if (Debug.debug) {
                        Debug.println("contentLength " + contentLength);
                    }
                    if (contentLength == 0) {
                        sipMessage.removeContent();
                    } else if (this.maxMessageSize == 0 || contentLength < this.sizeCounter) {
                        int readlength;
                        byte[] message_body = new byte[contentLength];
                        for (int nread = 0; nread < contentLength; nread += readlength) {
                            Object var13_17;
                            this.rawInputStream.startTimer();
                            try {
                                try {
                                    readlength = inputStream.read(message_body, nread, contentLength - nread);
                                    if (readlength > 0) {
                                    } else {
                                        var13_17 = null;
                                        this.rawInputStream.stopTimer();
                                        break;
                                    }
                                    var13_17 = null;
                                    this.rawInputStream.stopTimer();
                                    continue;
                                }
                                catch (IOException ex) {
                                    Debug.logError("Exception Reading Content", ex);
                                    var13_17 = null;
                                    this.rawInputStream.stopTimer();
                                    break;
                                }
                            }
                            catch (Throwable throwable) {
                                var13_17 = null;
                                this.rawInputStream.stopTimer();
                                throw throwable;
                            }
                        }
                        sipMessage.setMessageContent(message_body);
                    }
                    if (this.sipMessageListener != null) break;
                }
                try {
                    this.sipMessageListener.processMessage(sipMessage);
                }
                catch (Exception ex) {
                    Object var15_20 = null;
                    try {
                        inputStream.close();
                    }
                    catch (IOException e) {
                        InternalErrorHandler.handleException(e);
                    }
                    break;
                }
            }
            catch (Throwable throwable) {
                Object var15_21 = null;
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    InternalErrorHandler.handleException(e);
                }
                throw throwable;
            }
        }
    }

    public void close() {
        try {
            this.rawInputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

