package performance.uas_uac;

import gov.nist.javax.sip.stack.SIPClientTransaction;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Properties;
import java.util.TooManyListenersException;
import java.util.Vector;
import java.util.Map.Entry;

import javax.sip.ClientTransaction;
import javax.sip.Dialog;
import javax.sip.DialogTerminatedEvent;
import javax.sip.IOExceptionEvent;
import javax.sip.InvalidArgumentException;
import javax.sip.ListeningPoint;
import javax.sip.ObjectInUseException;
import javax.sip.PeerUnavailableException;
import javax.sip.RequestEvent;
import javax.sip.ResponseEvent;
import javax.sip.ServerTransaction;
import javax.sip.SipException;
import javax.sip.SipFactory;
import javax.sip.SipListener;
import javax.sip.SipProvider;
import javax.sip.SipStack;
import javax.sip.TimeoutEvent;
import javax.sip.TransactionTerminatedEvent;
import javax.sip.TransactionUnavailableException;
import javax.sip.TransportNotSupportedException;
import javax.sip.address.Address;
import javax.sip.address.AddressFactory;
import javax.sip.address.SipURI;
import javax.sip.header.CSeqHeader;
import javax.sip.header.CallIdHeader;
import javax.sip.header.ContactHeader;
import javax.sip.header.FromHeader;
import javax.sip.header.HeaderFactory;
import javax.sip.header.MaxForwardsHeader;
import javax.sip.header.ToHeader;
import javax.sip.header.ViaHeader;
import javax.sip.message.MessageFactory;
import javax.sip.message.Request;
import javax.sip.message.Response;


public class One implements SipListener{
	private static SipStack sipStack;
	private static ListeningPoint listeningPoint;
	private static SipProvider sipProvider;
	private static AddressFactory addressFactory;
	private static MessageFactory messageFactory;
	private static HeaderFactory headerFactory;
	private static ContactHeader contactHeader = null;
	private static String transport="udp";
	
	public static void main(String[] args) {
		//Factorys
		SipFactory sipFactory = SipFactory.getInstance();
		sipFactory.setPathName("gov.nist");
		
		try {
		headerFactory = sipFactory.createHeaderFactory();
		addressFactory = sipFactory.createAddressFactory();
		messageFactory = sipFactory.createMessageFactory();
		} catch (PeerUnavailableException e) {
			e.printStackTrace();
			System.err.println(e.getMessage());
		}
		//Stack
		try{
			Properties properties = new Properties();
			properties.setProperty("javax.sip.STACK_NAME", "send");
//			properties.setProperty("gov.nist.javax.sip.REENTRANT_LISTENER", "true");
//			properties.setProperty("gov.nist.javax.sip.THREAD_POOL_SIZE", "2");
//			properties.setProperty("gov.nist.javax.sip.DEBUG_LOG", "debug.txt");
////			properties.setProperty("gov.nist.javax.sip.SERVER_LOG", "log.txt");
			properties.setProperty("gov.nist.javax.sip.TRACE_LEVEL", "0");
//			properties.setProperty("gov.nist.javax.sip.AGGRESSIVE_CLEANUP", "true");
			sipStack = sipFactory.createSipStack(properties);
		}
		catch (PeerUnavailableException e) {
			e.printStackTrace();
			System.err.println(e.getMessage());
		}
		
		//Listening Point
		try{
			listeningPoint = sipStack.createListeningPoint("127.0.0.1", 5070, transport);
		}
		catch(InvalidArgumentException e){
			e.printStackTrace();
			System.err.println(e.getMessage());
		}
		catch(TransportNotSupportedException e){
			e.printStackTrace();
			System.err.println(e.getMessage());
		}
		
		//SIP Provider
		try{
			sipProvider = sipStack.createSipProvider(listeningPoint);
		}
		catch(ObjectInUseException e){
			e.printStackTrace();
			System.err.println(e.getMessage());
		}
		try
		{
			sipProvider.addSipListener(new One());
		}
		catch(TooManyListenersException e)
		{
			e.printStackTrace();
			System.err.println(e.getMessage());
		}
		
		
		
		//File
		BufferedReader reader;
		String lines=null;

		try {
//			reader = new BufferedReader(new FileReader("Info.txt"));
//			lines = reader.readLine();		
		    lines ="send1 | empf1";
			
			Vector<String> callInformation = new Vector<String>();
			
			//Read the file
//			while (lines != null) {				
				callInformation.add(lines);
//				lines = reader.readLine();
//			}
			
			String[] currentLine = null;
			SIPClientTransaction sct = null;
			
			//Search the CalledNumber
			for(int u = 0; u < 100000; u++){
    			for (int i = 0; i < callInformation.size(); i++) {
    					//Get the Line
    					currentLine = callInformation.get(i).replaceAll(" ","").split("\\|");
    					//Get the Numbers
    					Request request = createMessage(currentLine[0],currentLine[1],i);
    	
    					//Send
    					ClientTransaction clientTransaction = sipProvider.getNewClientTransaction(request);
    					
    					sct = (SIPClientTransaction) clientTransaction;
    //					System.out.println(sct.getMessageChannel().getSIPStack().getActiveClientTransactionCount());
    					
    					//clientTransaction.setRetransmitTimer(10000);
    					clientTransaction.sendRequest();
    					//System.out.println("INVITE sent");
    					Thread.sleep(50);
    			}
    			if(u != 0 && u % 1500 == 0){
    				System.out.println("I'll sleep..with ActiveClientTransactions: " +sct.getMessageChannel().getSIPStack().getActiveClientTransactionCount());
    				Thread.sleep(180000);
    				System.out.println("ActiveClientTransactions: " +sct.getMessageChannel().getSIPStack().getActiveClientTransactionCount());
    				System.out.println("ClientSize: "+sct.getMessageChannel().getSIPStack().getClientTransactionTableSize());
    				System.out.println("ServerSize: "+sct.getMessageChannel().getSIPStack().getServerTransactionTableSize());
//    				System.out.println("DialogSize: "+sct.getMessageChannel().getSIPStack().dialogTable.size());
//    				System.out.println("EarlyDialogSize: "+sct.getMessageChannel().getSIPStack().earlyDialogTable.size());
//    				System.out.println("ForkedClientSize: "+sct.getMessageChannel().getSIPStack().forkedClientTransactionTable.size());
//    				System.out.println("MergeSize: "+sct.getMessageChannel().getSIPStack().mergeTable.size());
//    				System.out.println("TerminatedServerTxPendingAckSize: "+sct.getMessageChannel().getSIPStack().terminatedServerTransactionsPendingAck.size());
//    				System.out.println("ServerDialogMergeTestTableSize: "+sct.getMessageChannel().getSIPStack().serverDialogMergeTestTable.size());
//    				if(sct.getMessageChannel().getSIPStack().getActiveClientTransactionCount() > 0) {
//    				    for (Entry<String, SIPClientTransaction> entry : sct.getMessageChannel().getSIPStack().clientTransactionTable.entrySet()) {
//    				        System.out.println("Ctw: "+entry.getKey() + " , ctx " + entry.getValue().getMethod());
//                        }				    
//    				}
    			}
			}
//			System.out.println("last: "+System.currentTimeMillis());
			
		} catch (TransactionUnavailableException e) {	
			e.printStackTrace();
			System.err.println(e.getMessage());
		} catch (SipException e) {	
			e.printStackTrace();
			System.err.println(e.getMessage());
//		} catch (IOException e) {
//			e.printStackTrace();
//			System.err.println(e.getMessage());
		} catch (InterruptedException e){
			e.printStackTrace();
			System.err.println(e.getMessage());
		}
	}

	private static Request createMessage(String from, String to, long id){
		Request request = null;
		id += 1;//0 not allowed
		//Invite
		try {	
			// create From Header
			SipURI fromAddress = addressFactory.createSipURI(from, "send.com");
			Address fromNameAddress = addressFactory.createAddress(fromAddress);
			fromNameAddress.setDisplayName(from);
			FromHeader fromHeader = headerFactory.createFromHeader(fromNameAddress,"12345");

			// create To Header
			SipURI toAddress = addressFactory.createSipURI(to, "empf.com");
			Address toNameAddress = addressFactory.createAddress(toAddress);
			toNameAddress.setDisplayName(to);
			ToHeader toHeader = headerFactory.createToHeader(toNameAddress, null);

			// create Request URI
			SipURI requestURI = addressFactory.createSipURI(from, "127.0.0.1:5080");

			// Create ViaHeaders
			ArrayList viaHeaders = new ArrayList();
			ViaHeader viaHeader = headerFactory.createViaHeader("127.0.0.1",
					sipProvider.getListeningPoint(transport).getPort(), transport, null);
			viaHeaders.add(viaHeader);

			// Create a new CallId header
			CallIdHeader callIdHeader = sipProvider.getNewCallId();
			//callIdHeader.setCallId("1");
			// Create a new Cseq header
			CSeqHeader cSeqHeader = headerFactory.createCSeqHeader(id, Request.INVITE);

			// Create a new MaxForwardsHeader
			MaxForwardsHeader maxForwards = headerFactory.createMaxForwardsHeader(70);
			// Create the request.
			request = messageFactory.createRequest(requestURI,Request.INVITE,
					callIdHeader, cSeqHeader, fromHeader, toHeader, viaHeaders, maxForwards);
			// Create contact headers
			String host = "127.0.0.1";
			SipURI contactUrl = addressFactory.createSipURI(from, host);
			contactUrl.setPort(listeningPoint.getPort());

			// Create the contact name address.
			SipURI contactURI = addressFactory.createSipURI(from, host);
			contactURI.setPort(sipProvider.getListeningPoint(transport).getPort());
			contactURI.setTransportParam(transport);
			Address contactAddress = addressFactory.createAddress(contactURI);

			// Add the contact address.
			contactAddress.setDisplayName(from);
			contactHeader = headerFactory.createContactHeader(contactAddress);
			request.addHeader(contactHeader);
			
		} catch (ParseException e) {
			e.printStackTrace();
			System.err.println(e.getMessage());
		} catch (InvalidArgumentException e){
			e.printStackTrace();
			System.err.println(e.getMessage());
		}
		
		return request;
	}
	
	public void processDialogTerminated(DialogTerminatedEvent arg0) {	
	}

	public void processIOException(IOExceptionEvent arg0) {	
	    System.err.println("processIOException----------------------------------");
	}

	public void processRequest(RequestEvent requestEvent) {
		//Invite received
		if(requestEvent.getRequest().getMethod().equals(Request.INVITE)){
			//System.out.println("INVITE bekommen");
			try {	
				ServerTransaction serverTransaction = requestEvent.getServerTransaction();
				if(serverTransaction==null){
					serverTransaction = sipProvider.getNewServerTransaction(requestEvent.getRequest());
				}
				Response responseRing = messageFactory.createResponse(Response.RINGING, requestEvent.getRequest());
				responseRing.addHeader(contactHeader);
				serverTransaction.sendResponse(responseRing);
				//System.out.println("Ringing sent");
				//System.out.println("Ringing sent");
				Response responseOk = messageFactory.createResponse(Response.OK, requestEvent.getRequest());
				responseOk.addHeader(contactHeader);
				serverTransaction.sendResponse(responseOk);
				//System.out.println("OK sent");
				//System.out.println("Ok sent");
			} catch (SipException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			} catch (InvalidArgumentException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			} catch (ParseException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
		}
		if(requestEvent.getRequest().getMethod().equals(Request.ACK))
		{
			//System.out.println("ACK bekommen");
			//System.out.println("ACK bekommen");
			//System.out.println(requestEvent.getDialog());
		}
		if(requestEvent.getRequest().getMethod().equals(Request.BYE))
		{
			//System.out.println("BYE bekommen");
			//System.out.println("Bye bekommen");
			//System.out.println(requestEvent.getDialog());
			
			Response responseOk;
			try {
				responseOk = messageFactory.createResponse(Response.OK, requestEvent.getRequest());
				ServerTransaction serverTransaction = requestEvent.getServerTransaction();
				serverTransaction.sendResponse(responseOk);
				
			} catch (ParseException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			} catch (SipException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			} catch (InvalidArgumentException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}	
			//System.out.println("Ok (bye) sent");
			//System.out.println("OK (bye) sent");
		}
	}

	public void processResponse(ResponseEvent responseEvent) {
		if(responseEvent.getResponse().getStatusCode() == 180){
			//System.out.println("Ringing bekommen");
			//System.out.println("RINGING bekommen");
			CallIdHeader callID = (CallIdHeader) responseEvent.getResponse().getHeader(CallIdHeader.NAME);
		}
		CSeqHeader cseq2 = (CSeqHeader) responseEvent.getResponse().getHeader(CSeqHeader.NAME);

		if(responseEvent.getResponse().getStatusCode() == 200 && cseq2.getMethod().equals("INVITE")){
			//System.out.println("confirmed OK bekommen");
			//System.out.println("confirmed OK bekommen");
			CallIdHeader callID = (CallIdHeader) responseEvent.getResponse().getHeader(CallIdHeader.NAME);
			CSeqHeader cseq = (CSeqHeader) responseEvent.getResponse().getHeader(CSeqHeader.NAME);
			
			try{
				Dialog dialog = responseEvent.getClientTransaction().getDialog();
				Request ack = dialog.createAck(cseq.getSeqNumber());

				//System.out.println("Ack sent");
				//System.out.println("ACK sent");
				dialog.sendAck(ack);
				//A sends a BYE
				Request byeRequest = dialog.createRequest(Request.BYE);
				dialog.sendRequest(sipProvider.getNewClientTransaction(byeRequest));
				//System.out.println("BYE sent");
				//System.out.println("Bye sent");
				
			}catch (SipException e) {
				e.printStackTrace();
				System.err.println(e.getMessage());
			}catch (InvalidArgumentException e) {
				e.printStackTrace();
				System.err.println(e.getMessage());
			}
		}
		else if(responseEvent.getResponse().getStatusCode() == 200 && cseq2.getMethod().equals("BYE")){
			//System.out.println("terminated OK bekommen");
			//System.out.println("terminated OK bekommen");
		}
		
	}

	public void processTimeout(TimeoutEvent arg0) {
		//System.out.println("Timeout----------------------------------");
	    System.err.println("Timeout---------------------------------- CTX : " + arg0.getClientTransaction() + " STX : " + arg0.getServerTransaction());
	    new Exception().printStackTrace();
	}

	public void processTransactionTerminated(TransactionTerminatedEvent arg0) {
	}
}
