/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.javax.sip.clientauthutils;

import gov.nist.javax.sip.stack.SIPStackTimerTask;
import gov.nist.javax.sip.stack.timers.SipTimer;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.concurrent.ConcurrentHashMap;
import javax.sip.header.AuthorizationHeader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class CredentialsCache {
    private ConcurrentHashMap<String, List<AuthorizationHeader>> authorizationHeaders = new ConcurrentHashMap();
    private SipTimer timer;

    CredentialsCache(SipTimer timer) {
        this.timer = timer;
    }

    void cacheAuthorizationHeader(String callId, AuthorizationHeader authorization, int cacheTime) {
        String user = authorization.getUsername();
        if (callId == null) {
            throw new NullPointerException("Call ID is null!");
        }
        if (authorization == null) {
            throw new NullPointerException("Null authorization domain");
        }
        List<AuthorizationHeader> authHeaders = this.authorizationHeaders.get(callId);
        if (authHeaders == null) {
            authHeaders = new LinkedList<AuthorizationHeader>();
            this.authorizationHeaders.put(callId, authHeaders);
        } else {
            String realm = authorization.getRealm();
            ListIterator<AuthorizationHeader> li = authHeaders.listIterator();
            while (li.hasNext()) {
                AuthorizationHeader authHeader = li.next();
                if (!realm.equals(authHeader.getRealm())) continue;
                li.remove();
            }
        }
        authHeaders.add(authorization);
        TimeoutTask timeoutTask = new TimeoutTask(callId, user);
        if (cacheTime != -1) {
            this.timer.schedule(timeoutTask, cacheTime * 1000);
        }
    }

    Collection<AuthorizationHeader> getCachedAuthorizationHeaders(String callid) {
        if (callid == null) {
            throw new NullPointerException("Null arg!");
        }
        return this.authorizationHeaders.get(callid);
    }

    public void removeAuthenticationHeader(String callId) {
        this.authorizationHeaders.remove(callId);
    }

    class TimeoutTask
    extends SIPStackTimerTask {
        String callId;
        String userName;

        public TimeoutTask(String userName, String proxyDomain) {
            this.callId = proxyDomain;
            this.userName = userName;
        }

        public void runTask() {
            CredentialsCache.this.authorizationHeaders.remove(this.callId);
        }
    }
}

