/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.javax.sip.stack;

import gov.nist.core.InternalErrorHandler;
import gov.nist.core.ThreadAuditor;
import gov.nist.javax.sip.header.CSeq;
import gov.nist.javax.sip.header.CallID;
import gov.nist.javax.sip.header.From;
import gov.nist.javax.sip.header.RequestLine;
import gov.nist.javax.sip.header.StatusLine;
import gov.nist.javax.sip.header.To;
import gov.nist.javax.sip.header.Via;
import gov.nist.javax.sip.message.SIPMessage;
import gov.nist.javax.sip.message.SIPRequest;
import gov.nist.javax.sip.message.SIPResponse;
import gov.nist.javax.sip.parser.MessageParser;
import gov.nist.javax.sip.parser.ParseExceptionListener;
import gov.nist.javax.sip.stack.MessageChannel;
import gov.nist.javax.sip.stack.MessageProcessor;
import gov.nist.javax.sip.stack.RawMessageChannel;
import gov.nist.javax.sip.stack.SIPClientTransaction;
import gov.nist.javax.sip.stack.SIPServerTransaction;
import gov.nist.javax.sip.stack.SIPStackTimerTask;
import gov.nist.javax.sip.stack.SIPTransaction;
import gov.nist.javax.sip.stack.SIPTransactionStack;
import gov.nist.javax.sip.stack.ServerRequestInterface;
import gov.nist.javax.sip.stack.ServerResponseInterface;
import gov.nist.javax.sip.stack.UDPMessageProcessor;
import java.io.IOException;
import java.io.OutputStream;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.Socket;
import java.text.ParseException;
import java.util.Hashtable;
import javax.sip.address.Hop;

public class UDPMessageChannel
extends MessageChannel
implements ParseExceptionListener,
Runnable,
RawMessageChannel {
    protected SIPTransactionStack sipStack;
    protected MessageParser myParser;
    private InetAddress peerAddress;
    private String myAddress;
    private int peerPacketSourcePort;
    private InetAddress peerPacketSourceAddress;
    private int peerPort;
    private String peerProtocol;
    protected int myPort;
    private DatagramPacket incomingPacket;
    private long receptionTime;
    private Thread mythread = null;
    private static Hashtable<String, PingBackTimerTask> pingBackRecord = new Hashtable();

    protected UDPMessageChannel(SIPTransactionStack stack, UDPMessageProcessor messageProcessor, String threadName) {
        this.messageProcessor = messageProcessor;
        this.sipStack = stack;
        this.myParser = this.sipStack.getMessageParserFactory().createMessageParser(this.sipStack);
        this.mythread = new Thread(this);
        this.myAddress = messageProcessor.getIpAddress().getHostAddress();
        this.myPort = messageProcessor.getPort();
        this.mythread.setName(threadName);
        this.mythread.setDaemon(true);
        this.mythread.start();
    }

    protected UDPMessageChannel(SIPTransactionStack stack, UDPMessageProcessor messageProcessor, DatagramPacket packet) {
        this.incomingPacket = packet;
        this.messageProcessor = messageProcessor;
        this.sipStack = stack;
        this.myParser = this.sipStack.getMessageParserFactory().createMessageParser(this.sipStack);
        this.myAddress = messageProcessor.getIpAddress().getHostAddress();
        this.myPort = messageProcessor.getPort();
        this.mythread = new Thread(this);
        this.mythread.setDaemon(true);
        this.mythread.start();
    }

    protected UDPMessageChannel(InetAddress targetAddr, int port, SIPTransactionStack sipStack, UDPMessageProcessor messageProcessor) {
        this.peerAddress = targetAddr;
        this.peerPort = port;
        this.peerProtocol = "UDP";
        this.messageProcessor = messageProcessor;
        this.myAddress = messageProcessor.getIpAddress().getHostAddress();
        this.myPort = messageProcessor.getPort();
        this.sipStack = sipStack;
        this.myParser = sipStack.getMessageParserFactory().createMessageParser(sipStack);
        if (sipStack.isLoggingEnabled(32)) {
            this.sipStack.getStackLogger().logDebug("Creating message channel " + targetAddr.getHostAddress() + "/" + port);
        }
    }

    public void run() {
        ThreadAuditor.ThreadHandle threadHandle = null;
        UDPMessageProcessor udpMessageProcessor = (UDPMessageProcessor)this.messageProcessor;
        do {
            DatagramPacket packet = null;
            if (this.sipStack.threadPoolSize != -1) {
                block8: {
                    if (threadHandle == null) {
                        threadHandle = this.sipStack.getThreadAuditor().addCurrentThread();
                    }
                    threadHandle.ping();
                    try {
                        packet = udpMessageProcessor.messageQueue.take();
                    }
                    catch (InterruptedException ex) {
                        if (udpMessageProcessor.isRunning) break block8;
                        return;
                    }
                }
                this.incomingPacket = packet;
            } else {
                packet = this.incomingPacket;
            }
            try {
                this.processIncomingDataPacket(packet);
            }
            catch (Exception e) {
                this.sipStack.getStackLogger().logError("Error while processing incoming UDP packet", e);
            }
        } while (this.sipStack.threadPoolSize != -1);
    }

    private void processIncomingDataPacket(DatagramPacket packet) throws Exception {
        this.peerAddress = packet.getAddress();
        int packetLength = packet.getLength();
        byte[] bytes = packet.getData();
        byte[] msgBytes = new byte[packetLength];
        System.arraycopy(bytes, 0, msgBytes, 0, packetLength);
        if (this.sipStack.isLoggingEnabled(32)) {
            this.sipStack.getStackLogger().logDebug("UDPMessageChannel: processIncomingDataPacket : peerAddress = " + this.peerAddress.getHostAddress() + "/" + packet.getPort() + " Length = " + packetLength);
        }
        SIPMessage sipMessage = null;
        try {
            this.receptionTime = System.currentTimeMillis();
            sipMessage = this.myParser.parseSIPMessage(msgBytes, true, false, this);
        }
        catch (ParseException ex) {
            String msgString;
            if (this.sipStack.isLoggingEnabled(32)) {
                this.sipStack.getStackLogger().logDebug("Rejecting message !  " + new String(msgBytes));
                this.sipStack.getStackLogger().logDebug("error message " + ex.getMessage());
                this.sipStack.getStackLogger().logException(ex);
            }
            if (!(msgString = new String(msgBytes, 0, packetLength)).startsWith("SIP/") && !msgString.startsWith("ACK ")) {
                String badReqRes = this.createBadReqRes(msgString, ex);
                if (badReqRes != null) {
                    if (this.sipStack.isLoggingEnabled(32)) {
                        this.sipStack.getStackLogger().logDebug("Sending automatic 400 Bad Request:");
                        this.sipStack.getStackLogger().logDebug(badReqRes);
                    }
                    try {
                        this.sendMessage(badReqRes.getBytes(), this.peerAddress, packet.getPort(), "UDP", false);
                    }
                    catch (IOException e) {
                        this.sipStack.getStackLogger().logException(e);
                    }
                } else if (this.sipStack.isLoggingEnabled(32)) {
                    this.sipStack.getStackLogger().logDebug("Could not formulate automatic 400 Bad Request");
                }
            }
            return;
        }
        if (sipMessage == null) {
            String key;
            if (this.sipStack.isLoggingEnabled(32)) {
                this.sipStack.getStackLogger().logDebug("Rejecting message !  + Null message parsed.");
            }
            if (pingBackRecord.get(key = packet.getAddress().getHostAddress() + ":" + packet.getPort()) == null && this.sipStack.getMinKeepAliveInterval() > 0L) {
                byte[] retval = "\r\n\r\n".getBytes();
                DatagramPacket keepalive = new DatagramPacket(retval, 0, retval.length, packet.getAddress(), packet.getPort());
                PingBackTimerTask task = new PingBackTimerTask(packet.getAddress().getHostAddress(), packet.getPort());
                pingBackRecord.put(key, task);
                this.sipStack.getTimer().schedule(task, this.sipStack.getMinKeepAliveInterval() * 1000L);
                ((UDPMessageProcessor)this.messageProcessor).sock.send(keepalive);
            } else {
                this.sipStack.getStackLogger().logDebug("Not sending ping back");
            }
            return;
        }
        Via topMostVia = sipMessage.getTopmostVia();
        if (sipMessage.getFrom() == null || sipMessage.getTo() == null || sipMessage.getCallId() == null || sipMessage.getCSeq() == null || topMostVia == null) {
            String badmsg = new String(msgBytes);
            if (this.sipStack.isLoggingEnabled()) {
                this.sipStack.getStackLogger().logError("bad message " + badmsg);
                this.sipStack.getStackLogger().logError(">>> Dropped Bad Msg From = " + sipMessage.getFrom() + "To = " + sipMessage.getTo() + "CallId = " + sipMessage.getCallId() + "CSeq = " + sipMessage.getCSeq() + "Via = " + sipMessage.getViaHeaders());
            }
            return;
        }
        if (sipMessage instanceof SIPRequest) {
            Hop hop = this.sipStack.addressResolver.resolveAddress(topMostVia.getHop());
            this.peerPort = hop.getPort();
            this.peerProtocol = topMostVia.getTransport();
            this.peerPacketSourceAddress = packet.getAddress();
            this.peerPacketSourcePort = packet.getPort();
            try {
                this.peerAddress = packet.getAddress();
                boolean hasRPort = topMostVia.hasParameter("rport");
                if (hasRPort || !hop.getHost().equals(this.peerAddress.getHostAddress())) {
                    topMostVia.setParameter("received", this.peerAddress.getHostAddress());
                }
                if (hasRPort) {
                    topMostVia.setParameter("rport", Integer.toString(this.peerPacketSourcePort));
                }
            }
            catch (ParseException ex1) {
                InternalErrorHandler.handleException(ex1);
            }
        } else {
            this.peerPacketSourceAddress = packet.getAddress();
            this.peerPacketSourcePort = packet.getPort();
            this.peerAddress = packet.getAddress();
            this.peerPort = packet.getPort();
            this.peerProtocol = topMostVia.getTransport();
        }
        this.processMessage(sipMessage);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void processMessage(SIPMessage sipMessage) {
        ServerResponseInterface sipServerResponse;
        block15: {
            block14: {
                if (sipMessage instanceof SIPRequest) {
                    SIPServerTransaction sipServerTx2;
                    ServerRequestInterface sipServerRequest;
                    SIPRequest sipRequest = (SIPRequest)sipMessage;
                    if (this.sipStack.getStackLogger().isLoggingEnabled(16)) {
                        this.sipStack.serverLogger.logMessage(sipMessage, this.getPeerHostPort().toString(), this.getHost() + ":" + this.myPort, false, this.receptionTime);
                    }
                    if ((sipServerRequest = this.sipStack.newSIPServerRequest(sipRequest, this)) == null) {
                        if (!this.sipStack.isLoggingEnabled()) return;
                        this.sipStack.getStackLogger().logWarning("Null request interface returned -- dropping request");
                        return;
                    }
                    if (this.sipStack.isLoggingEnabled(32)) {
                        this.sipStack.getStackLogger().logDebug("About to process " + sipRequest.getFirstLine() + "/" + sipServerRequest);
                    }
                    try {
                        sipServerRequest.processRequest(sipRequest, this);
                        Object var5_7 = null;
                    }
                    catch (Throwable throwable) {
                        Object var5_8 = null;
                        if (!(sipServerRequest instanceof SIPTransaction)) throw throwable;
                        SIPServerTransaction sipServerTx2 = (SIPServerTransaction)sipServerRequest;
                        if (sipServerTx2.passToListener()) throw throwable;
                        ((SIPTransaction)((Object)sipServerRequest)).releaseSem();
                        throw throwable;
                    }
                    if (sipServerRequest instanceof SIPTransaction && !(sipServerTx2 = (SIPServerTransaction)sipServerRequest).passToListener()) {
                        ((SIPTransaction)((Object)sipServerRequest)).releaseSem();
                    }
                    if (!this.sipStack.isLoggingEnabled(32)) return;
                    this.sipStack.getStackLogger().logDebug("Done processing " + sipRequest.getFirstLine() + "/" + sipServerRequest);
                    return;
                }
                SIPResponse sipResponse = (SIPResponse)sipMessage;
                try {
                    sipResponse.checkHeaders();
                }
                catch (ParseException ex) {
                    if (!this.sipStack.isLoggingEnabled()) return;
                    this.sipStack.getStackLogger().logError("Dropping Badly formatted response message >>> " + sipResponse);
                    return;
                }
                sipServerResponse = this.sipStack.newSIPServerResponse(sipResponse, this);
                if (sipServerResponse == null) {
                    if (!this.sipStack.isLoggingEnabled(32)) return;
                    this.sipStack.getStackLogger().logDebug("null sipServerResponse!");
                    return;
                }
                try {
                    if (sipServerResponse instanceof SIPClientTransaction && !((SIPClientTransaction)sipServerResponse).checkFromTag(sipResponse)) {
                        if (this.sipStack.isLoggingEnabled()) {
                            this.sipStack.getStackLogger().logError("Dropping response message with invalid tag >>> " + sipResponse);
                        }
                        Object var8_12 = null;
                        break block14;
                    }
                    sipServerResponse.processResponse(sipResponse, this);
                    break block15;
                }
                catch (Throwable throwable) {
                    Object var8_14 = null;
                    if (!(sipServerResponse instanceof SIPTransaction)) throw throwable;
                    if (((SIPTransaction)((Object)sipServerResponse)).passToListener()) throw throwable;
                    ((SIPTransaction)((Object)sipServerResponse)).releaseSem();
                    throw throwable;
                }
            }
            if (!(sipServerResponse instanceof SIPTransaction)) return;
            if (((SIPTransaction)((Object)sipServerResponse)).passToListener()) return;
            ((SIPTransaction)((Object)sipServerResponse)).releaseSem();
            return;
        }
        Object var8_13 = null;
        if (!(sipServerResponse instanceof SIPTransaction)) return;
        if (((SIPTransaction)((Object)sipServerResponse)).passToListener()) return;
        ((SIPTransaction)((Object)sipServerResponse)).releaseSem();
    }

    public void handleException(ParseException ex, SIPMessage sipMessage, Class hdrClass, String header, String message) throws ParseException {
        if (this.sipStack.isLoggingEnabled()) {
            this.sipStack.getStackLogger().logException(ex);
        }
        if (hdrClass != null && (hdrClass.equals(From.class) || hdrClass.equals(To.class) || hdrClass.equals(CSeq.class) || hdrClass.equals(Via.class) || hdrClass.equals(CallID.class) || hdrClass.equals(RequestLine.class) || hdrClass.equals(StatusLine.class))) {
            if (this.sipStack.isLoggingEnabled()) {
                this.sipStack.getStackLogger().logError("BAD MESSAGE!");
                this.sipStack.getStackLogger().logError(message);
            }
            throw ex;
        }
        sipMessage.addUnparsed(header);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void sendMessage(SIPMessage sipMessage) throws IOException {
        long time;
        block15: {
            block13: {
                block14: {
                    if (this.sipStack.isLoggingEnabled() && this.sipStack.isLogStackTraceOnMessageSend()) {
                        if (sipMessage instanceof SIPRequest && ((SIPRequest)sipMessage).getRequestLine() != null) {
                            this.sipStack.getStackLogger().logStackTrace(16);
                        } else {
                            this.sipStack.getStackLogger().logStackTrace(16);
                        }
                    }
                    time = System.currentTimeMillis();
                    try {
                        try {
                            for (MessageProcessor messageProcessor : this.sipStack.getMessageProcessors()) {
                                MessageChannel messageChannel;
                                if (!messageProcessor.getIpAddress().equals(this.peerAddress) || messageProcessor.getPort() != this.peerPort || !messageProcessor.getTransport().equals(this.peerProtocol) || !((messageChannel = messageProcessor.createMessageChannel(this.peerAddress, this.peerPort)) instanceof RawMessageChannel)) continue;
                                ((RawMessageChannel)((Object)messageChannel)).processMessage(sipMessage);
                                if (this.sipStack.isLoggingEnabled(32)) {
                                    this.sipStack.getStackLogger().logDebug("Self routing message");
                                }
                                Object var10_10 = null;
                                if (!this.sipStack.getStackLogger().isLoggingEnabled(16) || sipMessage.isNullRequest()) break block13;
                                break block14;
                            }
                            byte[] msg = sipMessage.encodeAsBytes(this.getTransport());
                            this.sendMessage(msg, this.peerAddress, this.peerPort, this.peerProtocol, sipMessage instanceof SIPRequest);
                            break block15;
                        }
                        catch (IOException ex) {
                            throw ex;
                        }
                        catch (Exception ex) {
                            this.sipStack.getStackLogger().logError("An exception occured while sending message", ex);
                            throw new IOException("An exception occured while sending message");
                        }
                    }
                    catch (Throwable throwable) {
                        Object var10_12 = null;
                        if (this.sipStack.getStackLogger().isLoggingEnabled(16) && !sipMessage.isNullRequest()) {
                            this.logMessage(sipMessage, this.peerAddress, this.peerPort, time);
                            throw throwable;
                        }
                        if (!this.sipStack.getStackLogger().isLoggingEnabled(32)) throw throwable;
                        this.sipStack.getStackLogger().logDebug("Sent EMPTY Message");
                        throw throwable;
                    }
                }
                this.logMessage(sipMessage, this.peerAddress, this.peerPort, time);
                return;
            }
            if (!this.sipStack.getStackLogger().isLoggingEnabled(32)) return;
            this.sipStack.getStackLogger().logDebug("Sent EMPTY Message");
            return;
        }
        Object var10_11 = null;
        if (this.sipStack.getStackLogger().isLoggingEnabled(16) && !sipMessage.isNullRequest()) {
            this.logMessage(sipMessage, this.peerAddress, this.peerPort, time);
            return;
        }
        if (!this.sipStack.getStackLogger().isLoggingEnabled(32)) return;
        this.sipStack.getStackLogger().logDebug("Sent EMPTY Message");
    }

    protected void sendMessage(byte[] msg, InetAddress peerAddress, int peerPort, boolean reConnect) throws IOException {
        if (this.sipStack.isLoggingEnabled() && this.sipStack.isLogStackTraceOnMessageSend()) {
            this.sipStack.getStackLogger().logStackTrace(16);
        }
        if (peerPort == -1) {
            if (this.sipStack.isLoggingEnabled(32)) {
                this.sipStack.getStackLogger().logDebug(this.getClass().getName() + ":sendMessage: Dropping reply!");
            }
            throw new IOException("Receiver port not set ");
        }
        if (this.sipStack.isLoggingEnabled(32)) {
            this.sipStack.getStackLogger().logDebug("sendMessage " + peerAddress.getHostAddress() + "/" + peerPort + "\n" + "messageSize =  " + msg.length + " message = " + new String(msg));
            this.sipStack.getStackLogger().logDebug("*******************\n");
        }
        DatagramPacket reply = new DatagramPacket(msg, msg.length, peerAddress, peerPort);
        try {
            DatagramSocket sock;
            boolean created = false;
            if (this.sipStack.udpFlag) {
                sock = ((UDPMessageProcessor)this.messageProcessor).sock;
            } else {
                sock = new DatagramSocket();
                created = true;
            }
            sock.send(reply);
            if (created) {
                sock.close();
            }
        }
        catch (IOException ex) {
            throw ex;
        }
        catch (Exception ex) {
            InternalErrorHandler.handleException(ex);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void sendMessage(byte[] msg, InetAddress peerAddress, int peerPort, String peerProtocol, boolean retry) throws IOException {
        if (peerPort == -1) {
            if (!this.sipStack.isLoggingEnabled(32)) throw new IOException("Receiver port not set ");
            this.sipStack.getStackLogger().logDebug(this.getClass().getName() + ":sendMessage: Dropping reply!");
            throw new IOException("Receiver port not set ");
        }
        if (this.sipStack.isLoggingEnabled(32)) {
            this.sipStack.getStackLogger().logDebug(":sendMessage " + peerAddress.getHostAddress() + "/" + peerPort + "\n" + " messageSize = " + msg.length);
        }
        if (peerProtocol.compareToIgnoreCase("UDP") == 0) {
            DatagramPacket reply = new DatagramPacket(msg, msg.length, peerAddress, peerPort);
            try {
                DatagramSocket sock = this.sipStack.udpFlag ? ((UDPMessageProcessor)this.messageProcessor).sock : this.sipStack.getNetworkLayer().createDatagramSocket();
                if (this.sipStack.isLoggingEnabled(32)) {
                    this.sipStack.getStackLogger().logDebug("sendMessage " + peerAddress.getHostAddress() + "/" + peerPort + "\n" + new String(msg));
                }
                sock.send(reply);
                if (this.sipStack.udpFlag) return;
                sock.close();
                return;
            }
            catch (IOException ex) {
                throw ex;
            }
            catch (Exception ex) {
                InternalErrorHandler.handleException(ex);
                return;
            }
        } else {
            Socket outputSocket = this.sipStack.ioHandler.sendBytes(this.messageProcessor.getIpAddress(), peerAddress, peerPort, "tcp", msg, retry, this);
            OutputStream myOutputStream = outputSocket.getOutputStream();
            myOutputStream.write(msg, 0, msg.length);
            myOutputStream.flush();
        }
    }

    public SIPTransactionStack getSIPStack() {
        return this.sipStack;
    }

    public String getTransport() {
        return "udp";
    }

    public String getHost() {
        return this.messageProcessor.getIpAddress().getHostAddress();
    }

    public int getPort() {
        return ((UDPMessageProcessor)this.messageProcessor).getPort();
    }

    public String getPeerName() {
        return this.peerAddress.getHostName();
    }

    public String getPeerAddress() {
        return this.peerAddress.getHostAddress();
    }

    protected InetAddress getPeerInetAddress() {
        return this.peerAddress;
    }

    public boolean equals(Object other) {
        boolean retval;
        if (other == null) {
            return false;
        }
        if (!this.getClass().equals(other.getClass())) {
            retval = false;
        } else {
            UDPMessageChannel that = (UDPMessageChannel)other;
            retval = this.getKey().equals(that.getKey());
        }
        return retval;
    }

    public String getKey() {
        return UDPMessageChannel.getKey(this.peerAddress, this.peerPort, "UDP");
    }

    public int getPeerPacketSourcePort() {
        return this.peerPacketSourcePort;
    }

    public InetAddress getPeerPacketSourceAddress() {
        return this.peerPacketSourceAddress;
    }

    public String getViaHost() {
        return this.myAddress;
    }

    public int getViaPort() {
        return this.myPort;
    }

    public boolean isReliable() {
        return false;
    }

    public boolean isSecure() {
        return false;
    }

    public int getPeerPort() {
        return this.peerPort;
    }

    public String getPeerProtocol() {
        return this.peerProtocol;
    }

    public void close() {
        if (this.mythread != null) {
            this.mythread.interrupt();
            this.mythread = null;
        }
    }

    class PingBackTimerTask
    extends SIPStackTimerTask {
        String ipAddress;
        int port;

        public PingBackTimerTask(String ipAddress, int port) {
            this.ipAddress = ipAddress;
            this.port = port;
        }

        public void runTask() {
            pingBackRecord.remove(this.ipAddress + ":" + this.port);
        }

        public int hashCode() {
            return (this.ipAddress + ":" + this.port).hashCode();
        }
    }
}

