/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.javax.sip;

import gov.nist.javax.sip.UtilsExt;
import gov.nist.javax.sip.header.Via;
import gov.nist.javax.sip.message.SIPResponse;
import java.security.MessageDigest;
import java.util.HashSet;
import java.util.Random;

public class Utils
implements UtilsExt {
    private static MessageDigest digester;
    private static Random rand;
    private static long counter;
    private static int callIDCounter;
    private static String signature;
    private static Utils instance;
    private static final char[] toHex;

    public static Utils getInstance() {
        return instance;
    }

    public static String toHexString(byte[] b) {
        int pos = 0;
        char[] c = new char[b.length * 2];
        for (int i = 0; i < b.length; ++i) {
            c[pos++] = toHex[b[i] >> 4 & 0xF];
            c[pos++] = toHex[b[i] & 0xF];
        }
        return new String(c);
    }

    public static String getQuotedString(String str) {
        return '\"' + str.replace("\"", "\\\"") + '\"';
    }

    protected static String reduceString(String input) {
        String newString = input.toLowerCase();
        int len = newString.length();
        String retval = "";
        for (int i = 0; i < len; ++i) {
            if (newString.charAt(i) == ' ' || newString.charAt(i) == '\t') continue;
            retval = retval + newString.charAt(i);
        }
        return retval;
    }

    public synchronized String generateCallIdentifier(String address) {
        String date = Long.toString(System.currentTimeMillis() + (long)callIDCounter++ + rand.nextLong());
        byte[] cid = digester.digest(date.getBytes());
        String cidString = Utils.toHexString(cid);
        return cidString + "@" + address;
    }

    public synchronized String generateTag() {
        return Integer.toHexString(rand.nextInt());
    }

    public synchronized String generateBranchId() {
        long num = rand.nextLong() + counter++ + System.currentTimeMillis();
        byte[] bid = digester.digest(Long.toString(num).getBytes());
        return "z9hG4bK-" + signature + "-" + Utils.toHexString(bid);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean responseBelongsToUs(SIPResponse response) {
        Via topmostVia = response.getTopmostVia();
        String branch = topmostVia.getBranch();
        if (branch == null) return false;
        if (!branch.startsWith("z9hG4bK-" + signature)) return false;
        return true;
    }

    public static String getSignature() {
        return signature;
    }

    public static void main(String[] args) {
        HashSet<String> branchIds = new HashSet<String>();
        for (int b = 0; b < 100000; ++b) {
            String bid = Utils.getInstance().generateBranchId();
            if (branchIds.contains(bid)) {
                throw new RuntimeException("Duplicate Branch ID");
            }
            branchIds.add(bid);
        }
        System.out.println("Done!!");
    }

    static {
        counter = 0L;
        instance = new Utils();
        toHex = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        try {
            digester = MessageDigest.getInstance("MD5");
        }
        catch (Exception ex) {
            throw new RuntimeException("Could not intialize Digester ", ex);
        }
        rand = new Random();
        signature = Utils.toHexString(Integer.toString(Math.abs(rand.nextInt() % 1000)).getBytes());
    }
}

