/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.javax.sip.parser;

import gov.nist.core.Debug;
import gov.nist.core.InternalErrorHandler;
import gov.nist.core.StackLogger;
import gov.nist.javax.sip.header.ContentLength;
import gov.nist.javax.sip.message.SIPMessage;
import gov.nist.javax.sip.parser.MessageParser;
import gov.nist.javax.sip.parser.Pipeline;
import gov.nist.javax.sip.parser.SIPMessageListener;
import gov.nist.javax.sip.stack.SIPTransactionStack;
import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;

public final class PipelinedMsgParser
implements Runnable {
    protected SIPMessageListener sipMessageListener;
    private Thread mythread;
    private Pipeline rawInputStream;
    private int maxMessageSize;
    private int sizeCounter;
    private SIPTransactionStack sipStack;
    private MessageParser smp = null;
    private ConcurrentHashMap<String, Semaphore> messagesOrderingMap = new ConcurrentHashMap();
    private static int uid = 0;
    private static Executor postParseExecutor = null;

    protected PipelinedMsgParser() {
    }

    private static synchronized int getNewUid() {
        return uid++;
    }

    public PipelinedMsgParser(SIPTransactionStack sipStack, SIPMessageListener sipMessageListener, Pipeline in, boolean debug, int maxMessageSize) {
        this();
        this.sipStack = sipStack;
        this.smp = sipStack.getMessageParserFactory().createMessageParser(sipStack);
        this.sipMessageListener = sipMessageListener;
        this.rawInputStream = in;
        this.maxMessageSize = maxMessageSize;
        this.mythread = new Thread(this);
        this.mythread.setName("PipelineThread-" + PipelinedMsgParser.getNewUid());
    }

    public PipelinedMsgParser(SIPTransactionStack sipStack, SIPMessageListener mhandler, Pipeline in, int maxMsgSize) {
        this(sipStack, mhandler, in, false, maxMsgSize);
    }

    public PipelinedMsgParser(SIPTransactionStack sipStack, Pipeline in) {
        this(sipStack, null, in, false, 0);
    }

    public void processInput() {
        this.mythread.start();
    }

    protected Object clone() {
        PipelinedMsgParser p = new PipelinedMsgParser();
        p.rawInputStream = this.rawInputStream;
        p.sipMessageListener = this.sipMessageListener;
        Thread mythread = new Thread(p);
        mythread.setName("PipelineThread");
        return p;
    }

    public void setMessageListener(SIPMessageListener mlistener) {
        this.sipMessageListener = mlistener;
    }

    private String readLine(InputStream inputStream) throws IOException {
        int increment;
        int counter = 0;
        int bufferSize = increment = 1024;
        byte[] lineBuffer = new byte[bufferSize];
        while (true) {
            int i;
            if ((i = inputStream.read()) == -1) {
                throw new IOException("End of stream");
            }
            char ch = (char)(i & 0xFF);
            if (this.maxMessageSize > 0) {
                --this.sizeCounter;
                if (this.sizeCounter <= 0) {
                    throw new IOException("Max size exceeded!");
                }
            }
            if (ch != '\r') {
                lineBuffer[counter++] = (byte)(i & 0xFF);
            }
            if (ch == '\n') break;
            if (counter != bufferSize) continue;
            byte[] tempBuffer = new byte[bufferSize + increment];
            System.arraycopy(lineBuffer, 0, tempBuffer, 0, bufferSize);
            bufferSize += increment;
            lineBuffer = tempBuffer;
        }
        return new String(lineBuffer, 0, counter, "UTF-8");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Pipeline inputStream = this.rawInputStream;
        final StackLogger stackLogger = this.sipStack.getStackLogger();
        while (true) {
            try {
                SIPMessage sipMessage;
                while (true) {
                    block40: {
                        String line1;
                        this.sizeCounter = this.maxMessageSize;
                        StringBuilder inputBuffer = new StringBuilder();
                        if (Debug.parserDebug) {
                            Debug.println("Starting parse!");
                        }
                        String line2 = null;
                        try {
                            while ((line1 = this.readLine(inputStream)).equals("\n")) {
                                if (!Debug.parserDebug) continue;
                                Debug.println("Discarding blank line. ");
                            }
                        }
                        catch (IOException ex) {
                            Debug.printStackTrace(ex);
                            this.rawInputStream.stopTimer();
                            Object var16_27 = null;
                            try {
                                inputStream.close();
                            }
                            catch (IOException e) {
                                InternalErrorHandler.handleException(e);
                            }
                            return;
                        }
                        inputBuffer.append(line1);
                        this.rawInputStream.startTimer();
                        Debug.println("Reading Input Stream");
                        try {
                            do {
                                line2 = this.readLine(inputStream);
                                inputBuffer.append(line2);
                            } while (!line2.trim().equals(""));
                        }
                        catch (IOException ex) {
                            this.rawInputStream.stopTimer();
                            Debug.printStackTrace(ex);
                            Object var16_28 = null;
                            try {
                                inputStream.close();
                            }
                            catch (IOException e) {
                                InternalErrorHandler.handleException(e);
                            }
                            return;
                        }
                        this.rawInputStream.stopTimer();
                        inputBuffer.append(line2);
                        sipMessage = null;
                        try {
                            if (stackLogger.isLoggingEnabled(32)) {
                                stackLogger.logDebug("About to parse : " + inputBuffer.toString());
                            }
                            if ((sipMessage = this.smp.parseSIPMessage(inputBuffer.toString().getBytes(), false, false, this.sipMessageListener)) == null) {
                                this.rawInputStream.stopTimer();
                            }
                            break block40;
                        }
                        catch (ParseException ex) {
                            stackLogger.logError("Detected a parse error", ex);
                        }
                        continue;
                    }
                    if (Debug.debug) {
                        Debug.println("Completed parsing message");
                    }
                    ContentLength cl = (ContentLength)sipMessage.getContentLength();
                    int contentLength = 0;
                    contentLength = cl != null ? cl.getContentLength() : 0;
                    if (Debug.debug) {
                        Debug.println("contentLength " + contentLength);
                    }
                    if (contentLength == 0) {
                        sipMessage.removeContent();
                    } else if (this.maxMessageSize == 0 || contentLength < this.sizeCounter) {
                        int readlength;
                        byte[] message_body = new byte[contentLength];
                        for (int nread = 0; nread < contentLength; nread += readlength) {
                            this.rawInputStream.startTimer();
                            try {
                                try {
                                    readlength = inputStream.read(message_body, nread, contentLength - nread);
                                    if (readlength > 0) {
                                    } else {
                                        Object var13_21 = null;
                                        this.rawInputStream.stopTimer();
                                        break;
                                    }
                                    Object var13_22 = null;
                                    this.rawInputStream.stopTimer();
                                    continue;
                                }
                                catch (IOException ex) {
                                    stackLogger.logError("Exception Reading Content", ex);
                                    Object var13_23 = null;
                                    this.rawInputStream.stopTimer();
                                    break;
                                }
                            }
                            catch (Throwable throwable) {
                                Object var13_24 = null;
                                this.rawInputStream.stopTimer();
                                throw throwable;
                            }
                        }
                        sipMessage.setMessageContent(message_body);
                    }
                    if (this.sipMessageListener != null) break;
                }
                try {
                    Semaphore newSemaphore;
                    if (postParseExecutor == null) {
                        this.sipMessageListener.processMessage(sipMessage);
                        continue;
                    }
                    final SIPMessage message = sipMessage;
                    final String callId = message.getCallId().getCallId();
                    Semaphore semaphore = this.messagesOrderingMap.get(callId);
                    if (semaphore == null && (semaphore = this.messagesOrderingMap.putIfAbsent(callId, newSemaphore = new Semaphore(1, true))) == null) {
                        semaphore = newSemaphore;
                        if (stackLogger.isLoggingEnabled(32)) {
                            stackLogger.logDebug("semaphore added for message " + message);
                        }
                    }
                    final Semaphore callIdSemaphore = semaphore;
                    if (stackLogger.isLoggingEnabled(32)) {
                        stackLogger.logDebug("trying to acquiring semaphore for message " + message);
                    }
                    final boolean acquired = callIdSemaphore.tryAcquire(0L, TimeUnit.SECONDS);
                    Thread messageDispatchTask = new Thread(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         * Enabled aggressive block sorting
                         * Enabled unnecessary exception pruning
                         * Enabled aggressive exception aggregation
                         */
                        public void run() {
                            if (stackLogger.isLoggingEnabled(32)) {
                                stackLogger.logDebug("semaphore acquired " + acquired + " for message " + message);
                            }
                            if (!acquired) {
                                try {
                                    if (stackLogger.isLoggingEnabled(32)) {
                                        stackLogger.logDebug("trying to acquiring semaphore for message " + message);
                                    }
                                    callIdSemaphore.acquire();
                                }
                                catch (InterruptedException e) {
                                    stackLogger.logError("Semaphore acquisition for message " + message + " interrupted", e);
                                }
                                if (stackLogger.isLoggingEnabled(32)) {
                                    stackLogger.logDebug("semaphore acquired for message " + message);
                                }
                            }
                            try {
                                try {
                                    PipelinedMsgParser.this.sipMessageListener.processMessage(message);
                                }
                                catch (Exception e) {
                                    stackLogger.logError("Error occured processing message", e);
                                    Object var3_4 = null;
                                    if (stackLogger.isLoggingEnabled(32)) {
                                        stackLogger.logDebug("releasing semaphore for message " + message);
                                    }
                                    callIdSemaphore.release();
                                    if (callIdSemaphore.hasQueuedThreads()) return;
                                    PipelinedMsgParser.this.messagesOrderingMap.remove(callId);
                                    if (!stackLogger.isLoggingEnabled(32)) return;
                                    stackLogger.logDebug("semaphore removed for message " + message);
                                    return;
                                }
                                Object var3_3 = null;
                                if (stackLogger.isLoggingEnabled(32)) {
                                    stackLogger.logDebug("releasing semaphore for message " + message);
                                }
                                callIdSemaphore.release();
                                if (callIdSemaphore.hasQueuedThreads()) return;
                                PipelinedMsgParser.this.messagesOrderingMap.remove(callId);
                            }
                            catch (Throwable throwable) {
                                Object var3_5 = null;
                                if (stackLogger.isLoggingEnabled(32)) {
                                    stackLogger.logDebug("releasing semaphore for message " + message);
                                }
                                callIdSemaphore.release();
                                if (callIdSemaphore.hasQueuedThreads()) throw throwable;
                                PipelinedMsgParser.this.messagesOrderingMap.remove(callId);
                                if (!stackLogger.isLoggingEnabled(32)) throw throwable;
                                stackLogger.logDebug("semaphore removed for message " + message);
                                throw throwable;
                            }
                            if (!stackLogger.isLoggingEnabled(32)) return;
                            stackLogger.logDebug("semaphore removed for message " + message);
                        }
                    };
                    postParseExecutor.execute(messageDispatchTask);
                }
                catch (Exception ex) {
                    Object var16_29 = null;
                    try {
                        inputStream.close();
                    }
                    catch (IOException e) {
                        InternalErrorHandler.handleException(e);
                    }
                    break;
                }
            }
            catch (Throwable throwable) {
                Object var16_30 = null;
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    InternalErrorHandler.handleException(e);
                }
                throw throwable;
            }
        }
    }

    public static void setPostParseExcutorSize(int threads) {
        if (postParseExecutor == null) {
            postParseExecutor = threads <= 0 ? null : Executors.newFixedThreadPool(threads);
        }
    }

    public void close() {
        try {
            this.rawInputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

