/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.core.net;

import gov.nist.core.net.NetworkLayer;
import java.io.IOException;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;

public class DefaultNetworkLayer
implements NetworkLayer {
    private SSLSocketFactory sslSocketFactory;
    private SSLServerSocketFactory sslServerSocketFactory = (SSLServerSocketFactory)SSLServerSocketFactory.getDefault();
    public static final DefaultNetworkLayer SINGLETON = new DefaultNetworkLayer();

    private DefaultNetworkLayer() {
        this.sslSocketFactory = (SSLSocketFactory)SSLSocketFactory.getDefault();
    }

    public ServerSocket createServerSocket(int port, int backlog, InetAddress bindAddress) throws IOException {
        return new ServerSocket(port, backlog, bindAddress);
    }

    public Socket createSocket(InetAddress address, int port) throws IOException {
        return new Socket(address, port);
    }

    public DatagramSocket createDatagramSocket() throws SocketException {
        return new DatagramSocket();
    }

    public DatagramSocket createDatagramSocket(int port, InetAddress laddr) throws SocketException {
        if (laddr.isMulticastAddress()) {
            try {
                MulticastSocket ds = new MulticastSocket(port);
                ds.joinGroup(laddr);
                return ds;
            }
            catch (IOException e) {
                throw new SocketException(e.getLocalizedMessage());
            }
        }
        return new DatagramSocket(port, laddr);
    }

    public SSLServerSocket createSSLServerSocket(int port, int backlog, InetAddress bindAddress) throws IOException {
        return (SSLServerSocket)this.sslServerSocketFactory.createServerSocket(port, backlog, bindAddress);
    }

    public SSLSocket createSSLSocket(InetAddress address, int port) throws IOException {
        return (SSLSocket)this.sslSocketFactory.createSocket(address, port);
    }

    public SSLSocket createSSLSocket(InetAddress address, int port, InetAddress myAddress) throws IOException {
        return (SSLSocket)this.sslSocketFactory.createSocket(address, port, myAddress, 0);
    }

    public Socket createSocket(InetAddress address, int port, InetAddress myAddress) throws IOException {
        if (myAddress != null) {
            return new Socket(address, port, myAddress, 0);
        }
        return new Socket(address, port);
    }
}

