/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.javax.sip.stack;

import gov.nist.core.InternalErrorHandler;
import gov.nist.core.NameValueList;
import gov.nist.javax.sip.DialogExt;
import gov.nist.javax.sip.ListeningPointImpl;
import gov.nist.javax.sip.SipProviderImpl;
import gov.nist.javax.sip.Utils;
import gov.nist.javax.sip.address.AddressImpl;
import gov.nist.javax.sip.address.SipUri;
import gov.nist.javax.sip.header.Authorization;
import gov.nist.javax.sip.header.CSeq;
import gov.nist.javax.sip.header.Contact;
import gov.nist.javax.sip.header.ContactList;
import gov.nist.javax.sip.header.From;
import gov.nist.javax.sip.header.MaxForwards;
import gov.nist.javax.sip.header.RAck;
import gov.nist.javax.sip.header.RSeq;
import gov.nist.javax.sip.header.RecordRoute;
import gov.nist.javax.sip.header.RecordRouteList;
import gov.nist.javax.sip.header.Require;
import gov.nist.javax.sip.header.Route;
import gov.nist.javax.sip.header.RouteList;
import gov.nist.javax.sip.header.SIPHeader;
import gov.nist.javax.sip.header.TimeStamp;
import gov.nist.javax.sip.header.To;
import gov.nist.javax.sip.header.Via;
import gov.nist.javax.sip.message.SIPMessage;
import gov.nist.javax.sip.message.SIPRequest;
import gov.nist.javax.sip.message.SIPResponse;
import gov.nist.javax.sip.stack.MessageChannel;
import gov.nist.javax.sip.stack.SIPClientTransaction;
import gov.nist.javax.sip.stack.SIPServerTransaction;
import gov.nist.javax.sip.stack.SIPStackTimerTask;
import gov.nist.javax.sip.stack.SIPTransaction;
import gov.nist.javax.sip.stack.SIPTransactionStack;
import gov.nist.javax.sip.stack.TCPMessageChannel;
import gov.nist.javax.sip.stack.TLSMessageChannel;
import java.io.IOException;
import java.io.Serializable;
import java.net.InetAddress;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.TimerTask;
import javax.sip.ClientTransaction;
import javax.sip.Dialog;
import javax.sip.DialogDoesNotExistException;
import javax.sip.DialogState;
import javax.sip.IOExceptionEvent;
import javax.sip.InvalidArgumentException;
import javax.sip.SipException;
import javax.sip.Transaction;
import javax.sip.TransactionDoesNotExistException;
import javax.sip.address.Address;
import javax.sip.address.Hop;
import javax.sip.address.SipURI;
import javax.sip.header.CallIdHeader;
import javax.sip.header.ContactHeader;
import javax.sip.header.EventHeader;
import javax.sip.header.Header;
import javax.sip.header.OptionTag;
import javax.sip.header.RequireHeader;
import javax.sip.message.Request;
import javax.sip.message.Response;

public class SIPDialog
implements Dialog,
DialogExt {
    private static final long serialVersionUID = -1429794423085204069L;
    private boolean dialogTerminatedEventDelivered;
    private String method;
    private boolean isAssigned;
    private boolean reInviteFlag;
    private Object applicationData;
    private SIPRequest originalRequest;
    private SIPResponse lastResponse;
    private SIPTransaction firstTransaction;
    private SIPTransaction lastTransaction;
    private String dialogId;
    private String earlyDialogId;
    private long localSequenceNumber;
    private long remoteSequenceNumber;
    private String myTag;
    private String hisTag;
    private RouteList routeList;
    private transient SIPTransactionStack sipStack;
    private int dialogState;
    private boolean ackSeen;
    protected SIPRequest lastAck;
    protected boolean ackProcessed;
    protected DialogTimerTask timerTask;
    protected Long nextSeqno;
    private int retransmissionTicksLeft;
    private int prevRetransmissionTicks;
    private long originalLocalSequenceNumber;
    private int ackLine;
    public long auditTag = 0L;
    private Address localParty;
    private Address remoteParty;
    protected CallIdHeader callIdHeader;
    public static final int NULL_STATE = -1;
    public static final int EARLY_STATE = 0;
    public static final int CONFIRMED_STATE = 1;
    public static final int TERMINATED_STATE = 3;
    private static final int DIALOG_LINGER_TIME = 8;
    private boolean serverTransactionFlag;
    private transient SipProviderImpl sipProvider;
    private boolean terminateOnBye;
    private boolean byeSent;
    private Address remoteTarget;
    private EventHeader eventHeader;
    private boolean lastInviteOkReceived;

    private SIPDialog() {
        this.terminateOnBye = true;
        this.routeList = new RouteList();
        this.dialogState = -1;
        this.localSequenceNumber = 0L;
        this.remoteSequenceNumber = -1L;
    }

    public SIPDialog(SIPTransaction transaction) {
        this();
        SIPRequest sipRequest = (SIPRequest)transaction.getRequest();
        this.earlyDialogId = sipRequest.getDialogId(false);
        if (transaction == null) {
            throw new NullPointerException("Null tx");
        }
        this.sipStack = transaction.sipStack;
        this.sipProvider = transaction.getSipProvider();
        if (this.sipProvider == null) {
            throw new NullPointerException("Null Provider!");
        }
        this.addTransaction(transaction);
        if (this.sipStack.isLoggingEnabled()) {
            this.sipStack.logWriter.logDebug("Creating a dialog : " + this);
            this.sipStack.logWriter.logDebug("provider port = " + this.sipProvider.getListeningPoint().getPort());
            this.sipStack.logWriter.logStackTrace();
        }
    }

    public SIPDialog(SIPTransaction transaction, SIPResponse sipResponse) {
        this(transaction);
        if (sipResponse == null) {
            throw new NullPointerException("Null SipResponse");
        }
        this.setLastResponse(transaction, sipResponse);
    }

    public SIPDialog(SipProviderImpl sipProvider, SIPResponse sipResponse) {
        this.sipProvider = sipProvider;
        this.sipStack = (SIPTransactionStack)sipProvider.getSipStack();
        this.setLastResponse(null, sipResponse);
        this.originalLocalSequenceNumber = this.localSequenceNumber = sipResponse.getCSeq().getSeqNumber();
        this.myTag = sipResponse.getFrom().getTag();
        this.hisTag = sipResponse.getTo().getTag();
        this.localParty = sipResponse.getFrom().getAddress();
        this.remoteParty = sipResponse.getTo().getAddress();
        this.method = sipResponse.getCSeq().getMethod();
        this.callIdHeader = sipResponse.getCallId();
        this.serverTransactionFlag = false;
        if (this.sipStack.isLoggingEnabled()) {
            this.sipStack.logWriter.logDebug("Creating a dialog : " + this);
            this.sipStack.logWriter.logStackTrace();
        }
    }

    private void printRouteList() {
        if (this.sipStack.isLoggingEnabled()) {
            this.sipStack.logWriter.logDebug("this : " + this);
            this.sipStack.logWriter.logDebug("printRouteList : " + this.routeList.encode());
        }
    }

    private boolean isClientDialog() {
        SIPTransaction transaction = (SIPTransaction)this.getFirstTransaction();
        return transaction instanceof SIPClientTransaction;
    }

    private void raiseIOException(String host, int port, String protocol) {
        IOExceptionEvent ioError = new IOExceptionEvent((Object)this, host, port, protocol);
        this.sipProvider.handleEvent((EventObject)ioError, null);
        this.setState(3);
    }

    private void setRemoteParty(SIPMessage sipMessage) {
        this.remoteParty = !this.isServer() ? sipMessage.getTo().getAddress() : sipMessage.getFrom().getAddress();
        if (this.sipStack.getLogWriter().isLoggingEnabled()) {
            this.sipStack.getLogWriter().logDebug("settingRemoteParty " + this.remoteParty);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void addRoute(RecordRouteList recordRouteList) {
        try {
            AddressImpl address;
            Route route;
            RecordRoute rr;
            boolean addRoute;
            ListIterator li;
            if (this.isClientDialog()) {
                this.routeList = new RouteList();
                li = recordRouteList.listIterator(recordRouteList.size());
                addRoute = true;
                while (li.hasPrevious()) {
                    rr = (RecordRoute)li.previous();
                    if (!addRoute) continue;
                    route = new Route();
                    address = (AddressImpl)((AddressImpl)rr.getAddress()).clone();
                    route.setAddress(address);
                    route.setParameters((NameValueList)rr.getParameters().clone());
                    this.routeList.add(route);
                }
            } else {
                this.routeList = new RouteList();
                li = recordRouteList.listIterator();
                addRoute = true;
                while (li.hasNext()) {
                    rr = (RecordRoute)li.next();
                    if (!addRoute) continue;
                    route = new Route();
                    address = (AddressImpl)((AddressImpl)rr.getAddress()).clone();
                    route.setAddress(address);
                    route.setParameters((NameValueList)rr.getParameters().clone());
                    this.routeList.add(route);
                }
            }
            Object var8_7 = null;
            if (!this.sipStack.getLogWriter().isLoggingEnabled()) return;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            if (!this.sipStack.getLogWriter().isLoggingEnabled()) throw throwable;
            Iterator it = this.routeList.iterator();
            while (it.hasNext()) {
                SipURI sipUri = (SipURI)((Route)it.next()).getAddress().getURI();
                if (sipUri.hasLrParam()) continue;
                this.sipStack.getLogWriter().logWarning("NON LR route in Route set detected for dialog : " + this);
                this.sipStack.getLogWriter().logStackTrace();
            }
            throw throwable;
        }
        Iterator it = this.routeList.iterator();
        while (it.hasNext()) {
            SipURI sipUri = (SipURI)((Route)it.next()).getAddress().getURI();
            if (sipUri.hasLrParam()) continue;
            this.sipStack.getLogWriter().logWarning("NON LR route in Route set detected for dialog : " + this);
            this.sipStack.getLogWriter().logStackTrace();
        }
        return;
    }

    private void setRemoteTarget(ContactHeader contact) {
        this.remoteTarget = contact.getAddress();
        if (this.sipStack.isLoggingEnabled()) {
            this.sipStack.getLogWriter().logDebug("Dialog.setRemoteTarget: " + this.remoteTarget);
            this.sipStack.getLogWriter().logStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private synchronized void addRoute(SIPResponse sipResponse) {
        block12: {
            block11: {
                block10: {
                    try {
                        if (this.sipStack.isLoggingEnabled()) {
                            this.sipStack.logWriter.logDebug("setContact: dialogState: " + this + "state = " + this.getState());
                        }
                        if (sipResponse.getStatusCode() == 100) {
                            Object var5_2 = null;
                            if (!this.sipStack.isLoggingEnabled()) return;
                            this.sipStack.logWriter.logStackTrace();
                            return;
                        }
                        if (this.dialogState == 3) {
                            break block10;
                        }
                        if (this.dialogState == 1) {
                            ContactList contactList;
                            if (sipResponse.getStatusCode() / 100 == 2 && !this.isServer() && (contactList = sipResponse.getContactHeaders()) != null && SIPRequest.isTargetRefresh(sipResponse.getCSeq().getMethod())) {
                                this.setRemoteTarget((ContactHeader)contactList.getFirst());
                            }
                            break block11;
                        }
                        if (this.isServer()) break block12;
                        RecordRouteList rrlist = sipResponse.getRecordRouteHeaders();
                        if (rrlist != null) {
                            this.addRoute(rrlist);
                        } else {
                            this.routeList = new RouteList();
                        }
                        ContactList contactList = sipResponse.getContactHeaders();
                        if (contactList != null) {
                            this.setRemoteTarget((ContactHeader)contactList.getFirst());
                        }
                        break block12;
                    }
                    catch (Throwable throwable) {
                        Object var5_6 = null;
                        if (!this.sipStack.isLoggingEnabled()) throw throwable;
                        this.sipStack.logWriter.logStackTrace();
                        throw throwable;
                    }
                }
                Object var5_3 = null;
                if (!this.sipStack.isLoggingEnabled()) return;
                this.sipStack.logWriter.logStackTrace();
                return;
            }
            Object var5_4 = null;
            if (!this.sipStack.isLoggingEnabled()) return;
            this.sipStack.logWriter.logStackTrace();
            return;
        }
        Object var5_5 = null;
        if (!this.sipStack.isLoggingEnabled()) return;
        this.sipStack.logWriter.logStackTrace();
    }

    private synchronized RouteList getRouteList() {
        if (this.sipStack.isLoggingEnabled()) {
            this.sipStack.logWriter.logDebug("getRouteList " + this);
        }
        RouteList retval = new RouteList();
        retval = new RouteList();
        if (this.routeList != null) {
            ListIterator li = this.routeList.listIterator();
            while (li.hasNext()) {
                Route route = (Route)li.next();
                retval.add((Route)route.clone());
            }
        }
        if (this.sipStack.isLoggingEnabled()) {
            this.sipStack.logWriter.logDebug("----- ");
            this.sipStack.logWriter.logDebug("getRouteList for " + this);
            if (retval != null) {
                this.sipStack.logWriter.logDebug("RouteList = " + retval.encode());
            }
            if (this.routeList != null) {
                this.sipStack.logWriter.logDebug("myRouteList = " + this.routeList.encode());
            }
            this.sipStack.logWriter.logDebug("----- ");
        }
        return retval;
    }

    private void sendAck(Request request, boolean throwIOExceptionAsSipException) throws SipException {
        SIPRequest ackRequest = (SIPRequest)request;
        if (this.sipStack.isLoggingEnabled()) {
            this.sipStack.logWriter.logDebug("sendAck" + this);
        }
        if (!ackRequest.getMethod().equals("ACK")) {
            throw new SipException("Bad request method -- should be ACK");
        }
        if (this.getState() == null || this.getState().getValue() == 0) {
            if (this.sipStack.logWriter.isLoggingEnabled()) {
                this.sipStack.logWriter.logError("Bad Dialog State for " + this + " dialogID = " + this.getDialogId());
            }
            throw new SipException("Bad dialog state " + this.getState());
        }
        if (!this.getCallId().getCallId().equals(((SIPRequest)request).getCallId().getCallId())) {
            if (this.sipStack.isLoggingEnabled()) {
                this.sipStack.logWriter.logError("CallID " + this.getCallId());
                this.sipStack.logWriter.logError("RequestCallID = " + ackRequest.getCallId().getCallId());
                this.sipStack.logWriter.logError("dialog =  " + this);
            }
            throw new SipException("Bad call ID in request");
        }
        try {
            if (this.sipStack.isLoggingEnabled()) {
                this.sipStack.logWriter.logDebug("setting from tag For outgoing ACK= " + this.getLocalTag());
                this.sipStack.logWriter.logDebug("setting To tag for outgoing ACK = " + this.getRemoteTag());
                this.sipStack.logWriter.logDebug("ack = " + ackRequest);
            }
            if (this.getLocalTag() != null) {
                ackRequest.getFrom().setTag(this.getLocalTag());
            }
            if (this.getRemoteTag() != null) {
                ackRequest.getTo().setTag(this.getRemoteTag());
            }
        }
        catch (ParseException ex) {
            throw new SipException(ex.getMessage());
        }
        Hop hop = this.sipStack.getNextHop(ackRequest);
        if (hop == null) {
            throw new SipException("No route!");
        }
        try {
            ListeningPointImpl lp;
            if (this.sipStack.isLoggingEnabled()) {
                this.sipStack.logWriter.logDebug("hop = " + hop);
            }
            if ((lp = (ListeningPointImpl)this.sipProvider.getListeningPoint(hop.getTransport())) == null) {
                throw new SipException("No listening point for this provider registered at " + hop);
            }
            InetAddress inetAddress = InetAddress.getByName(hop.getHost());
            MessageChannel messageChannel = lp.getMessageProcessor().createMessageChannel(inetAddress, hop.getPort());
            this.lastAck = ackRequest;
            messageChannel.sendMessage(ackRequest);
        }
        catch (IOException ex) {
            if (throwIOExceptionAsSipException) {
                throw new SipException("Could not send ack", (Throwable)ex);
            }
            this.raiseIOException(hop.getHost(), hop.getPort(), hop.getTransport());
        }
        catch (SipException ex) {
            if (this.sipStack.isLoggingEnabled()) {
                this.sipStack.logWriter.logException(ex);
            }
            throw ex;
        }
        catch (Exception ex) {
            if (this.sipStack.isLoggingEnabled()) {
                this.sipStack.logWriter.logException(ex);
            }
            throw new SipException("Could not create message channel", (Throwable)ex);
        }
        this.ackSeen = true;
    }

    void setStack(SIPTransactionStack sipStack) {
        this.sipStack = sipStack;
    }

    boolean isTerminatedOnBye() {
        return this.terminateOnBye;
    }

    void ackReceived(SIPRequest sipRequest) {
        if (this.ackSeen) {
            return;
        }
        SIPServerTransaction tr = this.getInviteTransaction();
        if (tr != null && tr.getCSeq() == sipRequest.getCSeq().getSeqNumber()) {
            if (this.timerTask != null) {
                this.timerTask.cancel();
                this.timerTask = null;
            }
            this.ackSeen = true;
            this.lastAck = sipRequest;
            if (this.sipStack.isLoggingEnabled()) {
                this.sipStack.logWriter.logDebug("ackReceived for " + tr.getMethod());
                this.ackLine = this.sipStack.logWriter.getLineCount();
                this.printDebugInfo();
            }
            this.setState(1);
        }
    }

    synchronized boolean testAndSetIsDialogTerminatedEventDelivered() {
        boolean retval = this.dialogTerminatedEventDelivered;
        this.dialogTerminatedEventDelivered = true;
        return retval;
    }

    public void setApplicationData(Object applicationData) {
        this.applicationData = applicationData;
    }

    public Object getApplicationData() {
        return this.applicationData;
    }

    public synchronized void requestConsumed() {
        this.nextSeqno = new Long(this.getRemoteSeqNumber() + 1L);
        if (this.sipStack.isLoggingEnabled()) {
            this.sipStack.logWriter.logDebug("Request Consumed -- next consumable Request Seqno = " + this.nextSeqno);
        }
    }

    public synchronized boolean isRequestConsumable(SIPRequest dialogRequest) {
        if (dialogRequest.getMethod().equals("ACK")) {
            throw new RuntimeException("Illegal method");
        }
        return this.remoteSequenceNumber < dialogRequest.getCSeq().getSeqNumber();
    }

    public void doDeferredDelete() {
        if (this.sipStack.getTimer() == null) {
            this.setState(3);
        } else {
            this.sipStack.getTimer().schedule((TimerTask)new DialogDeleteTask(), 32000L);
        }
    }

    public void setState(int state) {
        if (this.sipStack.isLoggingEnabled()) {
            this.sipStack.logWriter.logDebug("Setting dialog state for " + this + "newState = " + state);
            this.sipStack.logWriter.logStackTrace();
            if (state != -1 && state != this.dialogState && this.sipStack.isLoggingEnabled()) {
                this.sipStack.logWriter.logDebug(this + "  old dialog state is " + this.getState());
                this.sipStack.logWriter.logDebug(this + "  New dialog state is " + DialogState.getObject((int)state));
            }
        }
        this.dialogState = state;
        if (state == 3) {
            if (this.sipStack.getTimer() != null) {
                this.sipStack.getTimer().schedule((TimerTask)new LingerTimer(), 8000L);
            }
            this.stopTimer();
        }
    }

    public void printDebugInfo() {
        if (this.sipStack.isLoggingEnabled()) {
            this.sipStack.logWriter.logDebug("isServer = " + this.isServer());
            this.sipStack.logWriter.logDebug("localTag = " + this.getLocalTag());
            this.sipStack.logWriter.logDebug("remoteTag = " + this.getRemoteTag());
            this.sipStack.logWriter.logDebug("localSequenceNumer = " + this.getLocalSeqNumber());
            this.sipStack.logWriter.logDebug("remoteSequenceNumer = " + this.getRemoteSeqNumber());
            this.sipStack.logWriter.logDebug("ackLine:" + this.getRemoteTag() + " " + this.ackLine);
        }
    }

    public boolean isAckSeen() {
        return this.ackSeen;
    }

    public SIPRequest getLastAck() {
        return this.lastAck;
    }

    public Transaction getFirstTransaction() {
        return this.firstTransaction;
    }

    public Iterator getRouteSet() {
        if (this.routeList == null) {
            return new LinkedList().listIterator();
        }
        return this.getRouteList().listIterator();
    }

    public synchronized void addRoute(SIPRequest sipRequest) {
        if (this.sipStack.isLoggingEnabled()) {
            this.sipStack.logWriter.logDebug("setContact: dialogState: " + this + "state = " + this.getState());
        }
        if (this.dialogState == 1 && SIPRequest.isTargetRefresh(sipRequest.getMethod())) {
            this.doTargetRefresh(sipRequest);
        }
        if (this.dialogState == 1 || this.dialogState == 3) {
            return;
        }
        RecordRouteList rrlist = sipRequest.getRecordRouteHeaders();
        if (rrlist != null) {
            this.addRoute(rrlist);
        } else {
            this.routeList = new RouteList();
        }
        ContactList contactList = sipRequest.getContactHeaders();
        if (contactList != null) {
            this.setRemoteTarget((ContactHeader)contactList.getFirst());
        }
    }

    public void setDialogId(String dialogId) {
        this.dialogId = dialogId;
    }

    public static SIPDialog createFromNOTIFY(SIPClientTransaction subscribeTx, SIPTransaction notifyST) {
        SIPDialog d = new SIPDialog(notifyST);
        d.serverTransactionFlag = false;
        d.firstTransaction = d.lastTransaction = subscribeTx;
        d.terminateOnBye = false;
        d.localSequenceNumber = d.firstTransaction.getCSeq();
        SIPRequest not = (SIPRequest)notifyST.getRequest();
        d.remoteSequenceNumber = not.getCSeq().getSeqNumber();
        d.setDialogId(not.getDialogId(true));
        d.setLocalTag(not.getToTag());
        d.setRemoteTag(not.getFromTag());
        d.setLastResponse(subscribeTx, subscribeTx.getLastResponse());
        d.localParty = not.getTo().getAddress();
        d.remoteParty = not.getFrom().getAddress();
        d.addRoute(not);
        d.setState(1);
        return d;
    }

    public boolean isServer() {
        if (this.firstTransaction == null) {
            return this.serverTransactionFlag;
        }
        return this.firstTransaction instanceof SIPServerTransaction;
    }

    protected boolean isReInvite() {
        return this.reInviteFlag;
    }

    public String getDialogId() {
        if (this.dialogId == null && this.lastResponse != null) {
            this.dialogId = this.lastResponse.getDialogId(this.isServer());
        }
        return this.dialogId;
    }

    public void addTransaction(SIPTransaction transaction) {
        SIPRequest sipRequest = transaction.getOriginalRequest();
        if (this.firstTransaction != null && this.firstTransaction != transaction && transaction.getMethod().equals(this.firstTransaction.getMethod())) {
            this.reInviteFlag = true;
        }
        if (this.firstTransaction == null) {
            this.firstTransaction = transaction;
            if (sipRequest.getMethod().equals("SUBSCRIBE")) {
                this.eventHeader = (EventHeader)sipRequest.getHeader("Event");
            }
            this.setLocalParty(sipRequest);
            this.setRemoteParty(sipRequest);
            this.setCallId(sipRequest);
            if (this.originalRequest == null) {
                this.originalRequest = sipRequest;
            }
            if (this.method == null) {
                this.method = sipRequest.getMethod();
            }
            if (transaction instanceof SIPServerTransaction) {
                this.hisTag = sipRequest.getFrom().getTag();
            } else {
                this.setLocalSequenceNumber(sipRequest.getCSeq().getSeqNumber());
                this.originalLocalSequenceNumber = this.localSequenceNumber;
                this.myTag = sipRequest.getFrom().getTag();
                if (this.myTag == null) {
                    this.sipStack.getLogWriter().logError("The request's From header is missing the required Tag parameter.");
                }
            }
        } else if (transaction.getMethod().equals(this.firstTransaction.getMethod()) && !this.firstTransaction.getClass().equals(transaction.getClass())) {
            this.firstTransaction = transaction;
            this.setLocalParty(sipRequest);
            this.setRemoteParty(sipRequest);
            this.setCallId(sipRequest);
            this.originalRequest = sipRequest;
            this.method = sipRequest.getMethod();
        }
        if (transaction instanceof SIPServerTransaction) {
            this.setRemoteSequenceNumber(sipRequest.getCSeq().getSeqNumber());
        }
        this.lastTransaction = transaction;
        if (this.sipStack.isLoggingEnabled()) {
            this.sipStack.logWriter.logDebug("Transaction Added " + this + this.myTag + "/" + this.hisTag);
            this.sipStack.logWriter.logDebug("TID = " + transaction.getTransactionId() + "/" + transaction.IsServerTransaction());
            this.sipStack.logWriter.logStackTrace();
        }
    }

    private void setRemoteTag(String hisTag) {
        if (this.sipStack.getLogWriter().isLoggingEnabled()) {
            this.sipStack.getLogWriter().logDebug("setRemoteTag(): " + this + " remoteTag = " + this.hisTag + " new tag = " + hisTag);
        }
        if (this.hisTag != null && !hisTag.equals(this.hisTag)) {
            if (this.getState() != DialogState.EARLY) {
                this.sipStack.getLogWriter().logDebug("Dialog is already established -- ignoring remote tag re-assignment");
                return;
            }
            if (this.sipStack.isRemoteTagReassignmentAllowed()) {
                this.sipStack.getLogWriter().logWarning("UNSAFE OPERATION ! Unexpected tag re-assignment " + this.hisTag + " trying to set to " + hisTag + " can cause unexpected effects ");
                boolean removed = false;
                if (this.sipStack.getDialog(this.dialogId) == this) {
                    this.sipStack.removeDialog(this.dialogId);
                    removed = true;
                }
                this.dialogId = null;
                this.hisTag = hisTag;
                if (removed) {
                    this.sipStack.getLogWriter().logDebug("ReInserting Dialog");
                    this.sipStack.putDialog(this);
                }
            }
        } else {
            this.hisTag = hisTag;
        }
    }

    public SIPTransaction getLastTransaction() {
        return this.lastTransaction;
    }

    public SIPServerTransaction getInviteTransaction() {
        DialogTimerTask t = this.timerTask;
        if (t != null) {
            return t.transaction;
        }
        return null;
    }

    private void setLocalSequenceNumber(long lCseq) {
        if (this.sipStack.isLoggingEnabled()) {
            this.sipStack.logWriter.logDebug("setLocalSequenceNumber: original \t" + this.localSequenceNumber + " new  = " + lCseq);
        }
        if (lCseq <= this.localSequenceNumber) {
            throw new RuntimeException("Sequence number should not decrease !");
        }
        this.localSequenceNumber = lCseq;
    }

    public void setRemoteSequenceNumber(long rCseq) {
        if (this.sipStack.isLoggingEnabled()) {
            this.sipStack.logWriter.logDebug("setRemoteSeqno " + this + "/" + rCseq);
        }
        this.remoteSequenceNumber = rCseq;
    }

    public void incrementLocalSequenceNumber() {
        ++this.localSequenceNumber;
    }

    public int getRemoteSequenceNumber() {
        return (int)this.remoteSequenceNumber;
    }

    public int getLocalSequenceNumber() {
        return (int)this.localSequenceNumber;
    }

    public long getOriginalLocalSequenceNumber() {
        return this.originalLocalSequenceNumber;
    }

    public long getLocalSeqNumber() {
        return this.localSequenceNumber;
    }

    public long getRemoteSeqNumber() {
        return this.remoteSequenceNumber;
    }

    public String getLocalTag() {
        return this.myTag;
    }

    public String getRemoteTag() {
        return this.hisTag;
    }

    private void setLocalTag(String mytag) {
        if (this.sipStack.isLoggingEnabled()) {
            this.sipStack.logWriter.logDebug("set Local tag " + mytag + " " + this.dialogId);
            this.sipStack.logWriter.logStackTrace();
        }
        this.myTag = mytag;
    }

    public void delete() {
        this.setState(3);
    }

    public CallIdHeader getCallId() {
        return this.callIdHeader;
    }

    private void setCallId(SIPRequest sipRequest) {
        this.callIdHeader = sipRequest.getCallId();
    }

    public Address getLocalParty() {
        return this.localParty;
    }

    private void setLocalParty(SIPMessage sipMessage) {
        this.localParty = !this.isServer() ? sipMessage.getFrom().getAddress() : sipMessage.getTo().getAddress();
    }

    public Address getRemoteParty() {
        if (this.sipStack.getLogWriter().isLoggingEnabled()) {
            this.sipStack.getLogWriter().logDebug("gettingRemoteParty " + this.remoteParty);
        }
        return this.remoteParty;
    }

    public Address getRemoteTarget() {
        return this.remoteTarget;
    }

    public DialogState getState() {
        if (this.dialogState == -1) {
            return null;
        }
        return DialogState.getObject((int)this.dialogState);
    }

    public boolean isSecure() {
        return this.getFirstTransaction().getRequest().getRequestURI().getScheme().equalsIgnoreCase("sips");
    }

    public void sendAck(Request request) throws SipException {
        this.sendAck(request, true);
    }

    public Request createRequest(String method) throws SipException {
        if (method.equals("ACK") || method.equals("PRACK")) {
            throw new SipException("Invalid method specified for createRequest:" + method);
        }
        if (this.lastResponse != null) {
            return this.createRequest(method, this.lastResponse);
        }
        throw new SipException("Dialog not yet established -- no response!");
    }

    private Request createRequest(String method, SIPResponse sipResponse) throws SipException {
        if (method == null || sipResponse == null) {
            throw new NullPointerException("null argument");
        }
        if (method.equals("CANCEL")) {
            throw new SipException("Dialog.createRequest(): Invalid request");
        }
        if (this.getState() == null || this.getState().getValue() == 3 && !method.equalsIgnoreCase("BYE") || this.isServer() && this.getState().getValue() == 0 && method.equalsIgnoreCase("BYE")) {
            throw new SipException("Dialog  " + this.getDialogId() + " not yet established or terminated " + this.getState());
        }
        SipUri sipUri = null;
        if (this.getRemoteTarget() != null) {
            sipUri = (SipUri)this.getRemoteTarget().getURI().clone();
        } else {
            sipUri = (SipUri)this.getRemoteParty().getURI().clone();
            sipUri.clearUriParms();
        }
        CSeq cseq = new CSeq();
        try {
            cseq.setMethod(method);
            cseq.setSeqNumber(this.getLocalSeqNumber());
        }
        catch (Exception ex) {
            this.sipStack.getLogWriter().logError("Unexpected error");
            InternalErrorHandler.handleException(ex);
        }
        ListeningPointImpl lp = (ListeningPointImpl)this.sipProvider.getListeningPoint(sipResponse.getTopmostVia().getTransport());
        if (lp == null) {
            if (this.sipStack.isLoggingEnabled()) {
                this.sipStack.getLogWriter().logError("Cannot find listening point for transport " + sipResponse.getTopmostVia().getTransport());
            }
            throw new SipException("Cannot find listening point for transport " + sipResponse.getTopmostVia().getTransport());
        }
        Via via = lp.getViaHeader();
        From from = new From();
        from.setAddress(this.localParty);
        To to = new To();
        to.setAddress(this.remoteParty);
        SIPRequest sipRequest = sipResponse.createRequest(sipUri, via, cseq, from, to);
        if (SIPRequest.isTargetRefresh(method)) {
            ContactHeader contactHeader = ((ListeningPointImpl)this.sipProvider.getListeningPoint(lp.getTransport())).createContactHeader();
            ((SipURI)contactHeader.getAddress().getURI()).setSecure(this.isSecure());
            sipRequest.setHeader((Header)contactHeader);
        }
        try {
            cseq = (CSeq)sipRequest.getCSeq();
            cseq.setSeqNumber(this.localSequenceNumber + 1L);
        }
        catch (InvalidArgumentException ex) {
            InternalErrorHandler.handleException((Exception)((Object)ex));
        }
        if (method.equals("SUBSCRIBE") && this.eventHeader != null) {
            sipRequest.addHeader((Header)this.eventHeader);
        }
        try {
            if (this.getLocalTag() != null) {
                from.setTag(this.getLocalTag());
            } else {
                from.removeTag();
            }
            if (this.getRemoteTag() != null) {
                to.setTag(this.getRemoteTag());
            } else {
                to.removeTag();
            }
        }
        catch (ParseException ex) {
            InternalErrorHandler.handleException(ex);
        }
        this.updateRequest(sipRequest);
        return sipRequest;
    }

    public void sendRequest(ClientTransaction clientTransactionId) throws TransactionDoesNotExistException, SipException {
        SIPRequest dialogRequest = ((SIPClientTransaction)clientTransactionId).getOriginalRequest();
        if (this.sipStack.isLoggingEnabled()) {
            this.sipStack.logWriter.logDebug("dialog.sendRequest  dialog = " + this + "\ndialogRequest = \n" + dialogRequest);
        }
        if (clientTransactionId == null) {
            throw new NullPointerException("null parameter");
        }
        if (dialogRequest.getMethod().equals("ACK") || dialogRequest.getMethod().equals("CANCEL")) {
            throw new SipException("Bad Request Method. " + dialogRequest.getMethod());
        }
        if (!(this.getState() != null || this.getMethod().equals("SUBSCRIBE") && dialogRequest.getMethod().equals("NOTIFY"))) {
            if (this.sipStack.isLoggingEnabled()) {
                this.sipStack.logWriter.logError("null dialog state for " + this);
            }
            throw new SipException("Bad dialog state " + this.getState());
        }
        if (this.byeSent && this.isTerminatedOnBye() && !dialogRequest.getMethod().equals("BYE")) {
            if (this.sipStack.isLoggingEnabled()) {
                this.sipStack.logWriter.logError("BYE already sent for " + this);
            }
            throw new SipException("Cannot send request; BYE already sent");
        }
        if (dialogRequest.getTopmostVia() == null) {
            Via via = ((SIPClientTransaction)clientTransactionId).getOutgoingViaHeader();
            dialogRequest.addHeader(via);
        }
        if (!this.getCallId().getCallId().equalsIgnoreCase(dialogRequest.getCallId().getCallId())) {
            if (this.sipStack.isLoggingEnabled()) {
                this.sipStack.logWriter.logError("CallID " + this.getCallId());
                this.sipStack.logWriter.logError("RequestCallID = " + dialogRequest.getCallId().getCallId());
                this.sipStack.logWriter.logError("dialog =  " + this);
            }
            throw new SipException("Bad call ID in request");
        }
        ((SIPClientTransaction)clientTransactionId).setDialog(this, this.dialogId);
        this.addTransaction((SIPTransaction)clientTransactionId);
        ((SIPClientTransaction)clientTransactionId).isMapped = true;
        From from = (From)dialogRequest.getFrom();
        To to = (To)dialogRequest.getTo();
        if (this.getLocalTag() != null && from.getTag() != null && !from.getTag().equals(this.getLocalTag())) {
            throw new SipException("From tag mismatch expecting\t " + this.getLocalTag());
        }
        if (this.getRemoteTag() != null && to.getTag() != null && !to.getTag().equals(this.getRemoteTag())) {
            throw new SipException("To header tag mismatch expecting " + this.getRemoteTag());
        }
        if (this.getLocalTag() == null && dialogRequest.getMethod().equals("NOTIFY")) {
            if (!this.getMethod().equals("SUBSCRIBE")) {
                throw new SipException("Trying to send NOTIFY without SUBSCRIBE Dialog!");
            }
            this.setLocalTag(from.getTag());
        }
        try {
            if (this.getLocalTag() != null) {
                from.setTag(this.getLocalTag());
            }
            if (this.getRemoteTag() != null) {
                to.setTag(this.getRemoteTag());
            }
        }
        catch (ParseException ex) {
            InternalErrorHandler.handleException(ex);
        }
        Hop hop = ((SIPClientTransaction)clientTransactionId).getNextHop();
        if (this.sipStack.isLoggingEnabled()) {
            this.sipStack.logWriter.logDebug("Using hop = " + hop.getHost() + " : " + hop.getPort());
        }
        try {
            TCPMessageChannel oldChannel = null;
            TLSMessageChannel oldTLSChannel = null;
            MessageChannel messageChannel = this.sipStack.createRawMessageChannel(this.getSipProvider().getListeningPoint(hop.getTransport()).getIPAddress(), this.firstTransaction.getPort(), hop);
            if (((SIPClientTransaction)clientTransactionId).getMessageChannel() instanceof TCPMessageChannel) {
                oldChannel = (TCPMessageChannel)((SIPClientTransaction)clientTransactionId).getMessageChannel();
                if (oldChannel.isCached && !oldChannel.isRunning) {
                    oldChannel.uncache();
                }
                if (!this.sipStack.cacheClientConnections) {
                    --oldChannel.useCount;
                    if (this.sipStack.isLoggingEnabled()) {
                        this.sipStack.logWriter.logDebug("oldChannel: useCount " + oldChannel.useCount);
                    }
                }
            } else if (((SIPClientTransaction)clientTransactionId).getMessageChannel() instanceof TLSMessageChannel) {
                oldTLSChannel = (TLSMessageChannel)((SIPClientTransaction)clientTransactionId).getMessageChannel();
                if (oldTLSChannel.isCached && !oldTLSChannel.isRunning) {
                    oldTLSChannel.uncache();
                }
                if (!this.sipStack.cacheClientConnections) {
                    --oldTLSChannel.useCount;
                    if (this.sipStack.isLoggingEnabled()) {
                        this.sipStack.logWriter.logDebug("oldChannel: useCount " + oldTLSChannel.useCount);
                    }
                }
            }
            if (messageChannel == null) {
                Hop outboundProxy;
                if (this.sipStack.isLoggingEnabled()) {
                    this.sipStack.logWriter.logDebug("Null message channel using outbound proxy !");
                }
                if ((outboundProxy = this.sipStack.getRouter(dialogRequest).getOutboundProxy()) == null) {
                    throw new SipException("No route found! hop=" + hop);
                }
                messageChannel = this.sipStack.createRawMessageChannel(this.getSipProvider().getListeningPoint(outboundProxy.getTransport()).getIPAddress(), this.firstTransaction.getPort(), outboundProxy);
                if (messageChannel != null) {
                    ((SIPClientTransaction)clientTransactionId).setEncapsulatedChannel(messageChannel);
                }
            } else {
                ((SIPClientTransaction)clientTransactionId).setEncapsulatedChannel(messageChannel);
                if (this.sipStack.isLoggingEnabled()) {
                    this.sipStack.logWriter.logDebug("using message channel " + messageChannel);
                }
            }
            if (messageChannel != null && messageChannel instanceof TCPMessageChannel) {
                ++((TCPMessageChannel)messageChannel).useCount;
            }
            if (messageChannel != null && messageChannel instanceof TLSMessageChannel) {
                ++((TLSMessageChannel)messageChannel).useCount;
            }
            if (!this.sipStack.cacheClientConnections && oldChannel != null && oldChannel.useCount <= 0) {
                oldChannel.close();
            }
            if (!this.sipStack.cacheClientConnections && oldTLSChannel != null && oldTLSChannel.useCount == 0) {
                oldTLSChannel.close();
            }
        }
        catch (Exception ex) {
            if (this.sipStack.isLoggingEnabled()) {
                this.sipStack.logWriter.logException(ex);
            }
            throw new SipException("Could not create message channel", (Throwable)ex);
        }
        try {
            ++this.localSequenceNumber;
            dialogRequest.getCSeq().setSeqNumber(this.getLocalSeqNumber());
        }
        catch (InvalidArgumentException ex) {
            ex.printStackTrace();
        }
        try {
            ((SIPClientTransaction)clientTransactionId).sendMessage(dialogRequest);
            if (dialogRequest.getMethod().equals("BYE")) {
                this.byeSent = true;
            }
        }
        catch (IOException ex) {
            throw new SipException("error sending message", (Throwable)ex);
        }
    }

    private boolean toRetransmitFinalResponse(int T2) {
        if (--this.retransmissionTicksLeft == 0) {
            this.retransmissionTicksLeft = 2 * this.prevRetransmissionTicks <= T2 ? 2 * this.prevRetransmissionTicks : this.prevRetransmissionTicks;
            this.prevRetransmissionTicks = this.retransmissionTicksLeft;
            return true;
        }
        return false;
    }

    protected void setRetransmissionTicks() {
        this.retransmissionTicksLeft = 1;
        this.prevRetransmissionTicks = 1;
    }

    public void resendAck() throws SipException {
        if (this.lastAck != null) {
            if (this.lastAck.getHeader("Timestamp") != null && this.sipStack.generateTimeStampHeader) {
                TimeStamp ts = new TimeStamp();
                try {
                    ts.setTimeStamp(System.currentTimeMillis());
                    this.lastAck.setHeader(ts);
                }
                catch (InvalidArgumentException invalidArgumentException) {
                    // empty catch block
                }
            }
            this.sendAck(this.lastAck, false);
        }
    }

    public String getMethod() {
        return this.method;
    }

    protected void startTimer(SIPServerTransaction transaction) {
        if (this.timerTask != null && this.timerTask.transaction == transaction) {
            this.sipStack.getLogWriter().logDebug("Timer already running for " + this.getDialogId());
            return;
        }
        if (this.sipStack.isLoggingEnabled()) {
            this.sipStack.getLogWriter().logDebug("Starting dialog timer for " + this.getDialogId());
        }
        this.ackSeen = false;
        if (this.timerTask != null) {
            this.timerTask.transaction = transaction;
        } else {
            this.timerTask = new DialogTimerTask(transaction);
            this.sipStack.getTimer().schedule((TimerTask)this.timerTask, 500L, 500L);
        }
        this.setRetransmissionTicks();
    }

    protected void stopTimer() {
        try {
            if (this.timerTask != null) {
                this.timerTask.cancel();
            }
            this.timerTask = null;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Request createPrack(Response relResponse) throws DialogDoesNotExistException, SipException {
        if (this.getState() == null || this.getState().equals((Object)DialogState.TERMINATED)) {
            throw new DialogDoesNotExistException("Dialog not initialized or terminated");
        }
        try {
            SIPResponse sipResponse = (SIPResponse)relResponse;
            SIPRequest sipRequest = (SIPRequest)this.createRequest("PRACK", (SIPResponse)relResponse);
            String toHeaderTag = sipResponse.getTo().getTag();
            sipRequest.setToTag(toHeaderTag);
            RAck rack = new RAck();
            RSeq rseq = (RSeq)relResponse.getHeader("RSeq");
            rack.setMethod(sipResponse.getCSeq().getMethod());
            rack.setCSequenceNumber((int)sipResponse.getCSeq().getSeqNumber());
            rack.setRSequenceNumber(rseq.getSeqNumber());
            sipRequest.setHeader(rack);
            return sipRequest;
        }
        catch (Exception ex) {
            InternalErrorHandler.handleException(ex);
            return null;
        }
    }

    private void updateRequest(SIPRequest sipRequest) {
        RouteList rl = this.getRouteList();
        if (rl.size() > 0) {
            sipRequest.setHeader((Header)rl);
        } else {
            sipRequest.removeHeader("Route");
        }
    }

    public Request createAck(long cseqno) throws InvalidArgumentException, SipException {
        if (!this.method.equals("INVITE")) {
            throw new SipException("Dialog was not created with an INVITE" + this.method);
        }
        if (cseqno <= 0L) {
            throw new InvalidArgumentException("bad cseq <= 0 ");
        }
        if (cseqno > 0xFFFFFFFFL) {
            throw new InvalidArgumentException("bad cseq > 4294967295");
        }
        if (this.remoteTarget == null) {
            throw new SipException("Cannot create ACK - no remote Target!");
        }
        if (this.sipStack.getLogWriter().isLoggingEnabled()) {
            this.sipStack.getLogWriter().logDebug("createAck " + this);
        }
        if (!this.lastInviteOkReceived) {
            throw new SipException("Dialog not yet established -- no OK response!");
        }
        this.lastInviteOkReceived = false;
        try {
            Authorization authorization;
            ListeningPointImpl lp;
            SipURI uri4transport = null;
            if (this.routeList != null && !this.routeList.isEmpty()) {
                Route r = (Route)this.routeList.getFirst();
                uri4transport = (SipURI)r.getAddress().getURI();
            } else {
                uri4transport = (SipURI)this.remoteTarget.getURI();
            }
            String transport = uri4transport.getTransportParam();
            if (transport == null) {
                String string = transport = uri4transport.isSecure() ? "TLS" : "UDP";
            }
            if ((lp = (ListeningPointImpl)this.sipProvider.getListeningPoint(transport)) == null) {
                this.sipStack.getLogWriter().logError("remoteTargetURI " + this.remoteTarget.getURI());
                this.sipStack.getLogWriter().logError("uri4transport = " + uri4transport);
                this.sipStack.getLogWriter().logError("No LP found for transport=" + transport);
                throw new SipException("Cannot create ACK - no ListeningPoint for transport towards next hop found:" + transport);
            }
            SIPRequest sipRequest = new SIPRequest();
            sipRequest.setMethod("ACK");
            sipRequest.setRequestURI((SipUri)this.getRemoteTarget().getURI().clone());
            sipRequest.setCallId(this.callIdHeader);
            sipRequest.setCSeq(new CSeq(cseqno, "ACK"));
            ArrayList<Via> vias = new ArrayList<Via>();
            SIPResponse response = this.getLastResponse();
            Via via = (Via)response.getTopmostVia().clone();
            via.setBranch(Utils.generateBranchId());
            vias.add(via);
            sipRequest.setVia(vias);
            From from = new From();
            from.setAddress(this.localParty);
            from.setTag(this.myTag);
            sipRequest.setFrom(from);
            To to = new To();
            to.setAddress(this.remoteParty);
            if (this.hisTag != null) {
                to.setTag(this.hisTag);
            }
            sipRequest.setTo(to);
            sipRequest.setMaxForwards(new MaxForwards(70));
            if (this.originalRequest != null && (authorization = this.originalRequest.getAuthorization()) != null) {
                sipRequest.setHeader(authorization);
            }
            this.updateRequest(sipRequest);
            return sipRequest;
        }
        catch (Exception ex) {
            InternalErrorHandler.handleException(ex);
            throw new SipException("unexpected exception ", (Throwable)ex);
        }
    }

    public SipProviderImpl getSipProvider() {
        return this.sipProvider;
    }

    public void setSipProvider(SipProviderImpl sipProvider) {
        this.sipProvider = sipProvider;
    }

    public boolean checkResponseTags(SIPResponse sipResponse) {
        if (this.isServer()) {
            if (sipResponse.getToTag() != null && this.getLocalTag() != null && !this.getLocalTag().equals(sipResponse.getToTag()) || sipResponse.getFromTag() != null && this.getRemoteTag() != null && !this.getRemoteTag().equals(sipResponse.getFromTag())) {
                if (this.sipStack.getLogWriter().isLoggingEnabled()) {
                    this.sipStack.getLogWriter().logError("sipResponse.getToTag() = " + sipResponse.getToTag());
                    this.sipStack.getLogWriter().logError("this.localTag()  = " + this.getLocalTag());
                    this.sipStack.getLogWriter().logError("sipResponse.getFromTag() = " + sipResponse.getFromTag());
                    this.sipStack.getLogWriter().logError("this.remoteTag = " + this.getRemoteTag());
                }
                return false;
            }
            return true;
        }
        return true;
    }

    public void setLastResponse(SIPTransaction transaction, SIPResponse sipResponse) {
        int statusCode = sipResponse.getStatusCode();
        if (statusCode == 100) {
            this.sipStack.getLogWriter().logWarning("Invalid status code - 100 in setLastResponse - ignoring");
            return;
        }
        this.lastResponse = sipResponse;
        this.setAssigned();
        if (this.sipStack.isLoggingEnabled()) {
            this.sipStack.getLogWriter().logDebug("sipDialog: setLastResponse:" + this + " lastResponse = " + this.lastResponse.getFirstLine());
        }
        if (this.getState() == DialogState.TERMINATED) {
            if (this.sipStack.isLoggingEnabled()) {
                this.sipStack.getLogWriter().logDebug("sipDialog: setLastResponse -- dialog is terminated - ignoring ");
            }
            return;
        }
        String cseqMethod = sipResponse.getCSeq().getMethod();
        if (this.sipStack.isLoggingEnabled()) {
            this.sipStack.getLogWriter().logStackTrace();
            this.sipStack.getLogWriter().logDebug("cseqMethod = " + cseqMethod);
            this.sipStack.getLogWriter().logDebug("dialogState = " + this.getState());
            this.sipStack.getLogWriter().logDebug("method = " + this.getMethod());
            this.sipStack.getLogWriter().logDebug("statusCode = " + statusCode);
            this.sipStack.getLogWriter().logDebug("transaction = " + transaction);
        }
        if (transaction == null || transaction instanceof ClientTransaction) {
            if (this.sipStack.isDialogCreated(cseqMethod)) {
                RecordRouteList rrList;
                if (this.getState() == null && statusCode / 100 == 1) {
                    this.setState(0);
                    if ((sipResponse.getToTag() != null || this.sipStack.rfc2543Supported) && this.getRemoteTag() == null) {
                        this.setRemoteTag(sipResponse.getToTag());
                        this.setDialogId(sipResponse.getDialogId(false));
                        this.sipStack.putDialog(this);
                        this.addRoute(sipResponse);
                    }
                } else if (statusCode / 100 == 2) {
                    if (cseqMethod.equals(this.getMethod()) && (sipResponse.getToTag() != null || this.sipStack.rfc2543Supported) && this.getState() != DialogState.CONFIRMED) {
                        this.setRemoteTag(sipResponse.getToTag());
                        this.setDialogId(sipResponse.getDialogId(false));
                        this.sipStack.putDialog(this);
                        this.addRoute(sipResponse);
                        this.setState(1);
                    }
                    if (cseqMethod.equals("INVITE")) {
                        this.lastInviteOkReceived = true;
                    }
                } else if (statusCode >= 300 && statusCode <= 699 && (this.getState() == null || cseqMethod.equals(this.getMethod()) && this.getState().getValue() == 0)) {
                    this.setState(3);
                }
                if (this.originalRequest != null && (rrList = this.originalRequest.getRecordRouteHeaders()) != null) {
                    ListIterator it = rrList.listIterator(rrList.size());
                    while (it.hasPrevious()) {
                        RecordRoute rr = (RecordRoute)it.previous();
                        Route route = (Route)this.routeList.getFirst();
                        if (route != null && rr.getAddress().equals(route.getAddress())) {
                            this.routeList.removeFirst();
                            continue;
                        }
                        break;
                    }
                }
            } else if (cseqMethod.equals("NOTIFY") && (this.getMethod().equals("SUBSCRIBE") || this.getMethod().equals("REFER")) && sipResponse.getStatusCode() / 100 == 2 && this.getState() == null) {
                this.setDialogId(sipResponse.getDialogId(true));
                this.sipStack.putDialog(this);
                this.setState(1);
            } else if (cseqMethod.equals("BYE") && statusCode / 100 == 2 && this.isTerminatedOnBye()) {
                this.setState(3);
            }
        } else {
            if (!cseqMethod.equals("CANCEL")) {
                if (cseqMethod.equals("BYE") && statusCode / 100 == 2 && this.isTerminatedOnBye()) {
                    this.setState(3);
                } else {
                    boolean doPutDialog = false;
                    if (this.getLocalTag() == null && sipResponse.getTo().getTag() != null && this.sipStack.isDialogCreated(cseqMethod) && cseqMethod.equals(this.getMethod())) {
                        this.setLocalTag(sipResponse.getTo().getTag());
                        doPutDialog = true;
                    }
                    if (statusCode / 100 != 2) {
                        if (statusCode / 100 == 1) {
                            if (doPutDialog) {
                                this.setState(0);
                                this.setDialogId(sipResponse.getDialogId(true));
                                this.sipStack.putDialog(this);
                            }
                        } else if (statusCode == 489 && (cseqMethod.equals("NOTIFY") || cseqMethod.equals("SUBSCRIBE"))) {
                            this.sipStack.logWriter.logDebug("RFC 3265 : Not setting dialog to TERMINATED for 489");
                        } else if (!this.isReInvite() && this.getState() != DialogState.CONFIRMED) {
                            this.setState(3);
                        }
                    } else {
                        if (this.dialogState <= 0 && (cseqMethod.equals("INVITE") || cseqMethod.equals("SUBSCRIBE") || cseqMethod.equals("REFER"))) {
                            this.setState(1);
                        }
                        if (doPutDialog) {
                            this.setDialogId(sipResponse.getDialogId(true));
                            this.sipStack.putDialog(this);
                        }
                    }
                }
            }
            if (statusCode / 100 == 2 && cseqMethod.equals("INVITE")) {
                SIPServerTransaction sipServerTx = (SIPServerTransaction)transaction;
                this.startTimer(sipServerTx);
            }
        }
    }

    public SIPResponse getLastResponse() {
        return this.lastResponse;
    }

    private void doTargetRefresh(SIPMessage sipMessage) {
        ContactList contactList = sipMessage.getContactHeaders();
        if (contactList != null) {
            Contact contact = (Contact)contactList.getFirst();
            this.setRemoteTarget(contact);
        }
    }

    private static final boolean optionPresent(ListIterator l, String option) {
        while (l.hasNext()) {
            OptionTag opt = (OptionTag)l.next();
            if (opt == null || !option.equalsIgnoreCase(opt.getOptionTag())) continue;
            return true;
        }
        return false;
    }

    public Response createReliableProvisionalResponse(int statusCode) throws InvalidArgumentException, SipException {
        SIPServerTransaction sipServerTransaction = (SIPServerTransaction)this.getFirstTransaction();
        if (!(sipServerTransaction instanceof SIPServerTransaction)) {
            throw new SipException("Not a Server Dialog!");
        }
        if (statusCode <= 100 || statusCode > 199) {
            throw new InvalidArgumentException("Bad status code ");
        }
        SIPRequest request = this.originalRequest;
        if (!request.getMethod().equals("INVITE")) {
            throw new SipException("Bad method");
        }
        ListIterator<SIPHeader> list = request.getHeaders("Supported");
        if (!(list != null && SIPDialog.optionPresent(list, "100rel") || (list = request.getHeaders("Require")) != null && SIPDialog.optionPresent(list, "100rel"))) {
            throw new SipException("No Supported/Require 100rel header in the request");
        }
        SIPResponse response = request.createResponse(statusCode);
        Require require = new Require();
        try {
            require.setOptionTag("100rel");
        }
        catch (Exception ex) {
            InternalErrorHandler.handleException(ex);
        }
        response.addHeader(require);
        RSeq rseq = new RSeq();
        rseq.setSeqNumber(1L);
        RecordRouteList rrl = request.getRecordRouteHeaders();
        if (rrl != null) {
            RecordRouteList rrlclone = (RecordRouteList)rrl.clone();
            response.setHeader((Header)rrlclone);
        }
        return response;
    }

    public boolean handlePrack(SIPRequest prackRequest) {
        if (!this.isServer()) {
            if (this.sipStack.isLoggingEnabled()) {
                this.sipStack.logWriter.logDebug("Dropping Prack -- not a server Dialog");
            }
            return false;
        }
        SIPServerTransaction sipServerTransaction = (SIPServerTransaction)this.getFirstTransaction();
        SIPResponse sipResponse = sipServerTransaction.getReliableProvisionalResponse();
        if (sipResponse == null) {
            if (this.sipStack.isLoggingEnabled()) {
                this.sipStack.logWriter.logDebug("Dropping Prack -- ReliableResponse not found");
            }
            return false;
        }
        RAck rack = (RAck)prackRequest.getHeader("RAck");
        if (rack == null) {
            if (this.sipStack.isLoggingEnabled()) {
                this.sipStack.logWriter.logDebug("Dropping Prack -- rack header not found");
            }
            return false;
        }
        CSeq cseq = (CSeq)sipResponse.getCSeq();
        if (!rack.getMethod().equals(cseq.getMethod())) {
            if (this.sipStack.isLoggingEnabled()) {
                this.sipStack.logWriter.logDebug("Dropping Prack -- CSeq Header does not match PRACK");
            }
            return false;
        }
        if (rack.getCSeqNumberLong() != cseq.getSeqNumber()) {
            if (this.sipStack.isLoggingEnabled()) {
                this.sipStack.logWriter.logDebug("Dropping Prack -- CSeq Header does not match PRACK");
            }
            return false;
        }
        RSeq rseq = (RSeq)sipResponse.getHeader("RSeq");
        if (rack.getRSequenceNumber() != rseq.getSeqNumber()) {
            if (this.sipStack.isLoggingEnabled()) {
                this.sipStack.logWriter.logDebug("Dropping Prack -- RSeq Header does not match PRACK");
            }
            return false;
        }
        return sipServerTransaction.prackRecieved();
    }

    public void sendReliableProvisionalResponse(Response relResponse) throws SipException {
        if (!this.isServer()) {
            throw new SipException("Not a Server Dialog");
        }
        SIPResponse sipResponse = (SIPResponse)relResponse;
        if (relResponse.getStatusCode() == 100) {
            throw new SipException("Cannot send 100 as a reliable provisional response");
        }
        if (relResponse.getStatusCode() / 100 > 2) {
            throw new SipException("Response code is not a 1xx response - should be in the range 101 to 199 ");
        }
        if (sipResponse.getToTag() == null) {
            throw new SipException("Badly formatted response -- To tag mandatory for Reliable Provisional Response");
        }
        ListIterator requireList = relResponse.getHeaders("Require");
        boolean found = false;
        if (requireList != null) {
            while (requireList.hasNext() && !found) {
                RequireHeader rh = (RequireHeader)requireList.next();
                if (!rh.getOptionTag().equalsIgnoreCase("100rel")) continue;
                found = true;
            }
        }
        if (!found) {
            Require require = new Require("100rel");
            relResponse.addHeader((Header)require);
            if (this.sipStack.getLogWriter().isLoggingEnabled()) {
                this.sipStack.getLogWriter().logDebug("Require header with optionTag 100rel is needed -- adding one");
            }
        }
        SIPServerTransaction serverTransaction = (SIPServerTransaction)this.getFirstTransaction();
        this.setLastResponse(serverTransaction, sipResponse);
        this.setDialogId(sipResponse.getDialogId(true));
        serverTransaction.sendReliableProvisionalResponse(relResponse);
    }

    public void terminateOnBye(boolean terminateFlag) throws SipException {
        this.terminateOnBye = terminateFlag;
    }

    public void setAssigned() {
        this.isAssigned = true;
    }

    public boolean isAssigned() {
        return this.isAssigned;
    }

    public Contact getMyContactHeader() {
        if (this.isServer()) {
            SIPServerTransaction st = (SIPServerTransaction)this.getFirstTransaction();
            SIPResponse response = st.getLastResponse();
            return response != null ? response.getContactHeader() : null;
        }
        SIPClientTransaction ct = (SIPClientTransaction)this.getFirstTransaction();
        if (ct == null) {
            return null;
        }
        SIPRequest sipRequest = ct.getOriginalRequest();
        return sipRequest.getContactHeader();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Dialog)) {
            return false;
        }
        String id1 = this.getDialogId();
        String id2 = ((Dialog)obj).getDialogId();
        return id1 != null && id2 != null && id1.equals(id2);
    }

    public boolean handleAck(SIPServerTransaction ackTransaction) {
        SIPResponse sipResponse;
        SIPRequest sipRequest = ackTransaction.getOriginalRequest();
        if (this.isAckSeen() && this.getRemoteSeqNumber() == sipRequest.getCSeq().getSeqNumber()) {
            if (this.sipStack.isLoggingEnabled()) {
                this.sipStack.getLogWriter().logDebug("ACK already seen by dialog -- dropping Ack retransmission");
            }
            if (this.timerTask != null) {
                this.timerTask.cancel();
                this.timerTask = null;
            }
            return false;
        }
        if (this.getState() == DialogState.TERMINATED) {
            if (this.sipStack.isLoggingEnabled()) {
                this.sipStack.getLogWriter().logDebug("Dialog is terminated -- dropping ACK");
            }
            return false;
        }
        SIPServerTransaction tr = this.getInviteTransaction();
        SIPResponse sIPResponse = sipResponse = tr != null ? tr.getLastResponse() : null;
        if (tr != null && sipResponse != null && sipResponse.getStatusCode() / 100 == 2 && sipResponse.getCSeq().getMethod().equals("INVITE") && sipResponse.getCSeq().getSeqNumber() == sipRequest.getCSeq().getSeqNumber()) {
            ackTransaction.setDialog(this, sipResponse.getDialogId(false));
            this.ackReceived(sipRequest);
            this.sipStack.getLogWriter().logDebug("ACK for 2XX response --- sending to TU ");
            return true;
        }
        if (this.sipStack.isLoggingEnabled()) {
            this.sipStack.getLogWriter().logDebug(" INVITE transaction not found  -- Discarding ACK");
        }
        return false;
    }

    void setEarlyDialogId(String earlyDialogId) {
        this.earlyDialogId = earlyDialogId;
    }

    String getEarlyDialogId() {
        return this.earlyDialogId;
    }

    class DialogDeleteTask
    extends SIPStackTimerTask {
        DialogDeleteTask() {
        }

        protected void runTask() {
            if (SIPDialog.this.isAckSeen()) {
                this.cancel();
            } else {
                SIPDialog.this.delete();
            }
        }
    }

    class DialogTimerTask
    extends SIPStackTimerTask
    implements Serializable {
        int nRetransmissions;
        SIPServerTransaction transaction;

        public DialogTimerTask(SIPServerTransaction transaction) {
            this.transaction = transaction;
            this.nRetransmissions = 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        protected void runTask() {
            SIPDialog dialog;
            block14: {
                SIPResponse response;
                dialog = SIPDialog.this;
                if (SIPDialog.this.sipStack.isLoggingEnabled()) {
                    SIPDialog.this.sipStack.getLogWriter().logDebug("Running dialog timer");
                }
                ++this.nRetransmissions;
                SIPServerTransaction transaction = this.transaction;
                if (this.nRetransmissions > 64) {
                    dialog.setState(3);
                    if (transaction != null) {
                        transaction.raiseErrorEvent(1);
                    }
                } else if (!dialog.ackSeen && transaction != null && (response = transaction.getLastResponse()).getStatusCode() == 200) {
                    try {
                        block13: {
                            try {
                                if (!dialog.toRetransmitFinalResponse(transaction.T2)) break block13;
                                transaction.sendMessage(response);
                            }
                            catch (IOException ex) {
                                SIPDialog.this.raiseIOException(transaction.getPeerAddress(), transaction.getPeerPort(), transaction.getPeerProtocol());
                                Object var6_5 = null;
                                SIPTransactionStack stack = dialog.sipStack;
                                if (stack.logWriter.isLoggingEnabled()) {
                                    stack.logWriter.logDebug("resend 200 response from " + dialog);
                                }
                                transaction.fireTimer();
                                break block14;
                            }
                        }
                        Object var6_4 = null;
                    }
                    catch (Throwable throwable) {
                        Object var6_6 = null;
                        SIPTransactionStack stack = dialog.sipStack;
                        if (stack.logWriter.isLoggingEnabled()) {
                            stack.logWriter.logDebug("resend 200 response from " + dialog);
                        }
                        transaction.fireTimer();
                        throw throwable;
                    }
                    SIPTransactionStack stack = dialog.sipStack;
                    if (stack.logWriter.isLoggingEnabled()) {
                        stack.logWriter.logDebug("resend 200 response from " + dialog);
                    }
                    transaction.fireTimer();
                }
            }
            if (dialog.isAckSeen() || dialog.dialogState == 3) {
                this.transaction = null;
                this.cancel();
            }
        }
    }

    class LingerTimer
    extends SIPStackTimerTask {
        protected void runTask() {
            SIPDialog dialog = SIPDialog.this;
            SIPDialog.this.sipStack.removeDialog(dialog);
        }
    }
}

