/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.javax.sip.clientauthutils;

import gov.nist.javax.sip.SipStackImpl;
import gov.nist.javax.sip.clientauthutils.AccountManager;
import gov.nist.javax.sip.clientauthutils.AuthenticationHelper;
import gov.nist.javax.sip.clientauthutils.CredentialsCache;
import gov.nist.javax.sip.clientauthutils.MessageDigestAlgorithm;
import gov.nist.javax.sip.clientauthutils.UserCredentials;
import gov.nist.javax.sip.message.SIPRequest;
import java.text.ParseException;
import java.util.Collection;
import java.util.ListIterator;
import java.util.Timer;
import javax.sip.ClientTransaction;
import javax.sip.InvalidArgumentException;
import javax.sip.SipException;
import javax.sip.SipProvider;
import javax.sip.address.SipURI;
import javax.sip.header.AuthorizationHeader;
import javax.sip.header.CSeqHeader;
import javax.sip.header.Header;
import javax.sip.header.HeaderFactory;
import javax.sip.header.ProxyAuthenticateHeader;
import javax.sip.header.ViaHeader;
import javax.sip.header.WWWAuthenticateHeader;
import javax.sip.message.Request;
import javax.sip.message.Response;

public class AuthenticationHelperImpl
implements AuthenticationHelper {
    private CredentialsCache cachedCredentials;
    private AccountManager accountManager = null;
    private HeaderFactory headerFactory;
    private SipStackImpl sipStack;
    Timer timer;

    public AuthenticationHelperImpl(SipStackImpl sipStack, AccountManager accountManager, HeaderFactory headerFactory) {
        this.accountManager = accountManager;
        this.headerFactory = headerFactory;
        this.sipStack = sipStack;
        this.cachedCredentials = new CredentialsCache(sipStack.getTimer());
    }

    public ClientTransaction handleChallenge(Response challenge, ClientTransaction challengedTransaction, SipProvider transactionCreator, int cacheTime) throws SipException, NullPointerException {
        try {
            if (this.sipStack.isLoggingEnabled()) {
                this.sipStack.getLogWriter().logDebug("handleChallenge: " + challenge);
            }
            SIPRequest challengedRequest = (SIPRequest)challengedTransaction.getRequest();
            String callId = challengedRequest.getCallId().getCallId();
            Request reoriginatedRequest = (Request)challengedRequest.clone();
            this.removeBranchID(reoriginatedRequest);
            if (challenge == null || reoriginatedRequest == null) {
                throw new NullPointerException("A null argument was passed to handle challenge.");
            }
            ListIterator authHeaders = null;
            if (challenge.getStatusCode() == 401) {
                authHeaders = challenge.getHeaders("WWW-Authenticate");
            } else if (challenge.getStatusCode() == 407) {
                authHeaders = challenge.getHeaders("Proxy-Authenticate");
            } else {
                throw new IllegalArgumentException("Unexpected status code ");
            }
            if (authHeaders == null) {
                throw new IllegalArgumentException("Could not find WWWAuthenticate or ProxyAuthenticate headers");
            }
            reoriginatedRequest.removeHeader("Authorization");
            reoriginatedRequest.removeHeader("Proxy-Authorization");
            CSeqHeader cSeq = (CSeqHeader)reoriginatedRequest.getHeader("CSeq");
            try {
                cSeq.setSeqNumber(cSeq.getSeqNumber() + 1L);
            }
            catch (InvalidArgumentException ex) {
                throw new SipException("Invalid CSeq -- could not increment : " + cSeq.getSeqNumber());
            }
            ClientTransaction retryTran = transactionCreator.getNewClientTransaction(reoriginatedRequest);
            WWWAuthenticateHeader authHeader = null;
            SipURI requestUri = (SipURI)challengedTransaction.getRequest().getRequestURI();
            while (authHeaders.hasNext()) {
                authHeader = (WWWAuthenticateHeader)authHeaders.next();
                String realm = authHeader.getRealm();
                UserCredentials userCreds = this.accountManager.getCredentials(challengedTransaction, realm);
                if (userCreds == null) {
                    throw new SipException("Cannot find user creds for the given user name and realm");
                }
                AuthorizationHeader authorization = this.getAuthorization(reoriginatedRequest.getMethod(), reoriginatedRequest.getRequestURI().toString(), reoriginatedRequest.getContent() == null ? "" : new String(reoriginatedRequest.getRawContent()), authHeader, userCreds);
                this.sipStack.getLogWriter().logDebug("Created authorization header: " + authorization.toString());
                if (cacheTime != 0) {
                    this.cachedCredentials.cacheAuthorizationHeader(userCreds.getSipDomain(), authorization, cacheTime);
                }
                reoriginatedRequest.addHeader((Header)authorization);
            }
            if (this.sipStack.isLoggingEnabled()) {
                this.sipStack.getLogWriter().logDebug("Returning authorization transaction." + retryTran);
            }
            return retryTran;
        }
        catch (SipException ex) {
            throw ex;
        }
        catch (Exception ex) {
            this.sipStack.getLogWriter().logError("Unexpected exception ", ex);
            throw new SipException("Unexpected exception ", (Throwable)ex);
        }
    }

    private AuthorizationHeader getAuthorization(String method, String uri, String requestBody, WWWAuthenticateHeader authHeader, UserCredentials userCredentials) {
        String response = null;
        String qopList = authHeader.getQop();
        String qop = qopList != null ? "auth" : null;
        String nc_value = "00000001";
        String cnonce = "xyz";
        response = MessageDigestAlgorithm.calculateResponse(authHeader.getAlgorithm(), userCredentials.getUserName(), authHeader.getRealm(), userCredentials.getPassword(), authHeader.getNonce(), nc_value, cnonce, method, uri, requestBody, qop);
        Object authorization = null;
        try {
            authorization = authHeader instanceof ProxyAuthenticateHeader ? this.headerFactory.createProxyAuthorizationHeader(authHeader.getScheme()) : this.headerFactory.createAuthorizationHeader(authHeader.getScheme());
            authorization.setUsername(userCredentials.getUserName());
            authorization.setRealm(authHeader.getRealm());
            authorization.setNonce(authHeader.getNonce());
            authorization.setParameter("uri", uri);
            authorization.setResponse(response);
            if (authHeader.getAlgorithm() != null) {
                authorization.setAlgorithm(authHeader.getAlgorithm());
            }
            if (authHeader.getOpaque() != null) {
                authorization.setOpaque(authHeader.getOpaque());
            }
            if (qop != null) {
                authorization.setQop(qop);
                authorization.setCNonce(cnonce);
                authorization.setNonceCount(Integer.parseInt(nc_value));
            }
            authorization.setResponse(response);
        }
        catch (ParseException ex) {
            throw new RuntimeException("Failed to create an authorization header!");
        }
        return authorization;
    }

    private void removeBranchID(Request request) {
        ViaHeader viaHeader = (ViaHeader)request.getHeader("Via");
        viaHeader.removeParameter("branch");
    }

    public void setAuthenticationHeaders(Request request) {
        SIPRequest sipRequest = (SIPRequest)request;
        String callId = sipRequest.getCallId().getCallId();
        request.removeHeader("Authorization");
        Collection<AuthorizationHeader> authHeaders = this.cachedCredentials.getCachedAuthorizationHeaders(callId);
        if (authHeaders == null) {
            this.sipStack.getLogWriter().logDebug("Could not find authentication headers for " + callId);
            return;
        }
        for (AuthorizationHeader authHeader : authHeaders) {
            request.addHeader((Header)authHeader);
        }
    }

    public void removeCachedAuthenticationHeaders(String callId) {
        if (callId == null) {
            throw new NullPointerException("Null callId argument ");
        }
        this.cachedCredentials.removeAuthenticationHeader(callId);
    }
}

