/*
 * Decompiled with CFR 0.152.
 */
package javax.time.calendar;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.time.CalendricalException;
import javax.time.calendar.CalendarConversionException;
import javax.time.calendar.CalendricalContext;
import javax.time.calendar.CalendricalProvider;
import javax.time.calendar.DateTimeFieldRule;
import javax.time.calendar.DateTimeFields;
import javax.time.calendar.ISOChronology;
import javax.time.calendar.InvalidCalendarFieldException;
import javax.time.calendar.LocalDate;
import javax.time.calendar.LocalDateTime;
import javax.time.calendar.LocalTime;
import javax.time.calendar.OffsetDate;
import javax.time.calendar.OffsetDateTime;
import javax.time.calendar.OffsetTime;
import javax.time.calendar.TimeZone;
import javax.time.calendar.UnsupportedCalendarFieldException;
import javax.time.calendar.ZoneOffset;
import javax.time.calendar.ZonedDateTime;

public final class Calendrical
implements CalendricalProvider,
Cloneable,
Serializable {
    private static final long serialVersionUID = 273575873876986L;
    private FieldMap fieldMap;
    private LocalDate date;
    private LocalTime time;
    private ZoneOffset offset;
    private TimeZone zone;

    public Calendrical() {
        this.fieldMap = new FieldMap();
    }

    public Calendrical(DateTimeFieldRule dateTimeFieldRule, int n) {
        this();
        this.fieldMap.put(dateTimeFieldRule, n);
    }

    public Calendrical(DateTimeFieldRule dateTimeFieldRule, int n, DateTimeFieldRule dateTimeFieldRule2, int n2) {
        this();
        this.fieldMap.put(dateTimeFieldRule, n);
        this.fieldMap.put(dateTimeFieldRule2, n2);
    }

    public Calendrical(LocalDate localDate, LocalTime localTime, ZoneOffset zoneOffset, TimeZone timeZone) {
        this();
        this.date = localDate;
        this.time = localTime;
        this.offset = zoneOffset;
        this.zone = timeZone;
    }

    public Calendrical(DateTimeFields dateTimeFields) {
        this.fieldMap = new FieldMap(dateTimeFields);
    }

    public FieldMap getFieldMap() {
        return this.fieldMap;
    }

    public LocalDate getDate() {
        return this.date;
    }

    public void setDate(LocalDate localDate) {
        this.date = localDate;
    }

    public LocalTime getTime() {
        return this.time;
    }

    public void setTime(LocalTime localTime) {
        this.time = localTime;
    }

    public ZoneOffset getOffset() {
        return this.offset;
    }

    public void setOffset(ZoneOffset zoneOffset) {
        this.offset = zoneOffset;
    }

    public TimeZone getZone() {
        return this.zone;
    }

    public void setZone(TimeZone timeZone) {
        this.zone = timeZone;
    }

    public boolean isDerivable(DateTimeFieldRule dateTimeFieldRule) {
        return this.deriveValueQuiet(dateTimeFieldRule) != null;
    }

    public int deriveValue(DateTimeFieldRule dateTimeFieldRule) {
        ISOChronology.checkNotNull(dateTimeFieldRule, "DateTimeFieldRule must not be null");
        Integer n = this.deriveValueQuiet(dateTimeFieldRule);
        if (n == null) {
            throw new UnsupportedCalendarFieldException(dateTimeFieldRule, "Calendrical");
        }
        return n;
    }

    public Integer deriveValueQuiet(DateTimeFieldRule dateTimeFieldRule) {
        if (dateTimeFieldRule == null) {
            return null;
        }
        Integer n = dateTimeFieldRule.getValueQuiet(this.date, this.time);
        return n == null ? this.fieldMap.deriveValueQuiet(dateTimeFieldRule) : n;
    }

    public void checkConsistent() {
        if (this.date != null || this.time != null) {
            CalendricalProvider calendricalProvider = null;
            String string = null;
            if (this.date != null & this.time != null) {
                calendricalProvider = LocalDateTime.dateTime(this.date, this.time);
                string = "date-time ";
            } else if (this.date != null) {
                calendricalProvider = this.date;
                string = "date ";
            } else {
                calendricalProvider = this.time;
                string = "time ";
            }
            for (Map.Entry entry : this.fieldMap.fieldValueMap.entrySet()) {
                Integer n;
                DateTimeFieldRule dateTimeFieldRule = (DateTimeFieldRule)entry.getKey();
                Integer n2 = dateTimeFieldRule.getValueQuiet(this.date, this.time);
                if (n2 == null || n2.equals(n = (Integer)entry.getValue())) continue;
                throw new InvalidCalendarFieldException("Calendrical contains field map value " + dateTimeFieldRule.getID() + "=" + n + " that is inconsistent with " + string + calendricalProvider, dateTimeFieldRule);
            }
        }
        this.fieldMap.checkConsistent();
    }

    public void removeDerivable() {
        if (this.date != null || this.time != null) {
            Iterator iterator = this.fieldMap.fieldValueMap.keySet().iterator();
            while (iterator.hasNext()) {
                Integer n = ((DateTimeFieldRule)iterator.next()).getValueQuiet(this.date, this.time);
                if (n == null) continue;
                iterator.remove();
            }
        }
        this.fieldMap.removeDerivable();
    }

    public Calendrical mergeStrict() {
        return this.merge(new CalendricalContext(true, true));
    }

    public Calendrical mergeLenient() {
        return this.merge(new CalendricalContext(false, true));
    }

    public Calendrical merge(CalendricalContext calendricalContext) {
        ISOChronology.checkNotNull(calendricalContext, "CalendricalContext must not be null");
        if (this.fieldMap.size() > 0) {
            Merger merger = new Merger(this, calendricalContext);
            merger.merge();
        }
        return this;
    }

    public LocalDate toLocalDate() {
        if (this.date == null) {
            throw new CalendarConversionException("Cannot convert Calendrical to LocalDate, insufficient infomation to create a date");
        }
        return this.date;
    }

    public LocalTime toLocalTime() {
        if (this.time == null) {
            throw new CalendarConversionException("Cannot convert Calendrical to LocalTime, insufficient infomation to create a time");
        }
        return this.time;
    }

    public LocalDateTime toLocalDateTime() {
        if (this.date == null || this.time == null) {
            throw new CalendarConversionException("Cannot convert Calendrical to LocalTime, insufficient infomation available");
        }
        return LocalDateTime.dateTime(this.date, this.time);
    }

    public OffsetDate toOffsetDate() {
        if (this.offset == null) {
            throw new CalendarConversionException("Cannot convert Calendrical to OffsetDate because the offset is null");
        }
        return OffsetDate.date(this.toLocalDate(), this.offset);
    }

    public OffsetTime toOffsetTime() {
        if (this.offset == null) {
            throw new CalendarConversionException("Cannot convert Calendrical to OffsetTime because the offset is null");
        }
        return OffsetTime.time(this.toLocalTime(), this.offset);
    }

    public OffsetDateTime toOffsetDateTime() {
        if (this.offset == null) {
            throw new CalendarConversionException("Cannot convert Calendrical to OffsetDateTime because the offset is null");
        }
        return OffsetDateTime.dateTime(this.toLocalDateTime(), this.offset);
    }

    public ZonedDateTime toZonedDateTime() {
        OffsetDateTime offsetDateTime = this.toOffsetDateTime();
        if (this.zone == null) {
            throw new CalendarConversionException("Cannot convert Calendrical to ZonedDateTime because the zone is null");
        }
        return ZonedDateTime.dateTime(offsetDateTime, this.zone);
    }

    @Override
    public Calendrical toCalendrical() {
        return this.clone();
    }

    public Calendrical clone() {
        Calendrical calendrical = new Calendrical(this.date, this.time, this.offset, this.zone);
        calendrical.getFieldMap().putAll(this.fieldMap.fieldValueMap);
        return calendrical;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Calendrical)) {
            return false;
        }
        Calendrical calendrical = (Calendrical)object;
        if (!(this.date == calendrical.date || this.date != null && this.date.equals(calendrical.date))) {
            return false;
        }
        if (!(this.time == calendrical.time || this.time != null && this.time.equals(calendrical.time))) {
            return false;
        }
        if (!(this.offset == calendrical.offset || this.offset != null && this.offset.equals(calendrical.offset))) {
            return false;
        }
        if (!(this.zone == calendrical.zone || this.zone != null && this.zone.equals(calendrical.zone))) {
            return false;
        }
        return this.fieldMap.equals(calendrical.fieldMap);
    }

    public int hashCode() {
        int n = 7;
        n = 59 * n + (this.date != null ? this.date.hashCode() : 0);
        n = 59 * n + (this.time != null ? this.time.hashCode() : 0);
        n = 59 * n + (this.offset != null ? this.offset.hashCode() : 0);
        n = 59 * n + (this.zone != null ? this.zone.hashCode() : 0);
        n = 59 * n + this.fieldMap.hashCode();
        return n;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.fieldMap.size() > 0) {
            stringBuilder.append(this.fieldMap).append(' ');
        }
        if (this.date != null) {
            stringBuilder.append(this.date).append(' ');
        }
        if (this.time != null) {
            stringBuilder.append(this.time).append(' ');
        }
        if (this.offset != null) {
            stringBuilder.append(this.offset).append(' ');
        }
        if (this.zone != null) {
            stringBuilder.append(this.zone).append(' ');
        }
        if (stringBuilder.length() > 0) {
            stringBuilder.setLength(stringBuilder.length() - 1);
        }
        return stringBuilder.toString();
    }

    public static final class Merger {
        private final Calendrical calendrical;
        private final CalendricalContext context;
        private LocalTime.Overflow mergedTime;
        private final Set<DateTimeFieldRule> processedFieldSet = new HashSet<DateTimeFieldRule>();
        private Iterator<DateTimeFieldRule> iterator;

        private Merger(Calendrical calendrical, CalendricalContext calendricalContext) {
            this.calendrical = calendrical;
            this.context = calendricalContext;
        }

        public CalendricalContext getContext() {
            return this.context;
        }

        public boolean isStrict() {
            return this.context.isStrict();
        }

        public int getValue(DateTimeFieldRule dateTimeFieldRule) {
            return this.calendrical.getFieldMap().get(dateTimeFieldRule);
        }

        public Integer getValueQuiet(DateTimeFieldRule dateTimeFieldRule) {
            return this.calendrical.getFieldMap().getQuiet(dateTimeFieldRule);
        }

        public void markFieldAsProcessed(DateTimeFieldRule dateTimeFieldRule) {
            ISOChronology.checkNotNull(dateTimeFieldRule, "Field rule must not be null");
            this.processedFieldSet.add(dateTimeFieldRule);
        }

        public void storeMergedDate(LocalDate localDate) {
            ISOChronology.checkNotNull(localDate, "Date must not be null");
            LocalDate localDate2 = this.calendrical.getDate();
            if (localDate2 != null && !localDate2.equals(localDate)) {
                throw new CalendricalException("Merge resulted in two different dates, " + localDate2 + " and " + localDate);
            }
            this.calendrical.setDate(localDate);
        }

        public void storeMergedTime(LocalTime localTime) {
            ISOChronology.checkNotNull(localTime, "Time must not be null");
            LocalTime localTime2 = this.calendrical.getTime();
            if (localTime2 != null && !localTime2.equals(localTime)) {
                throw new CalendricalException("Merge resulted in two different times, " + localTime2 + " and " + localTime);
            }
            this.calendrical.setTime(localTime);
        }

        public void storeMergedTime(LocalTime.Overflow overflow) {
            ISOChronology.checkNotNull(overflow, "Time must not be null");
            if (this.mergedTime != null && !this.mergedTime.equals(overflow)) {
                throw new CalendricalException("Merge resulted in two different times, " + this.mergedTime + " and " + overflow);
            }
            this.storeMergedTime(overflow.getResultTime());
            this.mergedTime = overflow;
        }

        public void storeMergedField(DateTimeFieldRule dateTimeFieldRule, int n) {
            ISOChronology.checkNotNull(dateTimeFieldRule, "Field rule must not be null");
            Integer n2 = this.calendrical.getFieldMap().getQuiet(dateTimeFieldRule);
            if (n2 != null) {
                if (n2 != n) {
                    throw new InvalidCalendarFieldException("Merge resulted in two different values, " + n + " and " + n2 + ", for " + dateTimeFieldRule.getID() + " within fields " + this.calendrical.getFieldMap(), dateTimeFieldRule);
                }
                return;
            }
            this.calendrical.getFieldMap().put(dateTimeFieldRule, n);
            this.iterator = this.calendrical.getFieldMap().iterator();
        }

        void merge() {
            if (this.calendrical.getFieldMap().size() > 0) {
                if (this.isStrict()) {
                    this.calendrical.getFieldMap().validate();
                }
                this.mergeFieldsLoop();
                this.mergeDateTime();
                this.calendrical.getFieldMap().removeAll(this.processedFieldSet);
                if (this.getContext().isCheckUnusedFields()) {
                    this.calendrical.checkConsistent();
                }
                if (this.calendrical.getDate() != null && this.mergedTime != null && this.mergedTime.getOverflowDays() > 0) {
                    this.calendrical.setDate(this.calendrical.getDate().plusDays(this.mergedTime.getOverflowDays()));
                }
                this.calendrical.removeDerivable();
            }
        }

        private void mergeFieldsLoop() {
            this.iterator = this.calendrical.getFieldMap().iterator();
            for (int i = 0; this.iterator.hasNext() && i < 100; ++i) {
                this.iterator.next().mergeFields(this);
            }
            if (this.iterator.hasNext()) {
                throw new CalendricalException("Merge fields failed, infinite loop blocked, probably caused by an incorrectly implemented field rule");
            }
        }

        private void mergeDateTime() {
            this.iterator = this.calendrical.getFieldMap().iterator();
            while (this.iterator.hasNext()) {
                this.iterator.next().mergeDateTime(this);
            }
        }
    }

    public static final class FieldMap
    implements Iterable<DateTimeFieldRule>,
    Serializable {
        private static final long serialVersionUID = 1L;
        private final Map<DateTimeFieldRule, Integer> fieldValueMap = new TreeMap(Collections.reverseOrder());

        private FieldMap() {
        }

        private FieldMap(DateTimeFields dateTimeFields) {
            dateTimeFields.copyInto(this.fieldValueMap);
        }

        public int size() {
            return this.fieldValueMap.size();
        }

        @Override
        public Iterator<DateTimeFieldRule> iterator() {
            return this.fieldValueMap.keySet().iterator();
        }

        public boolean contains(DateTimeFieldRule dateTimeFieldRule) {
            return dateTimeFieldRule != null && this.fieldValueMap.containsKey(dateTimeFieldRule);
        }

        public boolean containsValid(DateTimeFieldRule dateTimeFieldRule) {
            if (dateTimeFieldRule == null) {
                return false;
            }
            Integer n = this.fieldValueMap.get(dateTimeFieldRule);
            return n != null && dateTimeFieldRule.isValidValue(n);
        }

        public int get(DateTimeFieldRule dateTimeFieldRule) {
            ISOChronology.checkNotNull(dateTimeFieldRule, "DateTimeFieldRule must not be null");
            Integer n = this.fieldValueMap.get(dateTimeFieldRule);
            if (n == null) {
                throw new UnsupportedCalendarFieldException(dateTimeFieldRule, "Calendrical");
            }
            return n;
        }

        public int getValidated(DateTimeFieldRule dateTimeFieldRule) {
            int n = this.get(dateTimeFieldRule);
            dateTimeFieldRule.checkValue(n);
            return n;
        }

        public Integer getQuiet(DateTimeFieldRule dateTimeFieldRule) {
            return dateTimeFieldRule == null ? null : this.fieldValueMap.get(dateTimeFieldRule);
        }

        public FieldMap put(DateTimeFieldRule dateTimeFieldRule, int n) {
            ISOChronology.checkNotNull(dateTimeFieldRule, "DateTimeFieldRule must not be null");
            this.fieldValueMap.put(dateTimeFieldRule, n);
            return this;
        }

        public FieldMap putAll(Map<DateTimeFieldRule, Integer> map) {
            ISOChronology.checkNotNull(map, "Field-value map must not be null");
            if (map.size() > 0) {
                for (Map.Entry<DateTimeFieldRule, Integer> entry : map.entrySet()) {
                    DateTimeFieldRule dateTimeFieldRule = entry.getKey();
                    Integer n = entry.getValue();
                    ISOChronology.checkNotNull(dateTimeFieldRule, "Null keys are not permitted in field-value map");
                    ISOChronology.checkNotNull(n, "Null values are not permitted in field-value map");
                }
                this.fieldValueMap.putAll(map);
            }
            return this;
        }

        public FieldMap putAll(DateTimeFields dateTimeFields) {
            ISOChronology.checkNotNull(dateTimeFields, "DateTimeFields must not be null");
            dateTimeFields.copyInto(this.fieldValueMap);
            return this;
        }

        public FieldMap remove(DateTimeFieldRule dateTimeFieldRule) {
            ISOChronology.checkNotNull(dateTimeFieldRule, "DateTimeFieldRule must not be null");
            this.fieldValueMap.remove(dateTimeFieldRule);
            return this;
        }

        public FieldMap removeAll(Iterable<DateTimeFieldRule> iterable) {
            ISOChronology.checkNotNull(iterable, "DateTimeFieldRule iterable must not be null");
            for (DateTimeFieldRule dateTimeFieldRule : iterable) {
                this.remove(dateTimeFieldRule);
            }
            return this;
        }

        public FieldMap clear() {
            this.fieldValueMap.clear();
            return this;
        }

        public boolean isValid() {
            for (Map.Entry<DateTimeFieldRule, Integer> entry : this.fieldValueMap.entrySet()) {
                if (entry.getKey().isValidValue(entry.getValue())) continue;
                return false;
            }
            return true;
        }

        public FieldMap validate() {
            for (Map.Entry<DateTimeFieldRule, Integer> entry : this.fieldValueMap.entrySet()) {
                entry.getKey().checkValue(entry.getValue());
            }
            return this;
        }

        public Integer deriveValueQuiet(DateTimeFieldRule dateTimeFieldRule) {
            return dateTimeFieldRule == null ? null : dateTimeFieldRule.getValueQuiet(this);
        }

        public void checkConsistent() {
            for (Map.Entry<DateTimeFieldRule, Integer> entry : this.fieldValueMap.entrySet()) {
                Integer n;
                DateTimeFieldRule dateTimeFieldRule = entry.getKey();
                Integer n2 = dateTimeFieldRule.deriveValue(this);
                if (n2 == null || n2.equals(n = entry.getValue())) continue;
                throw new InvalidCalendarFieldException("Calendrical contains field map value " + dateTimeFieldRule.getID() + "=" + n + " that is inconsistent with value " + n2 + " derived from another field", dateTimeFieldRule);
            }
        }

        public void removeDerivable() {
            Iterator<DateTimeFieldRule> iterator = this.fieldValueMap.keySet().iterator();
            while (iterator.hasNext()) {
                Integer n = iterator.next().deriveValue(this);
                if (n == null) continue;
                iterator.remove();
            }
        }

        public DateTimeFields toDateTimeFields() {
            return DateTimeFields.fields(this.toFieldValueMap());
        }

        public Map<DateTimeFieldRule, Integer> toFieldValueMap() {
            TreeMap<DateTimeFieldRule, Integer> treeMap = new TreeMap<DateTimeFieldRule, Integer>(Collections.reverseOrder());
            treeMap.putAll(this.fieldValueMap);
            return treeMap;
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (object instanceof FieldMap) {
                FieldMap fieldMap = (FieldMap)object;
                return ((Object)this.fieldValueMap).equals(fieldMap.fieldValueMap);
            }
            return false;
        }

        public int hashCode() {
            return ((Object)this.fieldValueMap).hashCode();
        }

        public String toString() {
            return this.fieldValueMap.toString();
        }
    }
}

