/*
 * Decompiled with CFR 0.152.
 */
package javax.time.calendar;

import java.io.Serializable;
import javax.time.calendar.DateMatcher;
import javax.time.calendar.ISOChronology;
import javax.time.calendar.LocalDate;
import javax.time.calendar.field.DayOfWeek;
import javax.time.calendar.field.MonthOfYear;

public final class DateMatchers {
    private DateMatchers() {
    }

    public static DateMatcher leapYear() {
        return Impl.LEAP_YEAR;
    }

    public static DateMatcher leapDay() {
        return Impl.LEAP_DAY;
    }

    public static DateMatcher lastDayOfMonth() {
        return Impl.LAST_DAY_OF_MONTH;
    }

    public static DateMatcher lastDayOfYear() {
        return Impl.LAST_DAY_OF_YEAR;
    }

    public static DateMatcher weekendDay() {
        return Impl.WEEKEND_DAY;
    }

    public static DateMatcher nonWeekendDay() {
        return Impl.NON_WEEKEND_DAY;
    }

    public static DateMatcher firstInMonth(DayOfWeek dayOfWeek) {
        if (dayOfWeek == null) {
            throw new NullPointerException("DayOfWeek must not be null");
        }
        return new DayOfWeekInMonth(1, dayOfWeek);
    }

    public static DateMatcher dayOfWeekInMonth(int n, DayOfWeek dayOfWeek) {
        if (n < 1 || n > 5) {
            throw new IllegalArgumentException("Illegal value for ordinal, value " + n + " is not in the range 1 to 5");
        }
        if (dayOfWeek == null) {
            throw new NullPointerException("DayOfWeek must not be null");
        }
        return new DayOfWeekInMonth(n, dayOfWeek);
    }

    private static final class DayOfWeekInMonth
    implements DateMatcher,
    Serializable {
        private static final long serialVersionUID = 1L;
        private final int ordinal;
        private final DayOfWeek dayOfWeek;

        private DayOfWeekInMonth(int n, DayOfWeek dayOfWeek) {
            this.ordinal = n;
            this.dayOfWeek = dayOfWeek;
        }

        @Override
        public boolean matchesDate(LocalDate localDate) {
            if (localDate.getDayOfWeek() != this.dayOfWeek) {
                return false;
            }
            return (localDate.getDayOfMonth() - 1) / 7 == this.ordinal - 1;
        }

        public boolean equals(Object object) {
            if (object instanceof DayOfWeekInMonth) {
                DayOfWeekInMonth dayOfWeekInMonth = (DayOfWeekInMonth)object;
                return this.ordinal == dayOfWeekInMonth.ordinal && this.dayOfWeek == dayOfWeekInMonth.dayOfWeek;
            }
            return false;
        }

        public int hashCode() {
            return this.ordinal + 8 * this.dayOfWeek.ordinal();
        }
    }

    private static enum Impl implements DateMatcher
    {
        LEAP_YEAR{

            @Override
            public boolean matchesDate(LocalDate localDate) {
                return ISOChronology.isLeapYear(localDate.getYear());
            }
        }
        ,
        LEAP_DAY{

            @Override
            public boolean matchesDate(LocalDate localDate) {
                return localDate.getDayOfMonth() == 29 && localDate.getMonthOfYear() == MonthOfYear.FEBRUARY;
            }
        }
        ,
        LAST_DAY_OF_MONTH{

            @Override
            public boolean matchesDate(LocalDate localDate) {
                return localDate.getDayOfMonth() == localDate.getMonthOfYear().lengthInDays(localDate.getYear());
            }
        }
        ,
        LAST_DAY_OF_YEAR{

            @Override
            public boolean matchesDate(LocalDate localDate) {
                return localDate.getMonthOfYear() == MonthOfYear.DECEMBER && localDate.getDayOfMonth() == 31;
            }
        }
        ,
        WEEKEND_DAY{

            @Override
            public boolean matchesDate(LocalDate localDate) {
                return localDate.getDayOfWeek().getValue() >= 6;
            }
        }
        ,
        NON_WEEKEND_DAY{

            @Override
            public boolean matchesDate(LocalDate localDate) {
                return localDate.getDayOfWeek().getValue() < 6;
            }
        };

    }
}

