/*
 * Decompiled with CFR 0.152.
 */
package javax.time.calendar;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import javax.time.calendar.Calendrical;
import javax.time.calendar.CalendricalProvider;
import javax.time.calendar.Chronology;
import javax.time.calendar.IllegalCalendarFieldValueException;
import javax.time.calendar.LocalDate;
import javax.time.calendar.LocalTime;
import javax.time.calendar.UnsupportedCalendarFieldException;
import javax.time.period.PeriodUnit;

public abstract class DateTimeFieldRule
implements Comparable<DateTimeFieldRule>,
Serializable {
    private static final MathContext FRACTION_CONTEXT = new MathContext(9, RoundingMode.FLOOR);
    private static final MathContext VALUE_CONTEXT = new MathContext(0, RoundingMode.FLOOR);
    private final Chronology chronology;
    private final String id;
    private final String name;
    private final PeriodUnit periodUnit;
    private final PeriodUnit periodRange;
    private final int minimumValue;
    private final int maximumValue;

    protected DateTimeFieldRule(Chronology chronology, String string, PeriodUnit periodUnit, PeriodUnit periodUnit2, int n, int n2) {
        if (chronology == null) {
            throw new NullPointerException("The chronology must not be null");
        }
        if (string == null) {
            throw new NullPointerException("The name must not be null");
        }
        this.chronology = chronology;
        this.id = chronology.getName() + '.' + string;
        this.name = string;
        this.periodUnit = periodUnit;
        this.periodRange = periodUnit2;
        this.minimumValue = n;
        this.maximumValue = n2;
    }

    public final String getID() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public PeriodUnit getPeriodUnit() {
        return this.periodUnit;
    }

    public PeriodUnit getPeriodRange() {
        return this.periodRange;
    }

    public final boolean isSupported(LocalDate localDate, LocalTime localTime) {
        return this.getValueQuiet(localDate, localTime) != null;
    }

    public int getValue(CalendricalProvider calendricalProvider) {
        int n = calendricalProvider.toCalendrical().deriveValue(this);
        this.checkValue(n);
        return n;
    }

    public final int getValue(LocalDate localDate, LocalTime localTime) {
        Integer n = this.getValueQuiet(localDate, localTime);
        if (n == null) {
            throw new UnsupportedCalendarFieldException(this);
        }
        return n;
    }

    public Integer getValueQuiet(LocalDate localDate, LocalTime localTime) {
        return null;
    }

    public final Integer getValueQuiet(Calendrical.FieldMap fieldMap) {
        Integer n = fieldMap.getQuiet(this);
        return n == null ? this.deriveValue(fieldMap) : n;
    }

    protected Integer deriveValue(Calendrical.FieldMap fieldMap) {
        return null;
    }

    protected void mergeFields(Calendrical.Merger merger) {
    }

    protected void mergeDateTime(Calendrical.Merger merger) {
    }

    public boolean isValidValue(int n) {
        return n >= this.getMinimumValue() && n <= this.getMaximumValue();
    }

    public boolean isValidValue(long l) {
        return l >= (long)this.getMinimumValue() && l <= (long)this.getMaximumValue();
    }

    public void checkValue(int n) {
        if (!this.isValidValue(n)) {
            throw new IllegalCalendarFieldValueException(this, n, this.getMinimumValue(), this.getMaximumValue());
        }
    }

    public int checkValue(long l) {
        if (!this.isValidValue(l)) {
            throw new IllegalCalendarFieldValueException(this, l, this.getMinimumValue(), this.getMaximumValue());
        }
        return (int)l;
    }

    public boolean isFixedValueSet() {
        return this.getMaximumValue() == this.getSmallestMaximumValue() && this.getMinimumValue() == this.getLargestMinimumValue();
    }

    public int getMinimumValue() {
        return this.minimumValue;
    }

    public int getLargestMinimumValue() {
        return this.getMinimumValue();
    }

    public int getMinimumValue(Calendrical calendrical) {
        return this.getMinimumValue();
    }

    public int getMaximumValue() {
        return this.maximumValue;
    }

    public int getSmallestMaximumValue() {
        return this.getMaximumValue();
    }

    public int getMaximumValue(Calendrical calendrical) {
        return this.getMaximumValue();
    }

    public BigDecimal convertValueToFraction(int n) {
        if (!this.isFixedValueSet()) {
            throw new UnsupportedCalendarFieldException(this, "The fractional value of " + this.getName() + " cannot be obtained as the range is not fixed");
        }
        if (this.getMinimumValue() != 0) {
            throw new UnsupportedCalendarFieldException(this, "The fractional value of " + this.getName() + " cannot be obtained as the minimum field value is not zero");
        }
        this.checkValue(n);
        long l = this.getMaximumValue();
        BigDecimal bigDecimal = new BigDecimal(n);
        return bigDecimal.divide(new BigDecimal(++l), FRACTION_CONTEXT);
    }

    public int convertFractionToValue(BigDecimal bigDecimal) {
        if (!this.isFixedValueSet()) {
            throw new UnsupportedCalendarFieldException(this, "The fractional value of " + this.getName() + " cannot be converted as the range is not fixed");
        }
        if (this.getMinimumValue() != 0) {
            throw new UnsupportedCalendarFieldException(this, "The fractional value of " + this.getName() + " cannot be converted as the minimum field value is not zero");
        }
        long l = this.getMaximumValue();
        BigDecimal bigDecimal2 = bigDecimal.multiply(new BigDecimal(++l), VALUE_CONTEXT);
        try {
            int n = bigDecimal2.intValueExact();
            this.checkValue(n);
            return n;
        }
        catch (ArithmeticException arithmeticException) {
            throw new IllegalCalendarFieldValueException("The fractional value " + bigDecimal + " of " + this.getName() + " cannot be converted as it is not in the range 0 (inclusive) to 1 (exclusive)", this);
        }
    }

    @Override
    public int compareTo(DateTimeFieldRule dateTimeFieldRule) {
        int n = this.getPeriodUnit().compareTo(dateTimeFieldRule.getPeriodUnit());
        if (n != 0) {
            return n;
        }
        if (this.getPeriodRange() == dateTimeFieldRule.getPeriodRange()) {
            return this.chronology.getName().compareTo(dateTimeFieldRule.chronology.getName());
        }
        if (this.getPeriodRange() == null) {
            return 1;
        }
        if (dateTimeFieldRule.getPeriodRange() == null) {
            return -1;
        }
        n = this.getPeriodRange().compareTo(dateTimeFieldRule.getPeriodRange());
        if (n != 0) {
            return n;
        }
        return this.chronology.getName().compareTo(dateTimeFieldRule.chronology.getName());
    }

    public String toString() {
        return this.getID();
    }
}

