/*
 * Decompiled with CFR 0.152.
 */
package javax.time.calendar;

import java.util.HashMap;
import java.util.Map;
import javax.time.calendar.CalendarConversionException;
import javax.time.calendar.Calendrical;
import javax.time.calendar.DateTimeFieldRule;
import javax.time.calendar.InvalidCalendarFieldException;
import javax.time.calendar.LocalDate;
import javax.time.calendar.LocalDateTime;
import javax.time.calendar.LocalTime;
import javax.time.calendar.OffsetDate;
import javax.time.calendar.OffsetDateTime;
import javax.time.calendar.OffsetTime;
import javax.time.calendar.TimeZone;
import javax.time.calendar.UnsupportedCalendarFieldException;
import javax.time.calendar.ZoneOffset;
import javax.time.calendar.ZonedDateTime;

public final class FlexiDateTime
implements Calendrical {
    private final Map<DateTimeFieldRule, Integer> fieldValueMap = new HashMap<DateTimeFieldRule, Integer>();
    private final LocalDate date;
    private final LocalTime time;
    private final ZoneOffset offset;
    private final TimeZone zone;

    public FlexiDateTime(LocalDate localDate, LocalTime localTime, ZoneOffset zoneOffset, TimeZone timeZone) {
        this(null, localDate, localTime, zoneOffset, timeZone);
    }

    public FlexiDateTime(DateTimeFieldRule dateTimeFieldRule, int n) {
        if (dateTimeFieldRule == null) {
            throw new NullPointerException("The rule must not be null");
        }
        this.fieldValueMap.put(dateTimeFieldRule, n);
        this.date = null;
        this.time = null;
        this.offset = null;
        this.zone = null;
    }

    public FlexiDateTime(DateTimeFieldRule dateTimeFieldRule, int n, DateTimeFieldRule dateTimeFieldRule2, int n2) {
        if (dateTimeFieldRule == null || dateTimeFieldRule2 == null) {
            throw new NullPointerException("The rules must not be null");
        }
        this.fieldValueMap.put(dateTimeFieldRule, n);
        this.fieldValueMap.put(dateTimeFieldRule2, n2);
        this.date = null;
        this.time = null;
        this.offset = null;
        this.zone = null;
    }

    public FlexiDateTime(Map<DateTimeFieldRule, Integer> map, LocalDate localDate, LocalTime localTime, ZoneOffset zoneOffset, TimeZone timeZone) {
        if (map != null) {
            if (map.containsKey(null)) {
                throw new NullPointerException("Null keys are not permitted in field-value map");
            }
            if (map.containsValue(null)) {
                throw new NullPointerException("Null values are not permitted in field-value map");
            }
            this.fieldValueMap.putAll(map);
        }
        this.date = localDate;
        this.time = localTime;
        this.offset = zoneOffset;
        this.zone = timeZone;
    }

    public int getValue(DateTimeFieldRule dateTimeFieldRule) {
        if (dateTimeFieldRule == null) {
            throw new NullPointerException("The rule must not be null");
        }
        Integer n = dateTimeFieldRule.extractValue(this);
        Integer n2 = this.fieldValueMap.get(dateTimeFieldRule);
        if (n2 == null && n == null) {
            throw new UnsupportedCalendarFieldException(dateTimeFieldRule);
        }
        if (n != null) {
            if (n2 != null && !n2.equals(n)) {
                throw new InvalidCalendarFieldException("Field " + dateTimeFieldRule.getName() + " has two different values " + n + " and " + n2, dateTimeFieldRule);
            }
            return n;
        }
        dateTimeFieldRule.checkValue(n2);
        return n2;
    }

    public int getRawValue(DateTimeFieldRule dateTimeFieldRule) {
        if (dateTimeFieldRule == null) {
            throw new NullPointerException("The rule must not be null");
        }
        Integer n = this.fieldValueMap.get(dateTimeFieldRule);
        if (n != null) {
            return n;
        }
        Integer n2 = dateTimeFieldRule.extractValue(this);
        if (n2 != null) {
            return n2;
        }
        throw new UnsupportedCalendarFieldException(dateTimeFieldRule, "FlexiDateTime");
    }

    public Map<DateTimeFieldRule, Integer> getFieldValueMap() {
        return new HashMap<DateTimeFieldRule, Integer>(this.fieldValueMap);
    }

    public int getFieldValueMapValue(DateTimeFieldRule dateTimeFieldRule) {
        if (dateTimeFieldRule == null) {
            throw new NullPointerException("The rule must not be null");
        }
        Integer n = this.fieldValueMap.get(dateTimeFieldRule);
        if (n != null) {
            return n;
        }
        throw new UnsupportedCalendarFieldException(dateTimeFieldRule, "FlexiDateTime");
    }

    @Override
    public LocalDate getDate() {
        return this.date;
    }

    @Override
    public LocalTime getTime() {
        return this.time;
    }

    @Override
    public ZoneOffset getOffset() {
        return this.offset;
    }

    @Override
    public TimeZone getZone() {
        return this.zone;
    }

    public FlexiDateTime withFieldValueMap(Map<DateTimeFieldRule, Integer> map) {
        return new FlexiDateTime(map, this.date, this.time, this.offset, this.zone);
    }

    public FlexiDateTime withFieldValue(DateTimeFieldRule dateTimeFieldRule, int n) {
        if (dateTimeFieldRule == null) {
            throw new NullPointerException("The field rule must not be null");
        }
        Map<DateTimeFieldRule, Integer> map = this.getFieldValueMap();
        map.put(dateTimeFieldRule, n);
        return new FlexiDateTime(map, this.date, this.time, this.offset, this.zone);
    }

    public FlexiDateTime withDate(LocalDate localDate) {
        return new FlexiDateTime(this.fieldValueMap, localDate, this.time, this.offset, this.zone);
    }

    public FlexiDateTime withTime(LocalTime localTime) {
        return new FlexiDateTime(this.fieldValueMap, this.date, localTime, this.offset, this.zone);
    }

    public FlexiDateTime withOffset(ZoneOffset zoneOffset) {
        return new FlexiDateTime(this.fieldValueMap, this.date, this.time, zoneOffset, this.zone);
    }

    public FlexiDateTime withZone(TimeZone timeZone) {
        return new FlexiDateTime(this.fieldValueMap, this.date, this.time, this.offset, timeZone);
    }

    public FlexiDateTime mergeFields() {
        return this.mergeDateFields().mergeTimeFields();
    }

    public FlexiDateTime mergeDateFields() {
        if (this.date == null) {
            for (Map.Entry<DateTimeFieldRule, Integer> entry : this.fieldValueMap.entrySet()) {
                FlexiDateTime flexiDateTime;
                DateTimeFieldRule dateTimeFieldRule = entry.getKey();
                if (!dateTimeFieldRule.isDateField() || (flexiDateTime = dateTimeFieldRule.mergeFields(this)) == this) continue;
                return flexiDateTime.mergeDateFields();
            }
        }
        return this;
    }

    public FlexiDateTime mergeTimeFields() {
        if (this.time == null) {
            for (Map.Entry<DateTimeFieldRule, Integer> entry : this.fieldValueMap.entrySet()) {
                FlexiDateTime flexiDateTime;
                DateTimeFieldRule dateTimeFieldRule = entry.getKey();
                if (!dateTimeFieldRule.isTimeField() || (flexiDateTime = dateTimeFieldRule.mergeFields(this)) == this) continue;
                return flexiDateTime.mergeTimeFields();
            }
        }
        return this;
    }

    public FlexiDateTime validate() {
        DateTimeFieldRule dateTimeFieldRule;
        for (Map.Entry<DateTimeFieldRule, Integer> entry : this.fieldValueMap.entrySet()) {
            entry.getKey().checkValue(entry.getValue());
        }
        if (this.date != null) {
            for (Map.Entry<DateTimeFieldRule, Integer> entry : this.fieldValueMap.entrySet()) {
                dateTimeFieldRule = entry.getKey();
                if (!this.date.isSupported(dateTimeFieldRule) || this.date.get(dateTimeFieldRule) == entry.getValue().intValue()) continue;
                throw new InvalidCalendarFieldException("Value " + entry.getValue() + " for " + dateTimeFieldRule.getName() + " does not match value for date " + this.date, dateTimeFieldRule);
            }
        }
        if (this.time != null) {
            for (Map.Entry<DateTimeFieldRule, Integer> entry : this.fieldValueMap.entrySet()) {
                dateTimeFieldRule = entry.getKey();
                if (!this.time.isSupported(dateTimeFieldRule) || this.time.get(dateTimeFieldRule) == entry.getValue().intValue()) continue;
                throw new InvalidCalendarFieldException("Value " + entry.getValue() + " for " + dateTimeFieldRule.getName() + " does not match value for time " + this.time, dateTimeFieldRule);
            }
        }
        return this;
    }

    public FlexiDateTime validateDate() {
        if (this.date == null) {
            for (Map.Entry<DateTimeFieldRule, Integer> entry : this.fieldValueMap.entrySet()) {
                DateTimeFieldRule dateTimeFieldRule = entry.getKey();
                if (!dateTimeFieldRule.isDateField()) continue;
                dateTimeFieldRule.checkValue(entry.getValue());
            }
        } else {
            for (Map.Entry<DateTimeFieldRule, Integer> entry : this.fieldValueMap.entrySet()) {
                DateTimeFieldRule dateTimeFieldRule = entry.getKey();
                if (!dateTimeFieldRule.isDateField() || !this.date.isSupported(dateTimeFieldRule) || this.date.get(dateTimeFieldRule) == entry.getValue().intValue()) continue;
                throw new InvalidCalendarFieldException("Value " + entry.getValue() + " for " + dateTimeFieldRule.getName() + " does not match value for date " + this.date, dateTimeFieldRule);
            }
        }
        return this;
    }

    @Override
    public LocalDate toLocalDate() {
        FlexiDateTime flexiDateTime = this.mergeDateFields();
        if (flexiDateTime.date == null) {
            throw new CalendarConversionException("Cannot convert FlexiDateTime to LocalDate, insufficient infomation to create a date");
        }
        return flexiDateTime.validateDate().date;
    }

    @Override
    public LocalTime toLocalTime() {
        FlexiDateTime flexiDateTime = this.mergeDateFields();
        if (flexiDateTime.time == null) {
            throw new CalendarConversionException("Cannot convert FlexiDateTime to LocalTime, insufficient infomation to create a time");
        }
        return flexiDateTime.validate().time;
    }

    @Override
    public LocalDateTime toLocalDateTime() {
        return LocalDateTime.dateTime(this.toLocalDate(), this.toLocalTime());
    }

    @Override
    public OffsetDate toOffsetDate() {
        LocalDate localDate = this.toLocalDate();
        if (this.offset == null) {
            throw new CalendarConversionException("Cannot convert FlexiDateTime to OffsetDate because the offset is null");
        }
        return OffsetDate.date(localDate, this.offset);
    }

    @Override
    public OffsetTime toOffsetTime() {
        LocalTime localTime = this.toLocalTime();
        if (this.offset == null) {
            throw new CalendarConversionException("Cannot convert FlexiDateTime to OffsetTime because the offset is null");
        }
        return OffsetTime.time(localTime, this.offset);
    }

    @Override
    public OffsetDateTime toOffsetDateTime() {
        LocalDateTime localDateTime = this.toLocalDateTime();
        if (this.offset == null) {
            throw new CalendarConversionException("Cannot convert FlexiDateTime to OffsetDateTime because the offset is null");
        }
        return OffsetDateTime.dateTime(localDateTime, this.offset);
    }

    @Override
    public ZonedDateTime toZonedDateTime() {
        OffsetDateTime offsetDateTime = this.toOffsetDateTime();
        if (this.zone == null) {
            throw new CalendarConversionException("Cannot convert FlexiDateTime to ZonedDateTime because the zone is null");
        }
        return ZonedDateTime.dateTime(offsetDateTime, this.zone);
    }

    public FlexiDateTime toFlexiDateTime() {
        return this;
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof FlexiDateTime)) {
            return false;
        }
        FlexiDateTime flexiDateTime = (FlexiDateTime)object;
        if (!(this.date == flexiDateTime.date || this.date != null && this.date.equals(flexiDateTime.date))) {
            return false;
        }
        if (!(this.time == flexiDateTime.time || this.time != null && this.time.equals(flexiDateTime.time))) {
            return false;
        }
        if (!(this.offset == flexiDateTime.offset || this.offset != null && this.offset.equals(flexiDateTime.offset))) {
            return false;
        }
        if (!(this.zone == flexiDateTime.zone || this.zone != null && this.zone.equals(flexiDateTime.zone))) {
            return false;
        }
        return ((Object)this.fieldValueMap).equals(flexiDateTime.fieldValueMap);
    }

    @Override
    public int hashCode() {
        int n = 7;
        n = 59 * n + (this.fieldValueMap != null ? ((Object)this.fieldValueMap).hashCode() : 0);
        n = 59 * n + (this.date != null ? this.date.hashCode() : 0);
        n = 59 * n + (this.time != null ? this.time.hashCode() : 0);
        n = 59 * n + (this.offset != null ? this.offset.hashCode() : 0);
        n = 59 * n + (this.zone != null ? this.zone.hashCode() : 0);
        return n;
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.getFieldValueMap().size() > 0) {
            stringBuilder.append(this.getFieldValueMap());
            if (this.date != null || this.time != null || this.offset != null) {
                stringBuilder.append(' ');
            }
        }
        if (this.date != null) {
            stringBuilder.append(this.date);
        }
        if (this.time != null) {
            stringBuilder.append('T').append(this.time);
        }
        if (this.offset != null) {
            stringBuilder.append(this.offset);
        }
        if (this.zone != null) {
            if (this.date != null || this.time != null || this.offset != null) {
                stringBuilder.append(' ');
            }
            stringBuilder.append(this.zone);
        }
        return stringBuilder.toString();
    }
}

