/*
 * Decompiled with CFR 0.152.
 */
package javax.time.calendar;

import java.io.Serializable;
import javax.time.Instant;
import javax.time.InstantProvider;
import javax.time.calendar.Calendrical;
import javax.time.calendar.CalendricalProvider;
import javax.time.calendar.DateTimeFieldRule;
import javax.time.calendar.ISOChronology;
import javax.time.calendar.LocalTime;
import javax.time.calendar.TimeAdjuster;
import javax.time.calendar.TimeMatcher;
import javax.time.calendar.TimeProvider;
import javax.time.calendar.ZoneOffset;
import javax.time.calendar.field.HourOfDay;
import javax.time.calendar.field.MinuteOfHour;
import javax.time.calendar.field.NanoOfSecond;
import javax.time.calendar.field.SecondOfMinute;
import javax.time.calendar.format.DateTimeFormatters;
import javax.time.period.PeriodProvider;

public final class OffsetTime
implements TimeProvider,
CalendricalProvider,
Comparable<OffsetTime>,
Serializable,
TimeMatcher,
TimeAdjuster {
    private static final long serialVersionUID = -1751032571L;
    private final LocalTime time;
    private final ZoneOffset offset;

    public static OffsetTime time(HourOfDay hourOfDay, MinuteOfHour minuteOfHour, ZoneOffset zoneOffset) {
        LocalTime localTime = LocalTime.time(hourOfDay, minuteOfHour);
        return new OffsetTime(localTime, zoneOffset);
    }

    public static OffsetTime time(HourOfDay hourOfDay, MinuteOfHour minuteOfHour, SecondOfMinute secondOfMinute, ZoneOffset zoneOffset) {
        LocalTime localTime = LocalTime.time(hourOfDay, minuteOfHour, secondOfMinute);
        return new OffsetTime(localTime, zoneOffset);
    }

    public static OffsetTime time(HourOfDay hourOfDay, MinuteOfHour minuteOfHour, SecondOfMinute secondOfMinute, NanoOfSecond nanoOfSecond, ZoneOffset zoneOffset) {
        LocalTime localTime = LocalTime.time(hourOfDay, minuteOfHour, secondOfMinute, nanoOfSecond);
        return new OffsetTime(localTime, zoneOffset);
    }

    public static OffsetTime time(int n, int n2, ZoneOffset zoneOffset) {
        LocalTime localTime = LocalTime.time(n, n2);
        return new OffsetTime(localTime, zoneOffset);
    }

    public static OffsetTime time(int n, int n2, int n3, ZoneOffset zoneOffset) {
        LocalTime localTime = LocalTime.time(n, n2, n3);
        return new OffsetTime(localTime, zoneOffset);
    }

    public static OffsetTime time(int n, int n2, int n3, int n4, ZoneOffset zoneOffset) {
        LocalTime localTime = LocalTime.time(n, n2, n3, n4);
        return new OffsetTime(localTime, zoneOffset);
    }

    public static OffsetTime time(TimeProvider timeProvider, ZoneOffset zoneOffset) {
        LocalTime localTime = LocalTime.time(timeProvider);
        return new OffsetTime(localTime, zoneOffset);
    }

    public static OffsetTime fromInstant(InstantProvider instantProvider, ZoneOffset zoneOffset) {
        Instant instant = Instant.instant(instantProvider);
        ISOChronology.checkNotNull(zoneOffset, "ZoneOffset must not be null");
        long l = instant.getEpochSeconds() % 86400L;
        l = (l + (long)zoneOffset.getAmountSeconds()) % 86400L;
        if (l < 0L) {
            l += 86400L;
        }
        LocalTime localTime = LocalTime.fromSecondOfDay(l, instant.getNanoOfSecond());
        return new OffsetTime(localTime, zoneOffset);
    }

    public static OffsetTime parse(String string) {
        ISOChronology.checkNotNull(string, "Text to parse must not be null");
        return DateTimeFormatters.isoOffsetTime().parse(string).mergeStrict().toOffsetTime();
    }

    private OffsetTime(LocalTime localTime, ZoneOffset zoneOffset) {
        if (localTime == null) {
            throw new NullPointerException("The time must not be null");
        }
        if (zoneOffset == null) {
            throw new NullPointerException("The zone offset must not be null");
        }
        this.time = localTime;
        this.offset = zoneOffset;
    }

    public ISOChronology getChronology() {
        return ISOChronology.INSTANCE;
    }

    public boolean isSupported(DateTimeFieldRule dateTimeFieldRule) {
        return this.time.isSupported(dateTimeFieldRule);
    }

    public int get(DateTimeFieldRule dateTimeFieldRule) {
        return this.time.get(dateTimeFieldRule);
    }

    public LocalTime getTime() {
        return this.time;
    }

    public OffsetTime withTime(TimeProvider timeProvider) {
        LocalTime localTime = LocalTime.time(timeProvider);
        return localTime.equals(this.time) ? this : new OffsetTime(localTime, this.offset);
    }

    public ZoneOffset getOffset() {
        return this.offset;
    }

    public OffsetTime withOffset(ZoneOffset zoneOffset) {
        return zoneOffset != null && zoneOffset.equals(this.offset) ? this : new OffsetTime(this.time, zoneOffset);
    }

    public OffsetTime adjustLocalTime(ZoneOffset zoneOffset) {
        if (zoneOffset.equals(this.offset)) {
            return this;
        }
        int n = zoneOffset.getAmountSeconds() - this.offset.getAmountSeconds();
        LocalTime localTime = this.time.plusSeconds(n);
        return new OffsetTime(localTime, zoneOffset);
    }

    public HourOfDay toHourOfDay() {
        return this.time.toHourOfDay();
    }

    public MinuteOfHour toMinuteOfHour() {
        return this.time.toMinuteOfHour();
    }

    public SecondOfMinute toSecondOfMinute() {
        return this.time.toSecondOfMinute();
    }

    public NanoOfSecond toNanoOfSecond() {
        return this.time.toNanoOfSecond();
    }

    public int getHourOfDay() {
        return this.time.getHourOfDay();
    }

    public int getMinuteOfHour() {
        return this.time.getMinuteOfHour();
    }

    public int getSecondOfMinute() {
        return this.time.getSecondOfMinute();
    }

    public int getNanoOfSecond() {
        return this.time.getNanoOfSecond();
    }

    public OffsetTime with(TimeAdjuster timeAdjuster) {
        LocalTime localTime = this.time.with(timeAdjuster);
        return localTime == this.time ? this : new OffsetTime(localTime, this.offset);
    }

    public OffsetTime withHourOfDay(int n) {
        LocalTime localTime = this.time.withHourOfDay(n);
        return localTime == this.time ? this : new OffsetTime(localTime, this.offset);
    }

    public OffsetTime withMinuteOfHour(int n) {
        LocalTime localTime = this.time.withMinuteOfHour(n);
        return localTime == this.time ? this : new OffsetTime(localTime, this.offset);
    }

    public OffsetTime withSecondOfMinute(int n) {
        LocalTime localTime = this.time.withSecondOfMinute(n);
        return localTime == this.time ? this : new OffsetTime(localTime, this.offset);
    }

    public OffsetTime withNanoOfSecond(int n) {
        LocalTime localTime = this.time.withNanoOfSecond(n);
        return localTime == this.time ? this : new OffsetTime(localTime, this.offset);
    }

    public OffsetTime plus(PeriodProvider periodProvider) {
        LocalTime localTime = this.time.plus(periodProvider);
        return localTime == this.time ? this : new OffsetTime(localTime, this.offset);
    }

    public OffsetTime plusHours(int n) {
        LocalTime localTime = this.time.plusHours(n);
        return localTime == this.time ? this : new OffsetTime(localTime, this.offset);
    }

    public OffsetTime plusMinutes(int n) {
        LocalTime localTime = this.time.plusMinutes(n);
        return localTime == this.time ? this : new OffsetTime(localTime, this.offset);
    }

    public OffsetTime plusSeconds(int n) {
        LocalTime localTime = this.time.plusSeconds(n);
        return localTime == this.time ? this : new OffsetTime(localTime, this.offset);
    }

    public OffsetTime plusNanos(int n) {
        LocalTime localTime = this.time.plusNanos(n);
        return localTime == this.time ? this : new OffsetTime(localTime, this.offset);
    }

    public OffsetTime minus(PeriodProvider periodProvider) {
        LocalTime localTime = this.time.minus(periodProvider);
        return localTime == this.time ? this : new OffsetTime(localTime, this.offset);
    }

    public OffsetTime minusHours(int n) {
        LocalTime localTime = this.time.minusHours(n);
        return localTime == this.time ? this : new OffsetTime(localTime, this.offset);
    }

    public OffsetTime minusMinutes(int n) {
        LocalTime localTime = this.time.minusMinutes(n);
        return localTime == this.time ? this : new OffsetTime(localTime, this.offset);
    }

    public OffsetTime minusSeconds(int n) {
        LocalTime localTime = this.time.minusSeconds(n);
        return localTime == this.time ? this : new OffsetTime(localTime, this.offset);
    }

    public OffsetTime minusNanos(int n) {
        LocalTime localTime = this.time.minusNanos(n);
        return localTime == this.time ? this : new OffsetTime(localTime, this.offset);
    }

    public boolean matches(TimeMatcher timeMatcher) {
        return this.time.matches(timeMatcher);
    }

    @Override
    public boolean matchesTime(LocalTime localTime) {
        return this.time.matchesTime(localTime);
    }

    @Override
    public LocalTime adjustTime(LocalTime localTime) {
        return this.matches(localTime) ? localTime : this.time;
    }

    @Override
    public LocalTime toLocalTime() {
        return this.time;
    }

    @Override
    public Calendrical toCalendrical() {
        return new Calendrical(null, this.time, this.offset, null);
    }

    @Override
    public int compareTo(OffsetTime offsetTime) {
        LocalTime localTime;
        if (this.offset.equals(offsetTime.offset)) {
            return this.time.compareTo(offsetTime.time);
        }
        LocalTime localTime2 = this.time.plusSeconds(-this.offset.getAmountSeconds());
        int n = localTime2.compareTo(localTime = offsetTime.time.plusSeconds(-offsetTime.offset.getAmountSeconds()));
        if (n == 0) {
            n = this.time.compareTo(offsetTime.time);
        }
        return n;
    }

    public boolean isAfter(OffsetTime offsetTime) {
        return this.compareTo(offsetTime) > 0;
    }

    public boolean isBefore(OffsetTime offsetTime) {
        return this.compareTo(offsetTime) < 0;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof OffsetTime) {
            OffsetTime offsetTime = (OffsetTime)object;
            return this.time.equals(offsetTime.time) && this.offset.equals(offsetTime.offset);
        }
        return false;
    }

    public int hashCode() {
        return this.time.hashCode() ^ this.offset.hashCode();
    }

    public String toString() {
        return this.time.toString() + this.offset.toString();
    }
}

