/*
 * Decompiled with CFR 0.152.
 */
package javax.time.calendar.field;

import java.io.Serializable;
import java.util.concurrent.atomic.AtomicReferenceArray;
import javax.time.calendar.Calendrical;
import javax.time.calendar.DateTimeFieldRule;
import javax.time.calendar.FlexiDateTime;
import javax.time.calendar.IllegalCalendarFieldValueException;
import javax.time.calendar.LocalTime;
import javax.time.calendar.TimeMatcher;
import javax.time.period.Periods;

public final class HourOfMeridiem
implements Calendrical,
Comparable<HourOfMeridiem>,
Serializable,
TimeMatcher {
    public static final DateTimeFieldRule RULE = Rule.access$000();
    private static final long serialVersionUID = 1L;
    private static final AtomicReferenceArray<HourOfMeridiem> cache = new AtomicReferenceArray(12);
    private final int hourOfMeridiem;

    public static HourOfMeridiem hourOfMeridiem(int n) {
        try {
            HourOfMeridiem hourOfMeridiem = cache.get(n);
            if (hourOfMeridiem == null) {
                HourOfMeridiem hourOfMeridiem2 = new HourOfMeridiem(n);
                cache.compareAndSet(n, null, hourOfMeridiem2);
                hourOfMeridiem = cache.get(n);
            }
            return hourOfMeridiem;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new IllegalCalendarFieldValueException(RULE, n, RULE.getMinimumValue(), RULE.getMaximumValue());
        }
    }

    private HourOfMeridiem(int n) {
        this.hourOfMeridiem = n;
    }

    private Object readResolve() {
        return HourOfMeridiem.hourOfMeridiem(this.hourOfMeridiem);
    }

    public int getValue() {
        return this.hourOfMeridiem;
    }

    public FlexiDateTime toFlexiDateTime() {
        return new FlexiDateTime(RULE, this.getValue());
    }

    @Override
    public int compareTo(HourOfMeridiem hourOfMeridiem) {
        int n = this.hourOfMeridiem;
        int n2 = hourOfMeridiem.hourOfMeridiem;
        return n < n2 ? -1 : (n == n2 ? 0 : 1);
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof HourOfMeridiem) {
            return this.hourOfMeridiem == ((HourOfMeridiem)object).hourOfMeridiem;
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.hourOfMeridiem;
    }

    @Override
    public String toString() {
        return "HourOfMeridiem=" + this.getValue();
    }

    @Override
    public boolean matchesTime(LocalTime localTime) {
        return this.hourOfMeridiem == localTime.getHourOfDay().getHourOfAmPm();
    }

    private static class Rule
    extends DateTimeFieldRule
    implements Serializable {
        private static final DateTimeFieldRule INSTANCE = new Rule();
        private static final long serialVersionUID = 1L;

        private Rule() {
            super("HourOfMeridiem", Periods.HOURS, Periods.DAYS, 0, 11);
        }

        private Object readResolve() {
            return INSTANCE;
        }

        protected Integer extractValue(FlexiDateTime flexiDateTime) {
            return flexiDateTime.getTime() != null ? Integer.valueOf(flexiDateTime.getTime().getHourOfDay().getHourOfAmPm()) : null;
        }

        static /* synthetic */ DateTimeFieldRule access$000() {
            return INSTANCE;
        }
    }
}

