/*
 * Decompiled with CFR 0.152.
 */
package javax.time.calendar.field;

import java.io.Serializable;
import java.util.concurrent.atomic.AtomicReferenceArray;
import javax.time.calendar.Calendrical;
import javax.time.calendar.CalendricalProvider;
import javax.time.calendar.DateTimeFieldRule;
import javax.time.calendar.ISOChronology;
import javax.time.calendar.IllegalCalendarFieldValueException;
import javax.time.calendar.LocalTime;
import javax.time.calendar.TimeAdjuster;
import javax.time.calendar.TimeMatcher;
import javax.time.calendar.TimeProvider;

public final class MinuteOfHour
implements CalendricalProvider,
Comparable<MinuteOfHour>,
TimeAdjuster,
TimeMatcher,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final AtomicReferenceArray<MinuteOfHour> CACHE = new AtomicReferenceArray(60);
    private final int minuteOfHour;

    public static DateTimeFieldRule rule() {
        return ISOChronology.minuteOfHourRule();
    }

    public static MinuteOfHour minuteOfHour(int n) {
        try {
            MinuteOfHour minuteOfHour = CACHE.get(n);
            if (minuteOfHour == null) {
                MinuteOfHour minuteOfHour2 = new MinuteOfHour(n);
                CACHE.compareAndSet(n, null, minuteOfHour2);
                minuteOfHour = CACHE.get(n);
            }
            return minuteOfHour;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new IllegalCalendarFieldValueException(MinuteOfHour.rule(), n, MinuteOfHour.rule().getMinimumValue(), MinuteOfHour.rule().getMaximumValue());
        }
    }

    public static MinuteOfHour minuteOfHour(TimeProvider timeProvider) {
        return LocalTime.time(timeProvider).toMinuteOfHour();
    }

    private MinuteOfHour(int n) {
        this.minuteOfHour = n;
    }

    private Object readResolve() {
        return MinuteOfHour.minuteOfHour(this.minuteOfHour);
    }

    public int getValue() {
        return this.minuteOfHour;
    }

    @Override
    public LocalTime adjustTime(LocalTime localTime) {
        return localTime.withMinuteOfHour(this.minuteOfHour);
    }

    @Override
    public boolean matchesTime(LocalTime localTime) {
        return this.minuteOfHour == localTime.getMinuteOfHour();
    }

    @Override
    public Calendrical toCalendrical() {
        return new Calendrical(MinuteOfHour.rule(), this.getValue());
    }

    @Override
    public int compareTo(MinuteOfHour minuteOfHour) {
        int n = this.minuteOfHour;
        int n2 = minuteOfHour.minuteOfHour;
        return n < n2 ? -1 : (n == n2 ? 0 : 1);
    }

    public boolean equals(Object object) {
        return this == object;
    }

    public int hashCode() {
        return this.minuteOfHour;
    }

    public String toString() {
        return "MinuteOfHour=" + this.getValue();
    }
}

