/*
 * Decompiled with CFR 0.152.
 */
package javax.time.calendar.field;

import java.io.Serializable;
import java.util.concurrent.atomic.AtomicReferenceArray;
import javax.time.calendar.Calendrical;
import javax.time.calendar.DateMatcher;
import javax.time.calendar.DateProvider;
import javax.time.calendar.DateTimeFieldRule;
import javax.time.calendar.FlexiDateTime;
import javax.time.calendar.ISOChronology;
import javax.time.calendar.IllegalCalendarFieldValueException;
import javax.time.calendar.LocalDate;

public final class WeekOfMonth
implements Calendrical,
Comparable<WeekOfMonth>,
Serializable,
DateMatcher {
    private static final long serialVersionUID = 1L;
    private static final AtomicReferenceArray<WeekOfMonth> cache = new AtomicReferenceArray(5);
    private final int weekOfMonth;

    public static DateTimeFieldRule rule() {
        return ISOChronology.INSTANCE.weekOfMonth();
    }

    public static WeekOfMonth weekOfMonth(int n) {
        try {
            WeekOfMonth weekOfMonth = cache.get(--n);
            if (weekOfMonth == null) {
                WeekOfMonth weekOfMonth2 = new WeekOfMonth(n + 1);
                cache.compareAndSet(n, null, weekOfMonth2);
                weekOfMonth = cache.get(n);
            }
            return weekOfMonth;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new IllegalCalendarFieldValueException(WeekOfMonth.rule(), n, 1, 5);
        }
    }

    public static WeekOfMonth weekOfMonth(DateProvider dateProvider) {
        int n = LocalDate.date(dateProvider).getDayOfMonth().getValue() - 1;
        return new WeekOfMonth(n % 7 + 1);
    }

    private WeekOfMonth(int n) {
        this.weekOfMonth = n;
    }

    private Object readResolve() {
        return WeekOfMonth.weekOfMonth(this.weekOfMonth);
    }

    public int getValue() {
        return this.weekOfMonth;
    }

    public FlexiDateTime toFlexiDateTime() {
        return new FlexiDateTime(WeekOfMonth.rule(), this.getValue());
    }

    @Override
    public boolean matchesDate(LocalDate localDate) {
        return WeekOfMonth.weekOfMonth(localDate) == this;
    }

    @Override
    public int compareTo(WeekOfMonth weekOfMonth) {
        int n = this.weekOfMonth;
        int n2 = weekOfMonth.weekOfMonth;
        return n < n2 ? -1 : (n == n2 ? 0 : 1);
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof WeekOfMonth) {
            return this.weekOfMonth == ((WeekOfMonth)object).weekOfMonth;
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.weekOfMonth;
    }

    @Override
    public String toString() {
        return "WeekOfMonth=" + this.getValue();
    }
}

