/*
 * Decompiled with CFR 0.152.
 */
package javax.time.calendar.field;

import java.io.Serializable;
import java.util.concurrent.atomic.AtomicReferenceArray;
import javax.time.MathUtils;
import javax.time.calendar.Calendrical;
import javax.time.calendar.CalendricalProvider;
import javax.time.calendar.DateMatcher;
import javax.time.calendar.DateProvider;
import javax.time.calendar.DateTimeFieldRule;
import javax.time.calendar.ISOChronology;
import javax.time.calendar.IllegalCalendarFieldValueException;
import javax.time.calendar.LocalDate;
import javax.time.calendar.field.DayOfMonth;
import javax.time.calendar.field.MonthOfYear;
import javax.time.calendar.field.WeekBasedYear;
import javax.time.calendar.field.Year;

public final class WeekOfWeekBasedYear
implements CalendricalProvider,
Comparable<WeekOfWeekBasedYear>,
DateMatcher,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final AtomicReferenceArray<WeekOfWeekBasedYear> CACHE = new AtomicReferenceArray(53);
    private final int weekOfWeekyear;

    public static DateTimeFieldRule rule() {
        return ISOChronology.weekOfWeekBasedYearRule();
    }

    public static WeekOfWeekBasedYear weekOfWeekyear(int n) {
        try {
            WeekOfWeekBasedYear weekOfWeekBasedYear = CACHE.get(--n);
            if (weekOfWeekBasedYear == null) {
                WeekOfWeekBasedYear weekOfWeekBasedYear2 = new WeekOfWeekBasedYear(n + 1);
                CACHE.compareAndSet(n, null, weekOfWeekBasedYear2);
                weekOfWeekBasedYear = CACHE.get(n);
            }
            return weekOfWeekBasedYear;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new IllegalCalendarFieldValueException(WeekOfWeekBasedYear.rule(), ++n, 1, 53);
        }
    }

    public static WeekOfWeekBasedYear weekOfWeekyear(DateProvider dateProvider) {
        LocalDate localDate = LocalDate.date(dateProvider);
        Year year = WeekBasedYear.computeYear(localDate);
        LocalDate localDate2 = LocalDate.date(year, MonthOfYear.JANUARY, DayOfMonth.dayOfMonth(4));
        return WeekOfWeekBasedYear.weekOfWeekyear(MathUtils.safeToInt((localDate.toModifiedJulianDays() - localDate2.toModifiedJulianDays() + (long)localDate2.getDayOfWeek().getValue() - 1L) / 7L + 1L));
    }

    private WeekOfWeekBasedYear(int n) {
        this.weekOfWeekyear = n;
    }

    private Object readResolve() {
        return WeekOfWeekBasedYear.weekOfWeekyear(this.weekOfWeekyear);
    }

    public int getValue() {
        return this.weekOfWeekyear;
    }

    @Override
    public boolean matchesDate(LocalDate localDate) {
        return WeekOfWeekBasedYear.weekOfWeekyear(localDate).equals(this);
    }

    @Override
    public Calendrical toCalendrical() {
        return new Calendrical(WeekOfWeekBasedYear.rule(), this.getValue());
    }

    public boolean isValid(WeekBasedYear weekBasedYear) {
        if (weekBasedYear == null) {
            throw new NullPointerException("Weekyear cannot be null");
        }
        return this.weekOfWeekyear < 53 || weekBasedYear.lengthInWeeks() == 53;
    }

    @Override
    public int compareTo(WeekOfWeekBasedYear weekOfWeekBasedYear) {
        int n = this.weekOfWeekyear;
        int n2 = weekOfWeekBasedYear.weekOfWeekyear;
        return n < n2 ? -1 : (n == n2 ? 0 : 1);
    }

    public boolean isAfter(WeekOfWeekBasedYear weekOfWeekBasedYear) {
        return this.compareTo(weekOfWeekBasedYear) > 0;
    }

    public boolean isBefore(WeekOfWeekBasedYear weekOfWeekBasedYear) {
        return this.compareTo(weekOfWeekBasedYear) < 0;
    }

    public boolean equals(Object object) {
        return this == object;
    }

    public int hashCode() {
        return this.weekOfWeekyear;
    }

    public String toString() {
        return "WeekOfWeekBasedYear=" + this.getValue();
    }
}

