/*
 * Decompiled with CFR 0.152.
 */
package javax.time.calendar.field;

import java.io.Serializable;
import java.util.concurrent.atomic.AtomicReferenceArray;
import javax.time.calendar.Calendrical;
import javax.time.calendar.DateProvider;
import javax.time.calendar.DateTimeFieldRule;
import javax.time.calendar.FlexiDateTime;
import javax.time.calendar.ISOChronology;
import javax.time.calendar.IllegalCalendarFieldValueException;
import javax.time.calendar.field.Weekyear;

public final class WeekOfWeekyear
implements Calendrical,
Comparable<WeekOfWeekyear>,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final AtomicReferenceArray<WeekOfWeekyear> cache = new AtomicReferenceArray(53);
    private final int weekOfWeekyear;

    public static DateTimeFieldRule rule() {
        return ISOChronology.INSTANCE.weekOfWeekyear();
    }

    public static WeekOfWeekyear weekOfWeekyear(int n) {
        try {
            WeekOfWeekyear weekOfWeekyear = cache.get(--n);
            if (weekOfWeekyear == null) {
                WeekOfWeekyear weekOfWeekyear2 = new WeekOfWeekyear(n + 1);
                cache.compareAndSet(n, null, weekOfWeekyear2);
                weekOfWeekyear = cache.get(n);
            }
            return weekOfWeekyear;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new IllegalCalendarFieldValueException(WeekOfWeekyear.rule(), n, 1, 53);
        }
    }

    public static WeekOfWeekyear weekOfWeekyear(DateProvider dateProvider) {
        return new WeekOfWeekyear(1);
    }

    private WeekOfWeekyear(int n) {
        this.weekOfWeekyear = n;
    }

    private Object readResolve() {
        return WeekOfWeekyear.weekOfWeekyear(this.weekOfWeekyear);
    }

    public int getValue() {
        return this.weekOfWeekyear;
    }

    public FlexiDateTime toFlexiDateTime() {
        return new FlexiDateTime(WeekOfWeekyear.rule(), this.getValue());
    }

    public boolean isValid(Weekyear weekyear) {
        return this.weekOfWeekyear < 53 || weekyear.lengthInWeeks() == 53;
    }

    @Override
    public int compareTo(WeekOfWeekyear weekOfWeekyear) {
        int n = this.weekOfWeekyear;
        int n2 = weekOfWeekyear.weekOfWeekyear;
        return n < n2 ? -1 : (n == n2 ? 0 : 1);
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof WeekOfWeekyear) {
            return this.weekOfWeekyear == ((WeekOfWeekyear)object).weekOfWeekyear;
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.weekOfWeekyear;
    }

    @Override
    public String toString() {
        return "WeekOfWeekyear=" + this.getValue();
    }
}

