/*
 * Decompiled with CFR 0.152.
 */
package javax.time.calendar.format;

import java.io.IOException;
import javax.time.calendar.Calendrical;
import javax.time.calendar.format.DateTimeFormatSymbols;
import javax.time.calendar.format.DateTimeParseContext;
import javax.time.calendar.format.DateTimeParser;
import javax.time.calendar.format.DateTimePrinter;

class StringLiteralPrinterParser
implements DateTimePrinter,
DateTimeParser {
    private final String literal;

    StringLiteralPrinterParser(String string) {
        this.literal = string;
    }

    @Override
    public void print(Calendrical calendrical, Appendable appendable, DateTimeFormatSymbols dateTimeFormatSymbols) throws IOException {
        appendable.append(this.literal);
    }

    @Override
    public boolean isPrintDataAvailable(Calendrical calendrical) {
        return true;
    }

    @Override
    public int parse(DateTimeParseContext dateTimeParseContext, String string, int n) {
        int n2 = string.length();
        if (n > n2) {
            throw new IndexOutOfBoundsException();
        }
        int n3 = n + this.literal.length();
        if (n3 > n2) {
            return ~n;
        }
        if (!this.literal.equals(string.substring(n, n3))) {
            return ~n;
        }
        return n3;
    }

    public String toString() {
        String string = this.literal.replace("'", "''");
        return "'" + string + "'";
    }
}

