/*
 * Decompiled with CFR 0.152.
 */
package javax.time.calendar.zone;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.time.InstantProvider;
import javax.time.calendar.LocalDateTime;
import javax.time.calendar.ZoneOffset;
import javax.time.calendar.zone.ZoneOffsetTransition;
import javax.time.calendar.zone.ZoneOffsetTransitionRule;
import javax.time.calendar.zone.ZoneRules;

final class FixedZoneRules
extends ZoneRules
implements Serializable {
    private static final long serialVersionUID = 21787269186981L;
    private final ZoneOffset offset;

    FixedZoneRules(ZoneOffset zoneOffset) {
        ZoneRules.checkNotNull(zoneOffset, "ZoneOffset must not be null");
        this.offset = zoneOffset;
    }

    @Override
    public ZoneOffset getOffset(InstantProvider instantProvider) {
        return this.offset;
    }

    @Override
    public ZoneRules.OffsetInfo getOffsetInfo(LocalDateTime localDateTime) {
        return this.createOffsetInfo(localDateTime, this.offset);
    }

    @Override
    public ZoneOffset getStandardOffset(InstantProvider instantProvider) {
        return this.offset;
    }

    @Override
    public boolean isFixedOffset() {
        return true;
    }

    @Override
    public ZoneOffsetTransition nextTransition(InstantProvider instantProvider) {
        return null;
    }

    @Override
    public ZoneOffsetTransition previousTransition(InstantProvider instantProvider) {
        return null;
    }

    @Override
    public List<ZoneOffsetTransition> getTransitions() {
        return new ArrayList<ZoneOffsetTransition>();
    }

    @Override
    public List<ZoneOffsetTransitionRule> getTransitionRules() {
        return new ArrayList<ZoneOffsetTransitionRule>();
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof FixedZoneRules) {
            return this.offset.equals(((FixedZoneRules)object).offset);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.offset.hashCode();
    }

    public String toString() {
        return this.offset == ZoneOffset.UTC ? "UTC" : "UTC" + this.offset.getID();
    }
}

