/*
 * Decompiled with CFR 0.152.
 */
package javax.time.calendar.zone;

import java.io.Serializable;
import javax.time.calendar.DateAdjusters;
import javax.time.calendar.LocalDate;
import javax.time.calendar.LocalDateTime;
import javax.time.calendar.LocalTime;
import javax.time.calendar.OffsetDateTime;
import javax.time.calendar.ZoneOffset;
import javax.time.calendar.field.DayOfWeek;
import javax.time.calendar.field.MonthOfYear;
import javax.time.calendar.zone.ZoneOffsetTransition;
import javax.time.calendar.zone.ZoneRules;
import javax.time.calendar.zone.ZoneRulesBuilder;

public final class ZoneOffsetTransitionRule
implements Serializable {
    private static final long serialVersionUID = -32352886665458L;
    private final MonthOfYear month;
    private final int dom;
    private final DayOfWeek dow;
    private final LocalTime time;
    private final ZoneRulesBuilder.TimeDefinition timeDefinition;
    private final ZoneOffset standardOffset;
    private final ZoneOffset offsetBefore;
    private final ZoneOffset offsetAfter;

    ZoneOffsetTransitionRule(MonthOfYear monthOfYear, int n, DayOfWeek dayOfWeek, LocalTime localTime, ZoneRulesBuilder.TimeDefinition timeDefinition, ZoneOffset zoneOffset, ZoneOffset zoneOffset2, ZoneOffset zoneOffset3) {
        ZoneRules.checkNotNull(monthOfYear, "MonthOfYear must not be null");
        ZoneRules.checkNotNull(localTime, "LocalTime must not be null");
        ZoneRules.checkNotNull((Object)timeDefinition, "TimeDefinition must not be null");
        ZoneRules.checkNotNull(zoneOffset, "Standard offset must not be null");
        ZoneRules.checkNotNull(zoneOffset2, "Offset before must not be null");
        ZoneRules.checkNotNull(zoneOffset3, "Offset after must not be null");
        this.month = monthOfYear;
        this.dom = n;
        this.dow = dayOfWeek;
        this.time = localTime;
        this.timeDefinition = timeDefinition;
        this.standardOffset = zoneOffset;
        this.offsetBefore = zoneOffset2;
        this.offsetAfter = zoneOffset3;
    }

    public MonthOfYear getMonthOfYear() {
        return this.month;
    }

    public int getDayOfMonthIndicator() {
        return this.dom;
    }

    public DayOfWeek getDayOfWeek() {
        return this.dow;
    }

    public LocalTime getLocalTime() {
        return this.time;
    }

    public ZoneRulesBuilder.TimeDefinition getTimeDefinition() {
        return this.timeDefinition;
    }

    public ZoneOffset getStandardOffset() {
        return this.standardOffset;
    }

    public ZoneOffset getOffsetBefore() {
        return this.offsetBefore;
    }

    public ZoneOffset getOffsetAfter() {
        return this.offsetAfter;
    }

    public ZoneOffsetTransition createTransition(int n) {
        LocalDate localDate;
        if (this.dom < 0) {
            localDate = LocalDate.date(n, this.month, this.month.lengthInDays(n) + 1 + this.dom);
            if (this.dow != null) {
                localDate = localDate.with(DateAdjusters.previousOrCurrent(this.dow));
            }
        } else {
            localDate = LocalDate.date(n, this.month, this.dom);
            if (this.dow != null) {
                localDate = localDate.with(DateAdjusters.nextOrCurrent(this.dow));
            }
        }
        LocalDateTime localDateTime = LocalDateTime.dateTime(localDate, this.time);
        OffsetDateTime offsetDateTime = this.timeDefinition.createDateTime(localDateTime, this.standardOffset, this.offsetBefore);
        return new ZoneOffsetTransition(offsetDateTime, this.offsetAfter);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof ZoneOffsetTransitionRule) {
            ZoneOffsetTransitionRule zoneOffsetTransitionRule = (ZoneOffsetTransitionRule)object;
            return this.month == zoneOffsetTransitionRule.month && this.dom == zoneOffsetTransitionRule.dom && this.dow == zoneOffsetTransitionRule.dow && this.timeDefinition == zoneOffsetTransitionRule.timeDefinition && this.time.equals(zoneOffsetTransitionRule.time) && this.standardOffset.equals(zoneOffsetTransitionRule.standardOffset) && this.offsetBefore.equals(zoneOffsetTransitionRule.offsetBefore) && this.offsetBefore.equals(zoneOffsetTransitionRule.offsetBefore);
        }
        return false;
    }

    public int hashCode() {
        int n = (this.time.toSecondOfDay() << 15) + (this.month.ordinal() << 11) + (this.dom + 32 << 5) + (this.dow.ordinal() << 2) + this.timeDefinition.ordinal();
        return n ^ this.standardOffset.hashCode() ^ this.offsetBefore.hashCode() ^ this.offsetAfter.hashCode();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("TransitionRule[").append(this.offsetBefore.compareTo(this.offsetAfter) > 0 ? "Gap " : "Overlap ").append(this.offsetBefore).append(" to ").append(this.offsetAfter).append(", ");
        if (this.dow != null) {
            if (this.dom < 0) {
                stringBuilder.append(this.dow.name()).append(" on or before ").append(this.month.name()).append(' ').append(this.dom);
            } else {
                stringBuilder.append(this.dow.name()).append(" on or after ").append(this.month.name()).append(' ').append(this.dom);
            }
        } else {
            stringBuilder.append(this.month.name()).append(' ').append(this.dom);
        }
        stringBuilder.append(" at ").append(this.time).append(" ").append((Object)this.timeDefinition).append(", standard offset ").append(this.standardOffset).append(']');
        return stringBuilder.toString();
    }
}

