/*
 * Decompiled with CFR 0.152.
 */
package javax.time.period;

import java.io.InvalidObjectException;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.time.period.Period;

public abstract class PeriodUnit
implements Comparable<PeriodUnit> {
    protected PeriodUnit() {
    }

    public abstract String getName();

    public abstract Period getAlternatePeriod();

    protected abstract BigDecimal getEstimatedDurationForComparison();

    public final boolean isStandard() {
        return this.getClass() == Standard.class;
    }

    public abstract boolean isStandardDerived();

    @Override
    public int compareTo(PeriodUnit periodUnit) {
        return this.getEstimatedDurationForComparison().compareTo(periodUnit.getEstimatedDurationForComparison());
    }

    public String toString() {
        return this.getName();
    }

    static final class Standard
    extends PeriodUnit
    implements Serializable {
        private static final Map<String, Standard> RESOLVE_MAP = new ConcurrentHashMap<String, Standard>();
        static final PeriodUnit CENTURIES = new Standard("Centuries", Period.years(100), 3155760000L, true);
        static final PeriodUnit DECADES = new Standard("Decades", Period.years(10), 315576000L, true);
        static final PeriodUnit YEARS = new Standard("Years", Period.months(12), 31557600L, false);
        static final PeriodUnit WEEKYEARS = new Standard("Weekyears", null, 31492800L, false);
        static final PeriodUnit QUARTERS = new Standard("Quarters", Period.months(3), 7889400L, true);
        static final PeriodUnit MONTHS = new Standard("Months", null, 2629800L, false);
        static final PeriodUnit WEEKS = new Standard("Weeks", Period.days(7), 604800L, true);
        static final PeriodUnit DAYS = new Standard("Days", null, 86400L, false);
        static final PeriodUnit TWELVE_HOURS = new Standard("TwelveHours", Period.hours(12), 43200L, true);
        static final PeriodUnit HOURS = new Standard("Hours", Period.minutes(60), 3600L, false);
        static final PeriodUnit MINUTES = new Standard("Minutes", Period.seconds(60), 60L, false);
        static final PeriodUnit SECONDS = new Standard("Seconds", Period.nanos(1000000000L), -1000000000L, false);
        static final PeriodUnit MILLIS = new Standard("Millis", Period.nanos(1000000L), -1000000L, false);
        static final PeriodUnit MICROS = new Standard("Micros", Period.nanos(1000L), -1000L, false);
        static final PeriodUnit NANOS = new Standard("Nanos", null, -1L, false);
        private static final long serialVersionUID = 136537637L;
        private final String name;
        private final transient Period alternatePeriod;
        private final transient BigDecimal estimatedDuration;
        private final transient boolean derived;

        private Standard(String string, Period period, long l, boolean bl) {
            this.name = string;
            this.alternatePeriod = period;
            this.estimatedDuration = l >= 0L ? new BigDecimal(l) : new BigDecimal(-l).movePointLeft(9);
            this.derived = bl;
            RESOLVE_MAP.put(string, this);
        }

        private Object readResolve() throws ObjectStreamException {
            Standard standard = RESOLVE_MAP.get(this.name);
            if (standard == null) {
                throw new InvalidObjectException("Period unit is not recognised: " + this.name);
            }
            return standard;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public Period getAlternatePeriod() {
            return this.alternatePeriod;
        }

        @Override
        protected BigDecimal getEstimatedDurationForComparison() {
            return this.estimatedDuration;
        }

        @Override
        public boolean isStandardDerived() {
            return this.derived;
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (object instanceof Standard) {
                return this.name.equals(((Standard)object).name);
            }
            return false;
        }

        public int hashCode() {
            return this.name.hashCode();
        }
    }
}

