/*
 * Decompiled with CFR 0.152.
 */
package javax.time.period;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.time.period.Period;
import javax.time.period.PeriodUnit;

public final class Periods {
    public static final PeriodUnit FOREVER = PeriodUnit.createUnit((String)"Forever");
    public static final PeriodUnit YEARS = PeriodUnit.createUnit((String)"Years");
    public static final PeriodUnit QUARTERS = PeriodUnit.createUnit((String)"Quarters");
    public static final PeriodUnit MONTHS = PeriodUnit.createUnit((String)"Months");
    public static final PeriodUnit WEEKS = PeriodUnit.createUnit((String)"Weeks");
    public static final PeriodUnit DAYS = PeriodUnit.createUnit((String)"Days");
    public static final PeriodUnit HOURS = PeriodUnit.createUnit((String)"Hours");
    public static final PeriodUnit MINUTES = PeriodUnit.createUnit((String)"Minutes");
    public static final PeriodUnit SECONDS = PeriodUnit.createUnit((String)"Seconds");
    public static final PeriodUnit NANOS = PeriodUnit.createUnit((String)"Nanos");

    private Periods() {
    }

    public static Period yearsMonthsDays(int n, int n2, int n3) {
        HashMap<PeriodUnit, Integer> hashMap = new HashMap<PeriodUnit, Integer>();
        hashMap.put(YEARS, n);
        hashMap.put(MONTHS, n2);
        hashMap.put(DAYS, n3);
        return Period.periodOf(hashMap);
    }

    public static Period hoursMinutesSeconds(int n, int n2, int n3) {
        HashMap<PeriodUnit, Integer> hashMap = new HashMap<PeriodUnit, Integer>();
        hashMap.put(HOURS, n);
        hashMap.put(MINUTES, n2);
        hashMap.put(SECONDS, n3);
        return Period.periodOf(hashMap);
    }

    public static Period years(int n) {
        Map<PeriodUnit, Integer> map = Collections.singletonMap(YEARS, n);
        return Period.periodOf(map);
    }

    public static Period quarters(int n) {
        Map<PeriodUnit, Integer> map = Collections.singletonMap(QUARTERS, n);
        return Period.periodOf(map);
    }

    public static Period months(int n) {
        Map<PeriodUnit, Integer> map = Collections.singletonMap(MONTHS, n);
        return Period.periodOf(map);
    }

    public static Period weeks(int n) {
        Map<PeriodUnit, Integer> map = Collections.singletonMap(WEEKS, n);
        return Period.periodOf(map);
    }

    public static Period days(int n) {
        Map<PeriodUnit, Integer> map = Collections.singletonMap(DAYS, n);
        return Period.periodOf(map);
    }

    public static Period hours(int n) {
        Map<PeriodUnit, Integer> map = Collections.singletonMap(HOURS, n);
        return Period.periodOf(map);
    }

    public static Period minutes(int n) {
        Map<PeriodUnit, Integer> map = Collections.singletonMap(MINUTES, n);
        return Period.periodOf(map);
    }

    public static Period seconds(int n) {
        Map<PeriodUnit, Integer> map = Collections.singletonMap(SECONDS, n);
        return Period.periodOf(map);
    }

    public static Period nanos(int n) {
        Map<PeriodUnit, Integer> map = Collections.singletonMap(NANOS, n);
        return Period.periodOf(map);
    }

    public static YearsBuilder periodBuilder() {
        return new YearsBuilder();
    }

    public static class YearsBuilder
    extends MonthsBuilder {
        public MonthsBuilder years(int n) {
            this.map.put(YEARS, n);
            return this;
        }
    }

    public static class MonthsBuilder
    extends DaysBuilder {
        public DaysBuilder months(int n) {
            this.map.put(MONTHS, n);
            return this;
        }
    }

    public static class DaysBuilder
    extends HoursBuilder {
        public HoursBuilder days(int n) {
            this.map.put(DAYS, n);
            return this;
        }
    }

    public static class HoursBuilder
    extends MinutesBuilder {
        public MinutesBuilder hours(int n) {
            this.map.put(HOURS, n);
            return this;
        }
    }

    public static class MinutesBuilder
    extends SecondsBuilder {
        public SecondsBuilder minutes(int n) {
            this.map.put(MINUTES, n);
            return this;
        }
    }

    public static class SecondsBuilder
    extends Builder {
        public Builder seconds(int n) {
            this.map.put(SECONDS, n);
            return this;
        }
    }

    public static class Builder {
        protected final Map<PeriodUnit, Integer> map = new HashMap<PeriodUnit, Integer>();

        public Period build() {
            return Period.periodOf(this.map);
        }
    }
}

