/*
 * Decompiled with CFR 0.152.
 */
package javax.time;

import java.io.Serializable;
import javax.time.Instant;
import javax.time.InstantProvider;

public abstract class InstantInterval
implements Serializable {
    public static final InstantInterval EMPTY = new Empty();
    public static final InstantInterval ALL = new All();
    private static final long serialVersionUID = 2751875381768L;

    public static InstantInterval intervalBetween(Instant instant, Instant instant2) {
        return InstantInterval.intervalBetween(instant, true, instant2, false);
    }

    public static InstantInterval intervalBetween(Instant instant, boolean bl, Instant instant2, boolean bl2) {
        if (instant == null || instant2 == null) {
            throw new NullPointerException("The start and end points must not be null");
        }
        int n = instant.compareTo(instant2);
        if (n == 0) {
            return EMPTY;
        }
        if (n > 0) {
            throw new IllegalArgumentException("The start instant is after the end instant");
        }
        return new Dual(InstantInterval.intervalFrom(instant, bl), InstantInterval.intervalTo(instant2, bl2));
    }

    public static InstantInterval intervalFrom(Instant instant) {
        return InstantInterval.intervalFrom(instant, true);
    }

    public static InstantInterval intervalFrom(Instant instant, boolean bl) {
        if (bl) {
            return new LessThanExclusive(instant);
        }
        return new LessThanInclusive(instant);
    }

    public static InstantInterval intervalTo(Instant instant) {
        return InstantInterval.intervalTo(instant, false);
    }

    public static InstantInterval intervalTo(Instant instant, boolean bl) {
        if (bl) {
            return new LessThanExclusive(instant);
        }
        return new LessThanInclusive(instant);
    }

    private InstantInterval() {
    }

    public boolean isEmpty() {
        return false;
    }

    public Instant getStart() {
        return null;
    }

    public boolean isStartInclusive() {
        return false;
    }

    public boolean isStartUnbounded() {
        return false;
    }

    public Instant getEnd() {
        return null;
    }

    public boolean isEndInclusive() {
        return false;
    }

    public boolean isEndUnbounded() {
        return false;
    }

    public boolean isBefore(InstantProvider instantProvider) {
        return false;
    }

    public boolean isAfter(InstantProvider instantProvider) {
        return false;
    }

    public boolean contains(InstantProvider instantProvider) {
        return false;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof InstantInterval) {
            InstantInterval instantInterval = (InstantInterval)object;
            return this.getStart().equals(instantInterval.getStart()) && this.getEnd().equals(instantInterval.getEnd()) && this.isStartInclusive() == instantInterval.isStartInclusive() && this.isEndInclusive() == instantInterval.isEndInclusive() && this.isStartUnbounded() == instantInterval.isStartUnbounded() && this.isEndUnbounded() == instantInterval.isEndUnbounded();
        }
        return false;
    }

    public int hashCode() {
        return this.getStart().hashCode() ^ this.getEnd().hashCode();
    }

    public String toString() {
        return super.toString();
    }

    private static final class Dual
    extends InstantInterval {
        private InstantInterval startAndAfter;
        private InstantInterval endAndBefore;

        private Dual(InstantInterval instantInterval, InstantInterval instantInterval2) {
            this.startAndAfter = instantInterval;
            this.endAndBefore = instantInterval2;
        }

        @Override
        public Instant getStart() {
            return this.startAndAfter.getStart();
        }

        @Override
        public boolean isStartInclusive() {
            return this.startAndAfter.isStartInclusive();
        }

        @Override
        public Instant getEnd() {
            return this.endAndBefore.getEnd();
        }

        @Override
        public boolean isEndInclusive() {
            return this.endAndBefore.isEndInclusive();
        }

        @Override
        public boolean isBefore(InstantProvider instantProvider) {
            return this.endAndBefore.isBefore(instantProvider);
        }

        @Override
        public boolean isAfter(InstantProvider instantProvider) {
            return this.startAndAfter.isAfter(instantProvider);
        }

        @Override
        public boolean contains(InstantProvider instantProvider) {
            return this.startAndAfter.contains(instantProvider) && this.endAndBefore.contains(instantProvider);
        }

        @Override
        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object instanceof Dual) {
                Dual dual = (Dual)object;
                return this.startAndAfter.equals(dual.startAndAfter) && this.endAndBefore.equals(dual.endAndBefore);
            }
            return false;
        }

        @Override
        public int hashCode() {
            return this.getClass().hashCode() ^ this.startAndAfter.hashCode() ^ this.endAndBefore.hashCode();
        }
    }

    private static final class LessThanExclusive
    extends InstantInterval {
        private Instant maximum;

        private LessThanExclusive(Instant instant) {
            if (instant == null) {
                throw new NullPointerException("The maximum point must not be null");
            }
            this.maximum = instant;
        }

        @Override
        public Instant getStart() {
            return null;
        }

        @Override
        public boolean isStartUnbounded() {
            return true;
        }

        @Override
        public Instant getEnd() {
            return this.maximum;
        }

        @Override
        public boolean isBefore(InstantProvider instantProvider) {
            return this.maximum.compareTo(Instant.instant(instantProvider)) <= 0;
        }

        @Override
        public boolean isAfter(InstantProvider instantProvider) {
            return false;
        }

        @Override
        public boolean contains(InstantProvider instantProvider) {
            return Instant.instant(instantProvider).compareTo(this.maximum) < 0;
        }

        @Override
        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object instanceof LessThanExclusive) {
                return this.maximum.equals(((LessThanExclusive)object).maximum);
            }
            return false;
        }

        @Override
        public int hashCode() {
            return this.getClass().hashCode() ^ this.maximum.hashCode();
        }
    }

    private static final class LessThanInclusive
    extends InstantInterval {
        private Instant maximum;

        private LessThanInclusive(Instant instant) {
            if (instant == null) {
                throw new NullPointerException("The maximum point must not be null");
            }
            this.maximum = instant;
        }

        @Override
        public Instant getStart() {
            return null;
        }

        @Override
        public boolean isStartUnbounded() {
            return true;
        }

        @Override
        public Instant getEnd() {
            return this.maximum;
        }

        @Override
        public boolean isEndInclusive() {
            return true;
        }

        @Override
        public boolean isBefore(InstantProvider instantProvider) {
            return this.maximum.compareTo(Instant.instant(instantProvider)) < 0;
        }

        @Override
        public boolean isAfter(InstantProvider instantProvider) {
            return false;
        }

        @Override
        public boolean contains(InstantProvider instantProvider) {
            return Instant.instant(instantProvider).compareTo(this.maximum) <= 0;
        }

        @Override
        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object instanceof LessThanInclusive) {
                return this.maximum.equals(((LessThanInclusive)object).maximum);
            }
            return false;
        }

        @Override
        public int hashCode() {
            return this.getClass().hashCode() ^ this.maximum.hashCode();
        }
    }

    private static final class All
    extends InstantInterval {
        private All() {
        }

        @Override
        public boolean isStartInclusive() {
            return true;
        }

        @Override
        public boolean isStartUnbounded() {
            return true;
        }

        @Override
        public boolean isEndInclusive() {
            return true;
        }

        @Override
        public boolean isEndUnbounded() {
            return true;
        }
    }

    private static final class Empty
    extends InstantInterval {
        private Empty() {
        }

        @Override
        public boolean isEmpty() {
            return true;
        }
    }
}

