/*
 * Decompiled with CFR 0.152.
 */
package javax.time.calendar;

import java.io.Serializable;
import javax.time.calendar.DateAdjustor;
import javax.time.calendar.LocalDate;
import javax.time.calendar.field.DayOfMonth;
import javax.time.calendar.field.DayOfWeek;
import javax.time.calendar.field.MonthOfYear;

public final class DateAdjustors {
    private DateAdjustors() {
    }

    public static DateAdjustor lastDayOfMonth() {
        return LastDayOfMonth.INSTANCE;
    }

    public static DateAdjustor lastDayOfYear() {
        return LastDayOfYear.INSTANCE;
    }

    public static DateAdjustor firstInMonth(DayOfWeek dayOfWeek) {
        if (dayOfWeek == null) {
            throw new NullPointerException("DayOfWeek must not be null");
        }
        return new DayOfWeekInMonth(1, dayOfWeek);
    }

    public static DateAdjustor dayOfWeekInMonth(int n, DayOfWeek dayOfWeek) {
        if (n < 1 || n > 5) {
            throw new IllegalArgumentException("Illegal value for ordinal, value " + n + " is not in the range 1 to 5");
        }
        if (dayOfWeek == null) {
            throw new NullPointerException("DayOfWeek must not be null");
        }
        return new DayOfWeekInMonth(n, dayOfWeek);
    }

    public static DateAdjustor nextNonWeekendDay() {
        return NextNonWeekendDay.INSTANCE;
    }

    public static DateAdjustor nextMonday() {
        return new NextOrCurrentDayOfWeek(false, DayOfWeek.MONDAY);
    }

    public static DateAdjustor next(DayOfWeek dayOfWeek) {
        if (dayOfWeek == null) {
            throw new NullPointerException("dow must not be null");
        }
        return new NextOrCurrentDayOfWeek(false, dayOfWeek);
    }

    public static DateAdjustor nextOrCurrent(DayOfWeek dayOfWeek) {
        if (dayOfWeek == null) {
            throw new NullPointerException("dow must not be null");
        }
        return new NextOrCurrentDayOfWeek(true, dayOfWeek);
    }

    private static final class NextOrCurrentDayOfWeek
    implements DateAdjustor,
    Serializable {
        private static final long serialVersionUID = 1L;
        private final boolean currentValid;
        private final DayOfWeek dow;

        private NextOrCurrentDayOfWeek(boolean bl, DayOfWeek dayOfWeek) {
            this.currentValid = bl;
            this.dow = dayOfWeek;
        }

        @Override
        public LocalDate adjustDate(LocalDate localDate) {
            DayOfWeek dayOfWeek = localDate.getDayOfWeek();
            if (this.currentValid && dayOfWeek == this.dow) {
                return localDate;
            }
            int n = dayOfWeek.ordinal() - this.dow.ordinal();
            return localDate.plusDays(n >= 0 ? (long)(7 - n) : (long)(-n));
        }

        public boolean equals(Object object) {
            if (object == null) {
                return false;
            }
            if (this == object) {
                return true;
            }
            if (!(object instanceof NextOrCurrentDayOfWeek)) {
                return false;
            }
            NextOrCurrentDayOfWeek nextOrCurrentDayOfWeek = (NextOrCurrentDayOfWeek)object;
            if (this.currentValid != nextOrCurrentDayOfWeek.currentValid) {
                return false;
            }
            return this.dow == nextOrCurrentDayOfWeek.dow;
        }

        public int hashCode() {
            int n = 13;
            n = 19 * n + (this.currentValid ? 1 : 0);
            n = 19 * n + this.dow.hashCode();
            return n;
        }
    }

    private static class NextNonWeekendDay
    implements DateAdjustor,
    Serializable {
        private static final long serialVersionUID = 1L;
        private static final DateAdjustor INSTANCE = new NextNonWeekendDay();

        private NextNonWeekendDay() {
        }

        private Object readResolve() {
            return INSTANCE;
        }

        @Override
        public LocalDate adjustDate(LocalDate localDate) {
            DayOfWeek dayOfWeek = localDate.getDayOfWeek();
            switch (dayOfWeek) {
                case SATURDAY: {
                    return localDate.plusDays(2L);
                }
                case FRIDAY: {
                    return localDate.plusDays(3L);
                }
            }
            return localDate.plusDays(1L);
        }
    }

    private static final class DayOfWeekInMonth
    implements DateAdjustor,
    Serializable {
        private static final long serialVersionUID = 1L;
        private final int ordinal;
        private final DayOfWeek dayOfWeek;

        private DayOfWeekInMonth(int n, DayOfWeek dayOfWeek) {
            this.ordinal = n;
            this.dayOfWeek = dayOfWeek;
        }

        @Override
        public LocalDate adjustDate(LocalDate localDate) {
            LocalDate localDate2 = localDate.withDayOfMonth(1);
            int n = localDate2.getDayOfWeek().ordinal();
            int n2 = this.dayOfWeek.ordinal();
            int n3 = (n2 - n + 7) % 7;
            return localDate2.plusDays(n3 += (this.ordinal - 1) * 7);
        }

        public boolean equals(Object object) {
            if (object instanceof DayOfWeekInMonth) {
                DayOfWeekInMonth dayOfWeekInMonth = (DayOfWeekInMonth)object;
                return this.ordinal == dayOfWeekInMonth.ordinal && this.dayOfWeek == dayOfWeekInMonth.dayOfWeek;
            }
            return false;
        }

        public int hashCode() {
            return this.ordinal + 8 * this.dayOfWeek.ordinal();
        }
    }

    private static final class LastDayOfYear
    implements DateAdjustor,
    Serializable {
        private static final long serialVersionUID = 1L;
        private static final DateAdjustor INSTANCE = new LastDayOfYear();

        private LastDayOfYear() {
        }

        private Object readResolve() {
            return INSTANCE;
        }

        @Override
        public LocalDate adjustDate(LocalDate localDate) {
            return LocalDate.date(localDate.getYear(), MonthOfYear.DECEMBER, DayOfMonth.dayOfMonth(31));
        }
    }

    private static final class LastDayOfMonth
    implements DateAdjustor,
    Serializable {
        private static final long serialVersionUID = 1L;
        private static final DateAdjustor INSTANCE = new LastDayOfMonth();

        private LastDayOfMonth() {
        }

        private Object readResolve() {
            return INSTANCE;
        }

        @Override
        public LocalDate adjustDate(LocalDate localDate) {
            DayOfMonth dayOfMonth = localDate.getMonthOfYear().getLastDayOfMonth(localDate.getYear());
            return localDate.with((DateAdjustor)((Object)dayOfMonth));
        }
    }
}

