/*
 * Decompiled with CFR 0.152.
 */
package javax.time.calendar.field;

import java.io.Serializable;
import javax.time.calendar.Calendrical;
import javax.time.calendar.DateTimeFieldRule;
import javax.time.calendar.FlexiDateTime;
import javax.time.calendar.IllegalCalendarFieldValueException;
import javax.time.calendar.LocalTime;
import javax.time.calendar.TimeAdjustor;
import javax.time.calendar.TimeMatcher;
import javax.time.calendar.field.HourOfDay;

public enum MeridiemOfDay implements Calendrical,
TimeAdjustor,
TimeMatcher
{
    AM(0),
    PM(1);

    public static final DateTimeFieldRule RULE;
    private final int meridiemOfDay;

    public static MeridiemOfDay meridiemOfDay(int n) {
        switch (n) {
            case 0: {
                return AM;
            }
            case 1: {
                return PM;
            }
        }
        throw new IllegalCalendarFieldValueException(RULE, n, 0, 1);
    }

    private MeridiemOfDay(int n2) {
        this.meridiemOfDay = n2;
    }

    public int getValue() {
        return this.meridiemOfDay;
    }

    public FlexiDateTime toFlexiDateTime() {
        return new FlexiDateTime(RULE, this.getValue());
    }

    public MeridiemOfDay next() {
        return MeridiemOfDay.values()[(this.ordinal() + 1) % 2];
    }

    public MeridiemOfDay previous() {
        return MeridiemOfDay.values()[(this.ordinal() + 2 - 1) % 2];
    }

    public boolean isAm() {
        return this == AM;
    }

    public boolean isPm() {
        return this == PM;
    }

    @Override
    public LocalTime adjustTime(LocalTime localTime) {
        if (this == localTime.getHourOfDay().getAmPm()) {
            return localTime;
        }
        return LocalTime.time(HourOfDay.hourOfDay((MeridiemOfDay)this, (int)localTime.getHourOfDay().getHourOfAmPm()), localTime.getMinuteOfHour(), localTime.getSecondOfMinute(), localTime.getNanoOfSecond());
    }

    @Override
    public boolean matchesTime(LocalTime localTime) {
        return this == localTime.getHourOfDay().getAmPm();
    }

    static {
        RULE = Rule.INSTANCE;
    }

    private static class Rule
    extends DateTimeFieldRule
    implements Serializable {
        private static final DateTimeFieldRule INSTANCE = new Rule();
        private static final long serialVersionUID = 1L;

        private Rule() {
            super("MeridiemOfDay", null, null, 0, 1);
        }

        private Object readResolve() {
            return INSTANCE;
        }

        protected Integer extractValue(FlexiDateTime flexiDateTime) {
            return flexiDateTime.getTime() != null ? Integer.valueOf(flexiDateTime.getTime().getHourOfDay().getAmPm().getValue()) : null;
        }
    }
}

