/*
 * Decompiled with CFR 0.152.
 */
package javax.time.calendar.field;

import javax.time.calendar.Calendrical;
import javax.time.calendar.CalendricalProvider;
import javax.time.calendar.DateMatcher;
import javax.time.calendar.DateProvider;
import javax.time.calendar.DateTimeFieldRule;
import javax.time.calendar.ISOChronology;
import javax.time.calendar.IllegalCalendarFieldValueException;
import javax.time.calendar.LocalDate;

public enum QuarterOfYear implements CalendricalProvider,
DateMatcher
{
    Q1(1),
    Q2(2),
    Q3(3),
    Q4(4);

    private final int quarterOfYear;

    public static DateTimeFieldRule rule() {
        return ISOChronology.quarterOfYearRule();
    }

    public static QuarterOfYear quarterOfYear(int n) {
        switch (n) {
            case 1: {
                return Q1;
            }
            case 2: {
                return Q2;
            }
            case 3: {
                return Q3;
            }
            case 4: {
                return Q4;
            }
        }
        throw new IllegalCalendarFieldValueException(QuarterOfYear.rule(), n, 1, 4);
    }

    public static QuarterOfYear quarterOfYear(DateProvider dateProvider) {
        return LocalDate.date(dateProvider).getMonthOfYear().getQuarterOfYear();
    }

    private QuarterOfYear(int n2) {
        this.quarterOfYear = n2;
    }

    public int getValue() {
        return this.quarterOfYear;
    }

    @Override
    public Calendrical toCalendrical() {
        return new Calendrical(QuarterOfYear.rule(), this.getValue());
    }

    public QuarterOfYear next() {
        return QuarterOfYear.values()[(this.ordinal() + 1) % 4];
    }

    public QuarterOfYear previous() {
        return QuarterOfYear.values()[(this.ordinal() + 4 - 1) % 4];
    }

    @Override
    public boolean matchesDate(LocalDate localDate) {
        return localDate.getMonthOfYear().getQuarterOfYear() == this;
    }

    public String toString() {
        return "QuarterOfYear=" + this.name();
    }
}

