/*
 * Decompiled with CFR 0.152.
 */
package javax.time.calendar.field;

import java.io.Serializable;
import java.util.concurrent.atomic.AtomicReferenceArray;
import javax.time.calendar.Calendrical;
import javax.time.calendar.CalendricalProvider;
import javax.time.calendar.DateTimeFieldRule;
import javax.time.calendar.ISOChronology;
import javax.time.calendar.IllegalCalendarFieldValueException;
import javax.time.calendar.LocalTime;
import javax.time.calendar.TimeAdjuster;
import javax.time.calendar.TimeMatcher;
import javax.time.calendar.TimeProvider;

public final class SecondOfMinute
implements CalendricalProvider,
Comparable<SecondOfMinute>,
TimeAdjuster,
TimeMatcher,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final AtomicReferenceArray<SecondOfMinute> CACHE = new AtomicReferenceArray(60);
    private final int secondOfMinute;

    public static DateTimeFieldRule rule() {
        return ISOChronology.secondOfMinuteRule();
    }

    public static SecondOfMinute secondOfMinute(int n) {
        try {
            SecondOfMinute secondOfMinute = CACHE.get(n);
            if (secondOfMinute == null) {
                SecondOfMinute secondOfMinute2 = new SecondOfMinute(n);
                CACHE.compareAndSet(n, null, secondOfMinute2);
                secondOfMinute = CACHE.get(n);
            }
            return secondOfMinute;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new IllegalCalendarFieldValueException(SecondOfMinute.rule(), n, SecondOfMinute.rule().getMinimumValue(), SecondOfMinute.rule().getMaximumValue());
        }
    }

    public static SecondOfMinute secondOfMinute(TimeProvider timeProvider) {
        return LocalTime.time(timeProvider).toSecondOfMinute();
    }

    private SecondOfMinute(int n) {
        this.secondOfMinute = n;
    }

    private Object readResolve() {
        return SecondOfMinute.secondOfMinute(this.secondOfMinute);
    }

    public int getValue() {
        return this.secondOfMinute;
    }

    @Override
    public LocalTime adjustTime(LocalTime localTime) {
        return localTime.withSecondOfMinute(this.secondOfMinute);
    }

    @Override
    public boolean matchesTime(LocalTime localTime) {
        return this.secondOfMinute == localTime.getSecondOfMinute();
    }

    @Override
    public Calendrical toCalendrical() {
        return new Calendrical(SecondOfMinute.rule(), this.getValue());
    }

    @Override
    public int compareTo(SecondOfMinute secondOfMinute) {
        int n = this.secondOfMinute;
        int n2 = secondOfMinute.secondOfMinute;
        return n < n2 ? -1 : (n == n2 ? 0 : 1);
    }

    public boolean equals(Object object) {
        return this == object;
    }

    public int hashCode() {
        return this.secondOfMinute;
    }

    public String toString() {
        return "SecondOfMinute=" + this.getValue();
    }
}

