/*
 * Decompiled with CFR 0.152.
 */
package javax.time.calendar.field;

import java.io.Serializable;
import javax.time.CalendricalException;
import javax.time.MathUtils;
import javax.time.calendar.Calendrical;
import javax.time.calendar.CalendricalProvider;
import javax.time.calendar.DateAdjuster;
import javax.time.calendar.DateMatcher;
import javax.time.calendar.DateProvider;
import javax.time.calendar.DateResolver;
import javax.time.calendar.DateResolvers;
import javax.time.calendar.DateTimeFieldRule;
import javax.time.calendar.ISOChronology;
import javax.time.calendar.LocalDate;
import javax.time.calendar.MonthDay;
import javax.time.calendar.YearMonth;
import javax.time.calendar.field.MonthOfYear;
import javax.time.period.Period;
import javax.time.period.PeriodProvider;

public final class Year
implements CalendricalProvider,
Comparable<Year>,
Serializable,
DateAdjuster,
DateMatcher {
    public static final int MIN_YEAR = -2147483646;
    public static final int MAX_YEAR = Integer.MAX_VALUE;
    private static final long serialVersionUID = 2751581L;
    private final int year;

    public static DateTimeFieldRule rule() {
        return ISOChronology.yearRule();
    }

    public static Year isoYear(int n) {
        Year.rule().checkValue(n);
        return new Year(n);
    }

    public static Year year(DateProvider dateProvider) {
        return LocalDate.date(dateProvider).toYear();
    }

    private Year(int n) {
        this.year = n;
    }

    public int getValue() {
        return this.year;
    }

    public boolean isSupported(DateTimeFieldRule dateTimeFieldRule) {
        return this.toCalendrical().isDerivable(dateTimeFieldRule);
    }

    public int get(DateTimeFieldRule dateTimeFieldRule) {
        return this.toCalendrical().deriveValue(dateTimeFieldRule);
    }

    public boolean isLeap() {
        return ISOChronology.isLeapYear(this.year);
    }

    public Year next() {
        if (this.year == Integer.MAX_VALUE) {
            throw new CalendricalException("Year is already at the maximum value");
        }
        return Year.isoYear(this.year + 1);
    }

    public Year nextLeap() {
        Year year = this.next();
        while (!year.isLeap()) {
            year = year.next();
        }
        return year;
    }

    public Year previous() {
        if (this.year == -2147483646) {
            throw new CalendricalException("Year is already at the minimum value");
        }
        return Year.isoYear(this.year - 1);
    }

    public Year previousLeap() {
        Year year = this.previous();
        while (!year.isLeap()) {
            year = year.previous();
        }
        return year;
    }

    public Year plus(PeriodProvider periodProvider) {
        Period period = Period.period(periodProvider);
        return this.plusYears(period.getYears());
    }

    public Year plusYears(int n) {
        if (n == 0) {
            return this;
        }
        int n2 = this.year + n;
        if ((this.year ^ n2) < 0 && (this.year ^ n) >= 0 || !Year.rule().isValidValue(n2)) {
            throw new CalendricalException("Addition exceeds the supported year range: " + this.year + " + " + n);
        }
        return Year.isoYear(n2);
    }

    public Year minus(PeriodProvider periodProvider) {
        Period period = Period.period(periodProvider);
        return this.minusYears(period.getYears());
    }

    public Year minusYears(int n) {
        if (n == 0) {
            return this;
        }
        int n2 = this.year - n;
        if ((this.year ^ n2) < 0 && (this.year ^ n) < 0 || !Year.rule().isValidValue(n2)) {
            throw new CalendricalException("Subtraction exceeds the supported year range: " + this.year + " + " + n);
        }
        return Year.isoYear(n2);
    }

    @Override
    public LocalDate adjustDate(LocalDate localDate) {
        return this.adjustDate(localDate, DateResolvers.previousValid());
    }

    public LocalDate adjustDate(LocalDate localDate, DateResolver dateResolver) {
        return localDate.withYear(this.year, dateResolver);
    }

    @Override
    public boolean matchesDate(LocalDate localDate) {
        return localDate.getYear() == this.year;
    }

    public int lengthInDays() {
        return this.isLeap() ? 366 : 365;
    }

    public YearMonth atMonth(MonthOfYear monthOfYear) {
        return YearMonth.yearMonth(this.year, monthOfYear);
    }

    public YearMonth atMonth(int n) {
        return YearMonth.yearMonth(this.year, n);
    }

    public LocalDate atMonthDay(MonthDay monthDay) {
        return LocalDate.date(this.year, monthDay.getMonthOfYear(), monthDay.getDayOfMonth());
    }

    @Override
    public Calendrical toCalendrical() {
        return new Calendrical(Year.rule(), this.getValue());
    }

    @Override
    public int compareTo(Year year) {
        return MathUtils.safeCompare(this.year, year.year);
    }

    public boolean isAfter(Year year) {
        return this.year > year.year;
    }

    public boolean isBefore(Year year) {
        return this.year < year.year;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof Year) {
            return this.year == ((Year)object).year;
        }
        return false;
    }

    public int hashCode() {
        return this.year;
    }

    public String toString() {
        return "Year=" + Integer.toString(this.year);
    }
}

