/*
 * Decompiled with CFR 0.152.
 */
package javax.time.calendar.format;

import java.text.DateFormatSymbols;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.time.calendar.DateTimeFieldRule;
import javax.time.calendar.ISOChronology;
import javax.time.calendar.field.AmPmOfDay;
import javax.time.calendar.field.DayOfWeek;
import javax.time.calendar.field.MonthOfYear;
import javax.time.calendar.format.DateTimeFormatterBuilder;
import javax.time.calendar.format.FormatUtil;

public final class DateTimeFormatSymbols {
    private final Locale locale;
    private final char zeroChar = (char)48;
    private final char positiveSignChar = (char)43;
    private final char negativeSignChar = (char)45;
    private final char decimalPointChar = (char)46;
    private final Map<String, Map<DateTimeFormatterBuilder.TextStyle, TextStore>> textMap;

    public static Locale[] getAvailableLocales() {
        return Locale.getAvailableLocales();
    }

    public static DateTimeFormatSymbols getInstance() {
        return DateTimeFormatSymbols.getInstance(Locale.getDefault());
    }

    public static DateTimeFormatSymbols getInstance(Locale locale) {
        FormatUtil.checkNotNull(locale, "locale");
        DateFormatSymbols dateFormatSymbols = new DateFormatSymbols(locale);
        return new DateTimeFormatSymbols(locale, dateFormatSymbols);
    }

    private DateTimeFormatSymbols(Locale locale) {
        FormatUtil.checkNotNull(locale, "locale");
        this.locale = locale;
        this.textMap = new HashMap<String, Map<DateTimeFormatterBuilder.TextStyle, TextStore>>();
    }

    private DateTimeFormatSymbols(Locale locale, DateFormatSymbols dateFormatSymbols) {
        this(locale);
        FormatUtil.checkNotNull(dateFormatSymbols, "symbols to convert");
        HashMap<Integer, String> hashMap = new HashMap<Integer, String>();
        String[] stringArray = null;
        String string = null;
        string = ISOChronology.monthOfYearRule().getID();
        this.textMap.put(string, new HashMap());
        hashMap.clear();
        stringArray = dateFormatSymbols.getMonths();
        hashMap.put(MonthOfYear.JANUARY.getValue(), stringArray[0]);
        hashMap.put(MonthOfYear.FEBRUARY.getValue(), stringArray[1]);
        hashMap.put(MonthOfYear.MARCH.getValue(), stringArray[2]);
        hashMap.put(MonthOfYear.APRIL.getValue(), stringArray[3]);
        hashMap.put(MonthOfYear.MAY.getValue(), stringArray[4]);
        hashMap.put(MonthOfYear.JUNE.getValue(), stringArray[5]);
        hashMap.put(MonthOfYear.JULY.getValue(), stringArray[6]);
        hashMap.put(MonthOfYear.AUGUST.getValue(), stringArray[7]);
        hashMap.put(MonthOfYear.SEPTEMBER.getValue(), stringArray[8]);
        hashMap.put(MonthOfYear.OCTOBER.getValue(), stringArray[9]);
        hashMap.put(MonthOfYear.NOVEMBER.getValue(), stringArray[10]);
        hashMap.put(MonthOfYear.DECEMBER.getValue(), stringArray[11]);
        this.textMap.get(string).put(DateTimeFormatterBuilder.TextStyle.FULL, new TextStore(hashMap));
        hashMap.clear();
        stringArray = dateFormatSymbols.getShortMonths();
        hashMap.put(MonthOfYear.JANUARY.getValue(), stringArray[0]);
        hashMap.put(MonthOfYear.FEBRUARY.getValue(), stringArray[1]);
        hashMap.put(MonthOfYear.MARCH.getValue(), stringArray[2]);
        hashMap.put(MonthOfYear.APRIL.getValue(), stringArray[3]);
        hashMap.put(MonthOfYear.MAY.getValue(), stringArray[4]);
        hashMap.put(MonthOfYear.JUNE.getValue(), stringArray[5]);
        hashMap.put(MonthOfYear.JULY.getValue(), stringArray[6]);
        hashMap.put(MonthOfYear.AUGUST.getValue(), stringArray[7]);
        hashMap.put(MonthOfYear.SEPTEMBER.getValue(), stringArray[8]);
        hashMap.put(MonthOfYear.OCTOBER.getValue(), stringArray[9]);
        hashMap.put(MonthOfYear.NOVEMBER.getValue(), stringArray[10]);
        hashMap.put(MonthOfYear.DECEMBER.getValue(), stringArray[11]);
        this.textMap.get(string).put(DateTimeFormatterBuilder.TextStyle.SHORT, new TextStore(hashMap));
        string = ISOChronology.dayOfWeekRule().getID();
        this.textMap.put(string, new HashMap());
        hashMap.clear();
        stringArray = dateFormatSymbols.getWeekdays();
        hashMap.put(DayOfWeek.MONDAY.getValue(), stringArray[2]);
        hashMap.put(DayOfWeek.TUESDAY.getValue(), stringArray[3]);
        hashMap.put(DayOfWeek.WEDNESDAY.getValue(), stringArray[4]);
        hashMap.put(DayOfWeek.THURSDAY.getValue(), stringArray[5]);
        hashMap.put(DayOfWeek.FRIDAY.getValue(), stringArray[6]);
        hashMap.put(DayOfWeek.SATURDAY.getValue(), stringArray[7]);
        hashMap.put(DayOfWeek.SUNDAY.getValue(), stringArray[1]);
        this.textMap.get(string).put(DateTimeFormatterBuilder.TextStyle.FULL, new TextStore(hashMap));
        hashMap.clear();
        stringArray = dateFormatSymbols.getShortWeekdays();
        hashMap.put(DayOfWeek.MONDAY.getValue(), stringArray[2]);
        hashMap.put(DayOfWeek.TUESDAY.getValue(), stringArray[3]);
        hashMap.put(DayOfWeek.WEDNESDAY.getValue(), stringArray[4]);
        hashMap.put(DayOfWeek.THURSDAY.getValue(), stringArray[5]);
        hashMap.put(DayOfWeek.FRIDAY.getValue(), stringArray[6]);
        hashMap.put(DayOfWeek.SATURDAY.getValue(), stringArray[7]);
        hashMap.put(DayOfWeek.SUNDAY.getValue(), stringArray[1]);
        this.textMap.get(string).put(DateTimeFormatterBuilder.TextStyle.SHORT, new TextStore(hashMap));
        string = ISOChronology.amPmOfDayRule().getID();
        this.textMap.put(string, new HashMap());
        hashMap.clear();
        stringArray = dateFormatSymbols.getAmPmStrings();
        hashMap.put(AmPmOfDay.AM.getValue(), stringArray[0]);
        hashMap.put(AmPmOfDay.PM.getValue(), stringArray[1]);
        this.textMap.get(string).put(DateTimeFormatterBuilder.TextStyle.FULL, new TextStore(hashMap));
        this.textMap.get(string).put(DateTimeFormatterBuilder.TextStyle.SHORT, new TextStore(hashMap));
    }

    public Locale getLocale() {
        return this.locale;
    }

    public char getZeroChar() {
        return '0';
    }

    public char getDigitChar(int n) {
        return (char)(n + 48);
    }

    public int convertToDigit(char c) {
        int n = c - 48;
        return n >= 0 && n <= 9 ? n : -1;
    }

    public char getPositiveSignChar() {
        return '+';
    }

    public char getNegativeSignChar() {
        return '-';
    }

    public char getDecimalPointChar() {
        return '.';
    }

    public Map<Integer, String> getFieldValueTextMap(DateTimeFieldRule dateTimeFieldRule, DateTimeFormatterBuilder.TextStyle textStyle) {
        TextStore textStore = this.getTextStore(dateTimeFieldRule, textStyle);
        return textStore == null ? null : textStore.valueTextMap;
    }

    public String getFieldValueText(DateTimeFieldRule dateTimeFieldRule, DateTimeFormatterBuilder.TextStyle textStyle, int n) {
        Map<Integer, String> map = this.getFieldValueTextMap(dateTimeFieldRule, textStyle);
        return map == null ? null : map.get(n);
    }

    public Map<String, Integer> getFieldTextValueMap(DateTimeFieldRule dateTimeFieldRule, DateTimeFormatterBuilder.TextStyle textStyle) {
        TextStore textStore = this.getTextStore(dateTimeFieldRule, textStyle);
        return textStore == null ? null : textStore.textValueMap;
    }

    public int[] matchFieldText(DateTimeFieldRule dateTimeFieldRule, DateTimeFormatterBuilder.TextStyle textStyle, boolean bl, String string) {
        TextStore textStore = this.getTextStore(dateTimeFieldRule, textStyle);
        FormatUtil.checkNotNull(string, "search text");
        if (textStore == null) {
            return null;
        }
        if (bl) {
            Integer n;
            int n2;
            int n3 = textStore.insensitiveMaxLength;
            Map map = textStore.insensitiveTextValueMap;
            string = string.toUpperCase(this.locale);
            for (n2 = Math.min(n3, string.length()); n2 > 0; --n2) {
                n = (Integer)map.get(string.substring(0, n2));
                if (n == null) continue;
                return new int[]{n2, n};
            }
            string = string.toLowerCase(this.locale);
            for (n2 = Math.min(n3, string.length()); n2 > 0; --n2) {
                n = (Integer)map.get(string.substring(0, n2));
                if (n == null) continue;
                return new int[]{n2, n};
            }
        } else {
            int n = textStore.maxLength;
            Map map = textStore.textValueMap;
            for (int i = Math.min(n, string.length()); i > 0; --i) {
                Integer n4 = (Integer)map.get(string.substring(0, i));
                if (n4 == null) continue;
                return new int[]{i, n4};
            }
        }
        return new int[]{0, 0};
    }

    private TextStore getTextStore(DateTimeFieldRule dateTimeFieldRule, DateTimeFormatterBuilder.TextStyle textStyle) {
        FormatUtil.checkNotNull(dateTimeFieldRule, "field rule");
        FormatUtil.checkNotNull((Object)textStyle, "text style");
        String string = dateTimeFieldRule.getID();
        Map<DateTimeFormatterBuilder.TextStyle, TextStore> map = this.textMap.get(string);
        return map == null ? null : map.get((Object)textStyle);
    }

    private class TextStore {
        private final Map<Integer, String> valueTextMap;
        private final Map<String, Integer> textValueMap;
        private final int maxLength;
        private final Map<String, Integer> insensitiveTextValueMap;
        private final int insensitiveMaxLength;

        private TextStore(Map<Integer, String> map) {
            FormatUtil.checkNotNull(map, "text map");
            if (map.containsKey(null) || map.containsValue(null) || map.containsValue("")) {
                throw new IllegalArgumentException("The map must not contain null or empty text");
            }
            HashMap<Integer, String> hashMap = new HashMap<Integer, String>(map);
            HashMap<String, Integer> hashMap2 = new HashMap<String, Integer>();
            int n = 0;
            HashMap<String, Integer> hashMap3 = new HashMap<String, Integer>();
            int n2 = 0;
            for (Map.Entry entry : hashMap.entrySet()) {
                String string = (String)entry.getValue();
                Integer n3 = (Integer)entry.getKey();
                hashMap2.put(string, n3);
                n = Math.max(n, string.length());
                hashMap3.put(string.toLowerCase(DateTimeFormatSymbols.this.locale), n3);
                hashMap3.put(string.toUpperCase(DateTimeFormatSymbols.this.locale), n3);
                n2 = Math.max(n, string.length());
            }
            if (hashMap2.size() < hashMap.size()) {
                this.textValueMap = null;
                n = 0;
                this.insensitiveTextValueMap = null;
                n2 = 0;
            } else {
                this.textValueMap = Collections.unmodifiableMap(hashMap2);
                this.insensitiveTextValueMap = Collections.unmodifiableMap(hashMap3);
            }
            this.valueTextMap = Collections.unmodifiableMap(hashMap);
            this.maxLength = n;
            this.insensitiveMaxLength = n2;
        }
    }
}

