/*
 * Decompiled with CFR 0.152.
 */
package javax.time.calendar.format;

import java.io.IOException;
import java.util.Locale;
import javax.time.calendar.DateTimeFieldRule;
import javax.time.calendar.FlexiDateTime;
import javax.time.calendar.format.CalendricalFormatFieldException;
import javax.time.calendar.format.DateTimeFormatterBuilder;
import javax.time.calendar.format.DateTimePrinter;

class NumberPrinter
implements DateTimePrinter {
    private final DateTimeFieldRule fieldRule;
    private final int minWidth;
    private final int maxWidth;
    private final char padChar;
    private final boolean padOnLeft;
    private final DateTimeFormatterBuilder.SignStyle signStyle;

    public NumberPrinter(DateTimeFieldRule dateTimeFieldRule) {
        this(dateTimeFieldRule, 0, Integer.MAX_VALUE, '0', true, DateTimeFormatterBuilder.SignStyle.NORMAL);
    }

    NumberPrinter(DateTimeFieldRule dateTimeFieldRule, int n, int n2, char c, boolean bl, DateTimeFormatterBuilder.SignStyle signStyle) {
        this.fieldRule = dateTimeFieldRule;
        this.minWidth = n;
        this.maxWidth = n2;
        this.padChar = c;
        this.padOnLeft = bl;
        this.signStyle = signStyle;
    }

    public void print(Appendable appendable, FlexiDateTime flexiDateTime, Locale locale) throws IOException {
        int n = flexiDateTime.getRawValue(this.fieldRule);
        String string = Integer.toString(Math.abs(n));
        if (string.length() > this.maxWidth) {
            throw new CalendricalFormatFieldException(this.fieldRule, n, this.maxWidth);
        }
        this.signStyle.print(appendable, this.fieldRule, n, this.minWidth);
        if (this.padOnLeft) {
            for (int i = 0; i < this.minWidth - string.length(); ++i) {
                appendable.append(this.padChar);
            }
            appendable.append(string);
        } else {
            appendable.append(string);
            for (int i = 0; i < this.minWidth - string.length(); ++i) {
                appendable.append(this.padChar);
            }
        }
    }
}

