/*
 * Decompiled with CFR 0.152.
 */
package javax.time.calendar.format;

import java.io.IOException;
import javax.time.calendar.Calendrical;
import javax.time.calendar.format.CalendricalFormatException;
import javax.time.calendar.format.DateTimeFormatSymbols;
import javax.time.calendar.format.DateTimeParseContext;
import javax.time.calendar.format.DateTimeParser;
import javax.time.calendar.format.DateTimePrinter;

class PadPrinterParserDecorator
implements DateTimePrinter,
DateTimeParser {
    private final DateTimePrinter printer;
    private final DateTimeParser parser;
    private final int padWidth;
    private final char padChar;

    PadPrinterParserDecorator(DateTimePrinter dateTimePrinter, DateTimeParser dateTimeParser, int n, char c) {
        this.printer = dateTimePrinter;
        this.parser = dateTimeParser;
        this.padWidth = n;
        this.padChar = c;
    }

    @Override
    public void print(Calendrical calendrical, Appendable appendable, DateTimeFormatSymbols dateTimeFormatSymbols) throws IOException {
        StringBuilder stringBuilder = new StringBuilder(32);
        this.printer.print(calendrical, stringBuilder, dateTimeFormatSymbols);
        int n = stringBuilder.length();
        if (n > this.padWidth) {
            throw new CalendricalFormatException("Output of " + n + " characters exceeds pad width of " + this.padWidth);
        }
        for (int i = 0; i < this.padWidth - n; ++i) {
            appendable.append(this.padChar);
        }
        appendable.append(stringBuilder);
    }

    @Override
    public boolean isPrintDataAvailable(Calendrical calendrical) {
        return this.printer.isPrintDataAvailable(calendrical);
    }

    @Override
    public int parse(DateTimeParseContext dateTimeParseContext, String string, int n) {
        int n2;
        if (n > string.length()) {
            throw new IndexOutOfBoundsException();
        }
        int n3 = n + this.padWidth;
        if (n3 > string.length()) {
            return ~n;
        }
        for (n2 = n; n2 < n3 && string.charAt(n2) == this.padChar; ++n2) {
        }
        string = string.substring(0, n3);
        int n4 = 0;
        while (n2 >= n) {
            int n5 = this.parser.parse(dateTimeParseContext, string, n2);
            if (n5 < 0) {
                if (n4 == 0) {
                    n4 = n5;
                }
                --n2;
                continue;
            }
            if (n5 != n3) {
                return ~n;
            }
            return n5;
        }
        return n4;
    }

    public String toString() {
        return "Pad(" + (this.printer == null ? "" : this.printer) + "," + (this.parser == null ? "" : this.parser) + "," + this.padWidth + (this.padChar == ' ' ? ")" : ",'" + this.padChar + "')");
    }
}

