/*
 * Decompiled with CFR 0.152.
 */
package javax.time.calendar.format;

import java.io.IOException;
import java.util.Locale;
import javax.time.calendar.DateTimeFieldRule;
import javax.time.calendar.FlexiDateTime;
import javax.time.calendar.format.CalendricalFormatFieldException;
import javax.time.calendar.format.DateTimeFormatterBuilder;
import javax.time.calendar.format.DateTimeParseContext;
import javax.time.calendar.format.DateTimePrinter;

class SimpleNumberPrinterParser
implements DateTimePrinter {
    private final DateTimeFieldRule fieldRule;
    private final int minWidth;
    private final int maxWidth;
    private final DateTimeFormatterBuilder.SignStyle signStyle;

    SimpleNumberPrinterParser(DateTimeFieldRule dateTimeFieldRule, int n, int n2, DateTimeFormatterBuilder.SignStyle signStyle) {
        this.fieldRule = dateTimeFieldRule;
        this.minWidth = n;
        this.maxWidth = n2;
        this.signStyle = signStyle;
    }

    public void print(Appendable appendable, FlexiDateTime flexiDateTime, Locale locale) throws IOException {
        String string;
        int n = flexiDateTime.getRawValue(this.fieldRule);
        String string2 = string = n == Integer.MIN_VALUE ? Long.toString(Math.abs((long)n)) : Integer.toString(Math.abs(n));
        if (string.length() > this.maxWidth) {
            throw new CalendricalFormatFieldException(this.fieldRule, n, this.maxWidth);
        }
        this.signStyle.print(appendable, this.fieldRule, n, this.minWidth);
        for (int i = 0; i < this.minWidth - string.length(); ++i) {
            appendable.append('0');
        }
        appendable.append(string);
    }

    public int parse(DateTimeParseContext dateTimeParseContext, String string, int n) {
        int n2;
        char c;
        char c2;
        int n3;
        block14: {
            block13: {
                n3 = string.length();
                if (n == n3) {
                    return ~n;
                }
                c2 = string.charAt(n);
                if (c2 != '+') break block13;
                switch (this.signStyle) {
                    case ALWAYS: 
                    case EXCEEDS_PAD: {
                        ++n;
                        break block14;
                    }
                    default: {
                        return ~n;
                    }
                }
            }
            if (c2 == '-') {
                switch (this.signStyle) {
                    case ALWAYS: 
                    case EXCEEDS_PAD: 
                    case NORMAL: {
                        ++n;
                        break;
                    }
                    default: {
                        return ~n;
                    }
                }
            }
        }
        int n4 = n + this.minWidth;
        if (n4 > n3) {
            return ~n;
        }
        int n5 = 0;
        while (n < n4) {
            if ((c = dateTimeParseContext.digit((char)(n2 = string.charAt(n++)))) < '\u0000') {
                return ~(n - 1);
            }
            n5 *= 10;
            n5 += c;
        }
        n2 = Math.max(n + this.maxWidth, n3);
        while (n < n2) {
            int n6;
            if ((n6 = dateTimeParseContext.digit(c = (char)string.charAt(n++))) < 0) {
                --n;
                break;
            }
            n5 *= 10;
            n5 += n6;
        }
        n5 = c2 == '-' ? -n5 : n5;
        dateTimeParseContext.setFieldValue(this.fieldRule, n5);
        return n;
    }
}

