/*
 * Decompiled with CFR 0.152.
 */
package javax.time.calendar.format;

import java.io.IOException;
import javax.time.calendar.Calendrical;
import javax.time.calendar.ZoneOffset;
import javax.time.calendar.format.CalendricalFormatException;
import javax.time.calendar.format.DateTimeFormatSymbols;
import javax.time.calendar.format.DateTimeParseContext;
import javax.time.calendar.format.DateTimeParser;
import javax.time.calendar.format.DateTimePrinter;

class ZoneOffsetPrinterParser
implements DateTimePrinter,
DateTimeParser {
    private final String utcText;
    private final boolean includeColon;
    private final boolean allowSeconds;

    ZoneOffsetPrinterParser(String string, boolean bl, boolean bl2) {
        this.utcText = string;
        this.includeColon = bl;
        this.allowSeconds = bl2;
    }

    @Override
    public void print(Calendrical calendrical, Appendable appendable, DateTimeFormatSymbols dateTimeFormatSymbols) throws IOException {
        ZoneOffset zoneOffset = calendrical.getOffset();
        if (zoneOffset == null) {
            throw new CalendricalFormatException("Unable to print ZoneOffset");
        }
        int n = zoneOffset.getAmountSeconds();
        if (n == 0) {
            appendable.append(this.utcText);
        } else if (this.includeColon && (this.allowSeconds || zoneOffset.getSecondsField() == 0)) {
            appendable.append(zoneOffset.getID());
        } else {
            int n2 = Math.abs(zoneOffset.getHoursField());
            int n3 = Math.abs(zoneOffset.getMinutesField());
            int n4 = Math.abs(zoneOffset.getSecondsField());
            appendable.append(n < 0 ? "-" : "+").append((char)(n2 / 10 + 48)).append((char)(n2 % 10 + 48)).append(this.includeColon ? ":" : "").append((char)(n3 / 10 + 48)).append((char)(n3 % 10 + 48));
            if (this.allowSeconds && n4 > 0) {
                appendable.append(this.includeColon ? ":" : "").append((char)(n4 / 10 + 48)).append((char)(n4 % 10 + 48));
            }
        }
    }

    @Override
    public boolean isPrintDataAvailable(Calendrical calendrical) {
        return calendrical.getOffset() != null;
    }

    @Override
    public int parse(DateTimeParseContext dateTimeParseContext, String string, int n) {
        char c;
        ZoneOffset zoneOffset = null;
        int n2 = string.length();
        int n3 = this.utcText.length();
        if (n3 == 0) {
            if (n == n2) {
                dateTimeParseContext.setOffset(ZoneOffset.UTC);
                return n;
            }
        } else {
            if (n == n2) {
                return ~n;
            }
            if (string.regionMatches(false, n, this.utcText, 0, n3)) {
                dateTimeParseContext.setOffset(ZoneOffset.UTC);
                return n + n3;
            }
        }
        if ((c = string.charAt(n)) == '+' || c == '-') {
            int n4 = c == '-' ? -1 : 1;
            int[] nArray = new int[4];
            nArray[0] = n + 1;
            if (this.parseNumber(nArray, 1, string, true) || this.parseNumber(nArray, 2, string, true) || this.parseNumber(nArray, 3, string, false)) {
                return ~n;
            }
            int n5 = nArray[1] * 60 * 60 + nArray[2] * 60 + nArray[3];
            if (n5 > 64800) {
                return ~n;
            }
            zoneOffset = ZoneOffset.zoneOffset(n4 * nArray[1], n4 * nArray[2], n4 * nArray[3]);
            dateTimeParseContext.setOffset(zoneOffset);
            return nArray[0];
        }
        if (n3 == 0) {
            dateTimeParseContext.setOffset(ZoneOffset.UTC);
            return n + n3;
        }
        return ~n;
    }

    private boolean parseNumber(int[] nArray, int n, String string, boolean bl) {
        if (!this.allowSeconds && n == 3) {
            return false;
        }
        int n2 = nArray[0];
        if (this.includeColon && n > 1) {
            if (n2 + 1 > string.length() || string.charAt(n2) != ':') {
                return bl;
            }
            ++n2;
        }
        if (n2 + 2 > string.length()) {
            return bl;
        }
        char c = string.charAt(n2++);
        char c2 = string.charAt(n2++);
        if (c < '0' || c > '9' || c2 < '0' || c2 > '9') {
            return bl;
        }
        int n3 = (c - 48) * 10 + (c2 - 48);
        if (n3 < 0 || n3 > 59) {
            return bl;
        }
        nArray[n] = n3;
        nArray[0] = n2;
        return false;
    }

    public String toString() {
        if (this.utcText.equals("Z") && this.includeColon && this.allowSeconds) {
            return "OffsetId()";
        }
        String string = this.utcText.replace("'", "''");
        return "Offset('" + string + "'," + this.includeColon + "," + this.allowSeconds + ")";
    }
}

