/*
 * Decompiled with CFR 0.152.
 */
package javax.time.calendar.format;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.time.calendar.Calendrical;
import javax.time.calendar.TimeZone;
import javax.time.calendar.format.CalendricalFormatException;
import javax.time.calendar.format.DateTimeFormatSymbols;
import javax.time.calendar.format.DateTimeFormatterBuilder;
import javax.time.calendar.format.DateTimeParseContext;
import javax.time.calendar.format.DateTimeParser;
import javax.time.calendar.format.DateTimePrinter;
import javax.time.calendar.format.ZoneOffsetPrinterParser;
import javax.time.calendar.zone.ZoneRulesGroup;

class ZonePrinterParser
implements DateTimePrinter,
DateTimeParser {
    private final DateTimeFormatterBuilder.TextStyle textStyle;
    private static SubstringTree preparedTree;
    private static Set<String> preparedIDs;

    ZonePrinterParser() {
        this.textStyle = null;
    }

    ZonePrinterParser(DateTimeFormatterBuilder.TextStyle textStyle) {
        this.textStyle = textStyle;
    }

    @Override
    public void print(Calendrical calendrical, Appendable appendable, DateTimeFormatSymbols dateTimeFormatSymbols) throws IOException {
        TimeZone timeZone = calendrical.getZone();
        if (timeZone == null) {
            throw new CalendricalFormatException("Unable to print TimeZone");
        }
        if (this.textStyle == null) {
            appendable.append(timeZone.getID());
        } else if (this.textStyle == DateTimeFormatterBuilder.TextStyle.FULL) {
            appendable.append(timeZone.getName());
        } else {
            appendable.append(timeZone.getShortName());
        }
    }

    @Override
    public boolean isPrintDataAvailable(Calendrical calendrical) {
        return calendrical.getZone() != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int parse(DateTimeParseContext dateTimeParseContext, String string, int n) {
        int n2 = string.length();
        if (n > n2) {
            throw new IndexOutOfBoundsException();
        }
        Set<String> set = ZoneRulesGroup.getParsableIDs();
        if (set.size() == 0) {
            return ~n;
        }
        Object object = ZonePrinterParser.class;
        synchronized (ZonePrinterParser.class) {
            int n3;
            if (preparedTree == null || preparedIDs.size() < set.size()) {
                set = new HashSet<String>(set);
                preparedTree = ZonePrinterParser.prepareParser(set);
                preparedIDs = set;
            }
            SubstringTree substringTree = preparedTree;
            // ** MonitorExit[var7_6] (shouldn't be in output)
            if (string.substring(n).startsWith("UTC")) {
                int n4;
                object = new DateTimeParseContext(dateTimeParseContext.getSymbols());
                int n5 = new ZoneOffsetPrinterParser("", true, true).parse((DateTimeParseContext)object, string, n4 = n + 3);
                if (n5 < 0) {
                    dateTimeParseContext.setZone(TimeZone.UTC);
                    return n4;
                }
                dateTimeParseContext.setZone(TimeZone.timeZone(((DateTimeParseContext)object).getOffset()));
                return n5;
            }
            object = null;
            int n6 = 0;
            while (substringTree != null && n + (n3 = substringTree.length) <= n2) {
                object = string.substring(n, n + n3);
                substringTree = substringTree.get((String)object);
                ++n6;
            }
            if (object != null && preparedIDs.contains(object)) {
                TimeZone timeZone = TimeZone.timeZone((String)object);
                dateTimeParseContext.setZone(timeZone);
                return n + ((String)object).length();
            }
            return ~n;
        }
    }

    private static SubstringTree prepareParser(Set<String> set) {
        ArrayList<String> arrayList = new ArrayList<String>(set);
        Collections.sort(arrayList, new Comparator<String>(){

            @Override
            public int compare(String string, String string2) {
                return string.length() == string2.length() ? string.compareTo(string2) : string.length() - string2.length();
            }
        });
        SubstringTree substringTree = new SubstringTree(((String)arrayList.get(0)).length());
        for (String string : arrayList) {
            substringTree.add(string);
        }
        return substringTree;
    }

    public String toString() {
        if (this.textStyle == null) {
            return "ZoneId()";
        }
        return "ZoneText(" + (Object)((Object)this.textStyle) + ")";
    }

    private static class SubstringTree {
        final int length;
        private final Map<String, SubstringTree> substringMap = new HashMap<String, SubstringTree>();

        private SubstringTree(int n) {
            this.length = n;
        }

        private SubstringTree get(String string) {
            return this.substringMap.get(string);
        }

        private void add(String string) {
            int n = string.length();
            if (n == this.length) {
                this.substringMap.put(string, null);
            } else if (n > this.length) {
                String string2 = string.substring(0, this.length);
                SubstringTree substringTree = this.substringMap.get(string2);
                if (substringTree == null) {
                    substringTree = new SubstringTree(n);
                    this.substringMap.put(string2, substringTree);
                }
                substringTree.add(string);
            }
        }
    }
}

