/*
 * Decompiled with CFR 0.152.
 */
package javax.time.calendar.zone;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.time.Instant;
import javax.time.InstantProvider;
import javax.time.calendar.LocalDateTime;
import javax.time.calendar.OffsetDateTime;
import javax.time.calendar.ZoneOffset;
import javax.time.calendar.field.Year;
import javax.time.calendar.zone.ZoneOffsetTransition;
import javax.time.calendar.zone.ZoneOffsetTransitionRule;
import javax.time.calendar.zone.ZoneRules;

final class StandardZoneRules
extends ZoneRules
implements Serializable {
    private static final long serialVersionUID = 224698619L;
    private static final Year LAST_CACHED_YEAR = Year.isoYear(2100);
    private final long[] standardTransitions;
    private final ZoneOffset[] standardOffsets;
    private final long[] savingsInstantTransitions;
    private final LocalDateTime[] savingsLocalTransitions;
    private final ZoneOffset[] wallOffsets;
    private final ZoneOffsetTransitionRule[] lastRules;
    private volatile transient ConcurrentMap<Year, ZoneOffsetTransition[]> lastRulesCache = new ConcurrentHashMap<Year, ZoneOffsetTransition[]>();

    StandardZoneRules(ZoneOffset zoneOffset, ZoneOffset zoneOffset2, List<OffsetDateTime> list, List<ZoneOffsetTransition> list2, List<ZoneOffsetTransitionRule> list3) {
        this.standardTransitions = new long[list.size()];
        this.standardOffsets = new ZoneOffset[list.size() + 1];
        this.standardOffsets[0] = zoneOffset;
        for (int i = 0; i < list.size(); ++i) {
            this.standardTransitions[i] = list.get(i).toEpochSeconds();
            this.standardOffsets[i + 1] = list.get(i).getOffset();
        }
        ArrayList<LocalDateTime> arrayList = new ArrayList<LocalDateTime>();
        ArrayList<ZoneOffset> arrayList2 = new ArrayList<ZoneOffset>();
        arrayList2.add(zoneOffset2);
        for (ZoneOffsetTransition zoneOffsetTransition : list2) {
            if (zoneOffsetTransition.isGap()) {
                arrayList.add(zoneOffsetTransition.getDateTime().toLocalDateTime());
                arrayList.add(zoneOffsetTransition.getDateTimeAfter().toLocalDateTime());
            } else {
                arrayList.add(zoneOffsetTransition.getDateTimeAfter().toLocalDateTime());
                arrayList.add(zoneOffsetTransition.getDateTime().toLocalDateTime());
            }
            arrayList2.add(zoneOffsetTransition.getOffsetAfter());
        }
        this.savingsLocalTransitions = arrayList.toArray(new LocalDateTime[arrayList.size()]);
        this.wallOffsets = arrayList2.toArray(new ZoneOffset[arrayList2.size()]);
        this.savingsInstantTransitions = new long[list2.size()];
        for (int i = 0; i < list2.size(); ++i) {
            this.savingsInstantTransitions[i] = list2.get(i).getInstant().getEpochSeconds();
        }
        this.lastRules = list3.toArray(new ZoneOffsetTransitionRule[list3.size()]);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.lastRulesCache = new ConcurrentHashMap<Year, ZoneOffsetTransition[]>();
    }

    @Override
    public ZoneOffset getOffset(InstantProvider instantProvider) {
        Instant instant = Instant.instant(instantProvider);
        long l = instant.getEpochSeconds();
        if (this.lastRules.length > 0 && l > this.savingsInstantTransitions[this.savingsInstantTransitions.length - 1]) {
            OffsetDateTime offsetDateTime = OffsetDateTime.fromInstant(instant, this.wallOffsets[this.wallOffsets.length - 1]);
            ZoneOffsetTransition[] zoneOffsetTransitionArray = this.findTransitionArray(offsetDateTime.toYear());
            ZoneOffsetTransition zoneOffsetTransition = null;
            for (int i = 0; i < zoneOffsetTransitionArray.length; ++i) {
                zoneOffsetTransition = zoneOffsetTransitionArray[i];
                if (!instant.isBefore(zoneOffsetTransition.getInstant())) continue;
                return zoneOffsetTransition.getOffsetBefore();
            }
            return zoneOffsetTransition.getOffsetAfter();
        }
        int n = Arrays.binarySearch(this.savingsInstantTransitions, l);
        if (n < 0) {
            n = -n - 2;
        }
        return this.wallOffsets[n + 1];
    }

    @Override
    public ZoneRules.OffsetInfo getOffsetInfo(LocalDateTime localDateTime) {
        if (this.lastRules.length > 0 && localDateTime.isAfter(this.savingsLocalTransitions[this.savingsLocalTransitions.length - 1])) {
            ZoneOffsetTransition[] zoneOffsetTransitionArray = this.findTransitionArray(localDateTime.toYear());
            ZoneRules.OffsetInfo offsetInfo = null;
            for (ZoneOffsetTransition zoneOffsetTransition : zoneOffsetTransitionArray) {
                offsetInfo = this.findOffsetInfo(localDateTime, zoneOffsetTransition);
                if (!offsetInfo.isDiscontinuity() && !offsetInfo.getOffset().equals(zoneOffsetTransition.getOffsetBefore())) continue;
                return offsetInfo;
            }
            return offsetInfo;
        }
        int n = Arrays.binarySearch(this.savingsLocalTransitions, localDateTime);
        if (n == -1) {
            return this.createOffsetInfo(localDateTime, this.wallOffsets[0]);
        }
        if (n < 0) {
            n = -n - 2;
        } else if (n < this.savingsLocalTransitions.length - 1 && this.savingsLocalTransitions[n].equals(this.savingsLocalTransitions[n + 1])) {
            ++n;
        }
        if ((n & 1) == 0) {
            LocalDateTime localDateTime2 = this.savingsLocalTransitions[n];
            LocalDateTime localDateTime3 = this.savingsLocalTransitions[n + 1];
            ZoneOffset zoneOffset = this.wallOffsets[n / 2];
            ZoneOffset zoneOffset2 = this.wallOffsets[n / 2 + 1];
            if (zoneOffset2.getAmountSeconds() > zoneOffset.getAmountSeconds()) {
                return this.createOffsetInfo(localDateTime, OffsetDateTime.dateTime(localDateTime2, zoneOffset), zoneOffset2);
            }
            return this.createOffsetInfo(localDateTime, OffsetDateTime.dateTime(localDateTime3, zoneOffset), zoneOffset2);
        }
        return this.createOffsetInfo(localDateTime, this.wallOffsets[n / 2 + 1]);
    }

    private ZoneRules.OffsetInfo findOffsetInfo(LocalDateTime localDateTime, ZoneOffsetTransition zoneOffsetTransition) {
        if (zoneOffsetTransition.isGap()) {
            if (localDateTime.isBefore(zoneOffsetTransition.getLocal())) {
                return this.createOffsetInfo(localDateTime, zoneOffsetTransition.getOffsetBefore());
            }
            if (localDateTime.isBefore(zoneOffsetTransition.getDateTimeAfter().toLocalDateTime())) {
                return this.createOffsetInfo(localDateTime, zoneOffsetTransition.getDateTime(), zoneOffsetTransition.getOffsetAfter());
            }
            return this.createOffsetInfo(localDateTime, zoneOffsetTransition.getOffsetAfter());
        }
        if (!localDateTime.isBefore(zoneOffsetTransition.getLocal())) {
            return this.createOffsetInfo(localDateTime, zoneOffsetTransition.getOffsetAfter());
        }
        if (localDateTime.isBefore(zoneOffsetTransition.getDateTimeAfter().toLocalDateTime())) {
            return this.createOffsetInfo(localDateTime, zoneOffsetTransition.getOffsetBefore());
        }
        return this.createOffsetInfo(localDateTime, zoneOffsetTransition.getDateTime(), zoneOffsetTransition.getOffsetAfter());
    }

    private ZoneOffsetTransition[] findTransitionArray(Year year) {
        ZoneOffsetTransition[] zoneOffsetTransitionArray = (ZoneOffsetTransition[])this.lastRulesCache.get(year);
        if (zoneOffsetTransitionArray != null) {
            return zoneOffsetTransitionArray;
        }
        ZoneOffsetTransitionRule[] zoneOffsetTransitionRuleArray = this.lastRules;
        zoneOffsetTransitionArray = new ZoneOffsetTransition[zoneOffsetTransitionRuleArray.length];
        for (int i = 0; i < zoneOffsetTransitionRuleArray.length; ++i) {
            zoneOffsetTransitionArray[i] = zoneOffsetTransitionRuleArray[i].createTransition(year.getValue());
        }
        if (year.isBefore(LAST_CACHED_YEAR)) {
            this.lastRulesCache.putIfAbsent(year, zoneOffsetTransitionArray);
        }
        return zoneOffsetTransitionArray;
    }

    @Override
    public ZoneOffset getStandardOffset(InstantProvider instantProvider) {
        Instant instant = Instant.instant(instantProvider);
        long l = instant.getEpochSeconds();
        int n = Arrays.binarySearch(this.standardTransitions, l);
        if (n < 0) {
            n = -n - 2;
        }
        return this.standardOffsets[n + 1];
    }

    @Override
    public ZoneOffsetTransition nextTransition(InstantProvider instantProvider) {
        Instant instant = Instant.instant(instantProvider);
        long l = instant.getEpochSeconds();
        if (l >= this.savingsInstantTransitions[this.savingsInstantTransitions.length - 1]) {
            if (this.lastRules.length == 0) {
                return null;
            }
            OffsetDateTime offsetDateTime = OffsetDateTime.fromInstant(instant, this.wallOffsets[this.wallOffsets.length - 1]);
            Year year = offsetDateTime.toYear();
            while (true) {
                ZoneOffsetTransition[] zoneOffsetTransitionArray;
                for (ZoneOffsetTransition zoneOffsetTransition : zoneOffsetTransitionArray = this.findTransitionArray(year)) {
                    if (!instant.isBefore(zoneOffsetTransition.getInstant())) continue;
                    return zoneOffsetTransition;
                }
                if (year.getValue() == Integer.MAX_VALUE) {
                    return null;
                }
                year = year.next();
            }
        }
        int n = Arrays.binarySearch(this.savingsInstantTransitions, l);
        n = n < 0 ? -n - 1 : ++n;
        Instant instant2 = Instant.instant(this.savingsInstantTransitions[n]);
        OffsetDateTime offsetDateTime = OffsetDateTime.fromInstant(instant2, this.wallOffsets[n]);
        return this.createTransition(offsetDateTime, this.wallOffsets[n + 1]);
    }

    @Override
    public ZoneOffsetTransition previousTransition(InstantProvider instantProvider) {
        int n;
        OffsetDateTime offsetDateTime;
        Serializable serializable;
        Instant instant = Instant.instant(instantProvider);
        long l = instant.getEpochSeconds();
        if (instant.getNanoOfSecond() > 0 && l < Long.MAX_VALUE) {
            ++l;
        }
        long l2 = this.savingsInstantTransitions[this.savingsInstantTransitions.length - 1];
        if (this.lastRules.length > 0 && l > l2) {
            ZoneOffset zoneOffset = this.wallOffsets[this.wallOffsets.length - 1];
            serializable = OffsetDateTime.fromInstant(instant, zoneOffset);
            offsetDateTime = OffsetDateTime.fromInstant(Instant.instant(l2), zoneOffset);
            Year year = ((OffsetDateTime)serializable).toYear();
            while (year.getValue() > offsetDateTime.getYear()) {
                ZoneOffsetTransition[] zoneOffsetTransitionArray = this.findTransitionArray(year);
                for (int i = zoneOffsetTransitionArray.length - 1; i >= 0; --i) {
                    if (!instant.isAfter(zoneOffsetTransitionArray[i].getInstant())) continue;
                    return zoneOffsetTransitionArray[i];
                }
                year = year.previous();
            }
        }
        if ((n = Arrays.binarySearch(this.savingsInstantTransitions, l)) < 0) {
            n = -n - 1;
        }
        if (n <= 0) {
            return null;
        }
        serializable = Instant.instant(this.savingsInstantTransitions[n - 1]);
        offsetDateTime = OffsetDateTime.fromInstant((InstantProvider)((Object)serializable), this.wallOffsets[n - 1]);
        return this.createTransition(offsetDateTime, this.wallOffsets[n]);
    }

    @Override
    public List<ZoneOffsetTransition> getTransitions() {
        ArrayList<ZoneOffsetTransition> arrayList = new ArrayList<ZoneOffsetTransition>();
        for (int i = 0; i < this.savingsInstantTransitions.length; ++i) {
            Instant instant = Instant.instant(this.savingsInstantTransitions[i]);
            OffsetDateTime offsetDateTime = OffsetDateTime.fromInstant(instant, this.wallOffsets[i]);
            arrayList.add(this.createTransition(offsetDateTime, this.wallOffsets[i + 1]));
        }
        return arrayList;
    }

    @Override
    public List<ZoneOffsetTransitionRule> getTransitionRules() {
        return new ArrayList<ZoneOffsetTransitionRule>(Arrays.asList(this.lastRules));
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof StandardZoneRules) {
            StandardZoneRules standardZoneRules = (StandardZoneRules)object;
            return Arrays.equals(this.standardTransitions, standardZoneRules.standardTransitions) && Arrays.equals(this.standardOffsets, standardZoneRules.standardOffsets) && Arrays.equals(this.savingsInstantTransitions, standardZoneRules.savingsInstantTransitions) && Arrays.equals(this.wallOffsets, standardZoneRules.wallOffsets) && Arrays.equals(this.lastRules, standardZoneRules.lastRules);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return Arrays.hashCode(this.standardTransitions) ^ Arrays.hashCode(this.standardOffsets) ^ Arrays.hashCode(this.savingsInstantTransitions) ^ Arrays.hashCode(this.wallOffsets) ^ Arrays.hashCode(this.lastRules);
    }
}

