/*
 * Decompiled with CFR 0.152.
 */
package javax.time.calendar.zone;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.ObjectOutputStream;
import java.text.ParsePosition;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.jar.JarOutputStream;
import java.util.zip.ZipEntry;
import javax.time.calendar.Calendrical;
import javax.time.calendar.DateAdjusters;
import javax.time.calendar.ISOChronology;
import javax.time.calendar.LocalDate;
import javax.time.calendar.LocalDateTime;
import javax.time.calendar.LocalTime;
import javax.time.calendar.ZoneOffset;
import javax.time.calendar.field.DayOfWeek;
import javax.time.calendar.field.MonthOfYear;
import javax.time.calendar.field.Year;
import javax.time.calendar.format.DateTimeFormatter;
import javax.time.calendar.format.DateTimeFormatterBuilder;
import javax.time.calendar.zone.ZoneRules;
import javax.time.calendar.zone.ZoneRulesBuilder;
import javax.time.period.Period;

public final class TZDBZoneRulesCompiler {
    private final Map<Object, Object> deduplicateMap = new HashMap<Object, Object>();
    private final Map<String, List<TZDBRule>> rules = new HashMap<String, List<TZDBRule>>();
    private final Map<String, List<TZDBZone>> zones = new HashMap<String, List<TZDBZone>>();
    private final Map<String, String> links = new HashMap<String, String>();
    private final Map<String, ZoneRules> builtZones = new HashMap<String, ZoneRules>();
    private final String version;
    private final List<File> sourceFiles;
    private final File destinationDir;
    private final boolean verbose;

    public static void main(String[] stringArray) {
        Object object;
        Object object2;
        int n;
        if (stringArray.length < 2) {
            TZDBZoneRulesCompiler.outputHelp();
            return;
        }
        String string = null;
        File file = null;
        File file2 = null;
        boolean bl = false;
        File file3 = new File(System.getProperty("user.dir"));
        for (n = 0; n < stringArray.length && ((String)(object2 = stringArray[n])).startsWith("-"); ++n) {
            if ("-srcdir".equals(object2)) {
                if (file == null && ++n < stringArray.length) {
                    file = new File(file3, stringArray[n]);
                    continue;
                }
            } else if ("-dstdir".equals(object2)) {
                if (file2 == null && ++n < stringArray.length) {
                    file2 = new File(file3, stringArray[n]);
                    continue;
                }
            } else if ("-version".equals(object2)) {
                if (string == null && ++n < stringArray.length) {
                    string = stringArray[n];
                    continue;
                }
            } else if ("-verbose".equals(object2)) {
                if (!bl) {
                    bl = true;
                    continue;
                }
            } else if (!"-help".equals(object2)) {
                System.out.println("Unrecognised option: " + (String)object2);
            }
            TZDBZoneRulesCompiler.outputHelp();
            return;
        }
        if (string == null) {
            System.out.println("Missing -version");
            return;
        }
        file = file != null ? file : file3;
        File file4 = file2 = file2 != null ? file2 : file3;
        if (n >= stringArray.length) {
            System.out.println("Missing source files");
            TZDBZoneRulesCompiler.outputHelp();
            return;
        }
        object2 = new ArrayList();
        while (n < stringArray.length) {
            object = new File(file, stringArray[n]);
            if (!((File)object).exists()) {
                System.out.println("Source file does not exist: " + object);
                return;
            }
            object2.add(object);
            ++n;
        }
        if (!file2.exists() && !file2.mkdirs()) {
            System.out.println("Destination directory could not be created: " + file2);
            return;
        }
        if (!file2.isDirectory()) {
            System.out.println("Destination is not a directory: " + file2);
            return;
        }
        object = new TZDBZoneRulesCompiler(string, (List<File>)object2, file2, bl);
        try {
            ((TZDBZoneRulesCompiler)object).compile();
            System.exit(0);
        }
        catch (Exception exception) {
            System.out.println("Failed: " + exception.toString());
            exception.printStackTrace();
            System.exit(1);
        }
    }

    private static void outputHelp() {
        System.out.println("Usage: TZDBZoneRulesCompiler <options> <source files>");
        System.out.println("where options include:");
        System.out.println("   -version <version>      Specify the version name, such as 2009a (required)");
        System.out.println("   -srcdir <directory>     Specify where to find TZDB source files");
        System.out.println("   -dstdir <directory>     Specify where to output the generated file");
        System.out.println("   -help                   Print this usage message");
        System.out.println("   -verbose                Output verbose information during compilation");
    }

    public TZDBZoneRulesCompiler(String string, List<File> list, File file, boolean bl) {
        this.version = string;
        this.sourceFiles = list;
        this.destinationDir = file;
        this.verbose = bl;
    }

    public void compile() throws Exception {
        this.printVerbose("Compiling TZDB version " + this.version + " to directory " + this.destinationDir);
        this.parseFiles();
        this.buildZoneRules();
        this.outputFile();
        this.printVerbose("Compiled TZDB version " + this.version + " to directory " + this.destinationDir);
    }

    private void parseFiles() throws Exception {
        for (File file : this.sourceFiles) {
            this.printVerbose("Parsing file: " + file);
            this.parseFile(file);
        }
    }

    private void parseFile(File file) throws Exception {
        String string;
        BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
        ArrayList<TZDBZone> arrayList = null;
        while ((string = bufferedReader.readLine()) != null) {
            int n = string.indexOf(35);
            if (n >= 0) {
                string = string.substring(0, n);
            }
            if (string.trim().length() == 0) continue;
            StringTokenizer stringTokenizer = new StringTokenizer(string, " \t");
            if (arrayList != null && Character.isWhitespace(string.charAt(0)) && stringTokenizer.hasMoreTokens()) {
                if (!this.parseZoneLine(stringTokenizer, arrayList)) continue;
                arrayList = null;
                continue;
            }
            if (!stringTokenizer.hasMoreTokens()) continue;
            String string2 = stringTokenizer.nextToken();
            if (string2.equals("Zone")) {
                if (stringTokenizer.countTokens() < 3) {
                    this.printVerbose("Invalid Zone line in file: " + file + ", line: " + string);
                    throw new IllegalArgumentException("Invalid Zone line in file: " + file);
                }
                arrayList = new ArrayList<TZDBZone>();
                this.zones.put(stringTokenizer.nextToken(), arrayList);
                if (!this.parseZoneLine(stringTokenizer, arrayList)) continue;
                arrayList = null;
                continue;
            }
            arrayList = null;
            if (string2.equals("Rule")) {
                if (stringTokenizer.countTokens() < 9) {
                    this.printVerbose("Invalid Rule line in file: " + file + ", line: " + string);
                    throw new IllegalArgumentException("Invalid Rule line in file: " + file);
                }
                this.parseRuleLine(stringTokenizer);
                continue;
            }
            if (string2.equals("Link")) {
                if (stringTokenizer.countTokens() < 2) {
                    this.printVerbose("Invalid Link line in file: " + file + ", line: " + string);
                    throw new IllegalArgumentException("Invalid Link line in file: " + file);
                }
                this.links.put(stringTokenizer.nextToken(), stringTokenizer.nextToken());
                continue;
            }
            System.out.println("Unknown line: " + string);
        }
        bufferedReader.close();
    }

    private void parseRuleLine(StringTokenizer stringTokenizer) {
        TZDBRule tZDBRule = new TZDBRule();
        String string = stringTokenizer.nextToken();
        if (!this.rules.containsKey(string)) {
            this.rules.put(string, new ArrayList());
        }
        this.rules.get(string).add(tZDBRule);
        tZDBRule.startYear = this.parseYear(stringTokenizer.nextToken(), 0);
        tZDBRule.endYear = this.parseYear(stringTokenizer.nextToken(), tZDBRule.startYear);
        if (tZDBRule.startYear > tZDBRule.endYear) {
            throw new IllegalArgumentException("Year order invalid: " + tZDBRule.startYear + " > " + tZDBRule.endYear);
        }
        this.parseOptional(stringTokenizer.nextToken());
        this.parseMonthDayTime(stringTokenizer, tZDBRule);
        tZDBRule.savingsAmount = this.parsePeriod(stringTokenizer.nextToken());
        tZDBRule.text = this.parseOptional(stringTokenizer.nextToken());
    }

    private boolean parseZoneLine(StringTokenizer stringTokenizer, List<TZDBZone> list) {
        TZDBZone tZDBZone = new TZDBZone();
        list.add(tZDBZone);
        tZDBZone.standardOffset = this.parseOffset(stringTokenizer.nextToken());
        String string = this.parseOptional(stringTokenizer.nextToken());
        if (string == null) {
            tZDBZone.fixedSavings = Period.ZERO;
            tZDBZone.savingsRule = null;
        } else {
            try {
                tZDBZone.fixedSavings = this.parsePeriod(string);
                tZDBZone.savingsRule = null;
            }
            catch (Exception exception) {
                tZDBZone.fixedSavings = null;
                tZDBZone.savingsRule = string;
            }
        }
        tZDBZone.text = stringTokenizer.nextToken();
        if (stringTokenizer.hasMoreTokens()) {
            tZDBZone.year = Year.isoYear(Integer.parseInt(stringTokenizer.nextToken()));
            if (stringTokenizer.hasMoreTokens()) {
                this.parseMonthDayTime(stringTokenizer, tZDBZone);
            }
            return false;
        }
        return true;
    }

    private void parseMonthDayTime(StringTokenizer stringTokenizer, TZDBMonthDayTime tZDBMonthDayTime) {
        tZDBMonthDayTime.month = this.parseMonth(stringTokenizer.nextToken());
        if (stringTokenizer.hasMoreTokens()) {
            String string = stringTokenizer.nextToken();
            if (string.startsWith("last")) {
                tZDBMonthDayTime.dayOfMonth = -1;
                tZDBMonthDayTime.dayOfWeek = this.parseDayOfWeek(string.substring(4));
                tZDBMonthDayTime.adjustForwards = false;
            } else {
                int n = string.indexOf(">=");
                if (n > 0) {
                    tZDBMonthDayTime.dayOfWeek = this.parseDayOfWeek(string.substring(0, n));
                    string = string.substring(n + 2);
                } else {
                    n = string.indexOf("<=");
                    if (n > 0) {
                        tZDBMonthDayTime.dayOfWeek = this.parseDayOfWeek(string.substring(0, n));
                        tZDBMonthDayTime.adjustForwards = false;
                        string = string.substring(n + 2);
                    }
                }
                tZDBMonthDayTime.dayOfMonth = Integer.parseInt(string);
            }
            if (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                tZDBMonthDayTime.time = this.parseTime(string2);
                tZDBMonthDayTime.timeDefinition = this.parseTimeDefinition(string2.charAt(string2.length() - 1));
            }
        }
    }

    private int parseYear(String string, int n) {
        if ((string = string.toLowerCase()).equals("minimum") || string.equals("min")) {
            return -2147483646;
        }
        if (string.equals("maximum") || string.equals("max")) {
            return Integer.MAX_VALUE;
        }
        if (string.equals("only")) {
            return n;
        }
        return Integer.parseInt(string);
    }

    private MonthOfYear parseMonth(String string) {
        int n = "JanFebMarAprMayJunJulAugSepOctNovDec".indexOf(string);
        if (n == -1) {
            throw new IllegalArgumentException("Unknown month: " + string);
        }
        int n2 = n / 3 + 1;
        return MonthOfYear.monthOfYear(n2);
    }

    private DayOfWeek parseDayOfWeek(String string) {
        int n = "MonTueWedThuFriSatSun".indexOf(string);
        if (n == -1) {
            throw new IllegalArgumentException("Unknown day of week: " + string);
        }
        int n2 = n / 3 + 1;
        return DayOfWeek.dayOfWeek(n2);
    }

    private String parseOptional(String string) {
        return string.equals("-") ? null : string;
    }

    private LocalTime parseTime(String string) {
        DateTimeFormatter dateTimeFormatter = new DateTimeFormatterBuilder().appendValue(ISOChronology.hourOfDayRule()).optionalStart().appendLiteral(':').appendValue(ISOChronology.minuteOfHourRule(), 2).optionalStart().appendLiteral(':').appendValue(ISOChronology.secondOfMinuteRule(), 2).toFormatter();
        ParsePosition parsePosition = new ParsePosition(0);
        Calendrical calendrical = dateTimeFormatter.parse(string, parsePosition);
        if (parsePosition.getErrorIndex() >= 0) {
            throw new IllegalArgumentException(string);
        }
        return this.deduplicate(calendrical.mergeStrict().toLocalTime());
    }

    private int parseSecs(String string) {
        DateTimeFormatter dateTimeFormatter = new DateTimeFormatterBuilder().appendValue(ISOChronology.hourOfDayRule()).optionalStart().appendLiteral(':').appendValue(ISOChronology.minuteOfHourRule(), 2).optionalStart().appendLiteral(':').appendValue(ISOChronology.secondOfMinuteRule(), 2).toFormatter();
        int n = 0;
        if (string.startsWith("-")) {
            n = 1;
        }
        ParsePosition parsePosition = new ParsePosition(n);
        Calendrical calendrical = dateTimeFormatter.parse(string, parsePosition);
        if (parsePosition.getErrorIndex() >= 0) {
            throw new IllegalArgumentException(string);
        }
        LocalTime localTime = calendrical.mergeStrict().toLocalTime();
        int n2 = localTime.getHourOfDay() * 60 * 60 + localTime.getMinuteOfHour() * 60 + localTime.getSecondOfMinute();
        if (n == 1) {
            n2 = -n2;
        }
        return n2;
    }

    private ZoneOffset parseOffset(String string) {
        int n = this.parseSecs(string);
        return ZoneOffset.forTotalSeconds(n);
    }

    private Period parsePeriod(String string) {
        int n = this.parseSecs(string);
        return this.deduplicate(Period.seconds(n).normalized());
    }

    private ZoneRulesBuilder.TimeDefinition parseTimeDefinition(char c) {
        switch (c) {
            case 'S': 
            case 's': {
                return ZoneRulesBuilder.TimeDefinition.STANDARD;
            }
            case 'G': 
            case 'U': 
            case 'Z': 
            case 'g': 
            case 'u': 
            case 'z': {
                return ZoneRulesBuilder.TimeDefinition.UTC;
            }
        }
        return ZoneRulesBuilder.TimeDefinition.WALL;
    }

    private void buildZoneRules() throws Exception {
        for (String string : this.zones.keySet()) {
            this.printVerbose("Building zone " + string);
            List<TZDBZone> list = this.zones.get(string);
            ZoneRulesBuilder zoneRulesBuilder = new ZoneRulesBuilder();
            for (TZDBZone tZDBZone : list) {
                zoneRulesBuilder = tZDBZone.addToBuilder(zoneRulesBuilder, this.rules);
            }
            this.builtZones.put(string, zoneRulesBuilder.toRules(string, this.deduplicateMap));
        }
    }

    private void outputFile() throws Exception {
        File file = new File(this.destinationDir, "ZoneRuleInfo-TZDB-" + this.version + ".jar");
        this.printVerbose("Outputting file: " + file);
        JarOutputStream jarOutputStream = new JarOutputStream(new FileOutputStream(file));
        jarOutputStream.putNextEntry(new ZipEntry("javax/time/calendar/zone/ZoneRuleInfo.dat"));
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(jarOutputStream);
        objectOutputStream.writeInt(1);
        objectOutputStream.writeUTF("TZDB");
        objectOutputStream.writeUTF(this.version);
        objectOutputStream.writeObject(this.builtZones);
        jarOutputStream.closeEntry();
        objectOutputStream.close();
    }

    <T> T deduplicate(T t) {
        if (!this.deduplicateMap.containsKey(t)) {
            this.deduplicateMap.put(t, t);
        }
        return (T)this.deduplicateMap.get(t);
    }

    private void printVerbose(String string) {
        if (this.verbose) {
            System.out.println(string);
        }
    }

    private final class TZDBZone
    extends TZDBMonthDayTime {
        ZoneOffset standardOffset;
        Period fixedSavings;
        String savingsRule;
        String text;
        Year year;

        private TZDBZone() {
        }

        ZoneRulesBuilder addToBuilder(ZoneRulesBuilder zoneRulesBuilder, Map<String, List<TZDBRule>> map) {
            if (this.year != null) {
                zoneRulesBuilder.addWindow(this.standardOffset, this.toDateTime(this.year.getValue()), this.timeDefinition);
            } else {
                zoneRulesBuilder.addWindowForever(this.standardOffset);
            }
            if (this.fixedSavings != null) {
                zoneRulesBuilder.setFixedSavingsToWindow(this.fixedSavings);
            } else {
                List<TZDBRule> list = map.get(this.savingsRule);
                if (list == null) {
                    throw new IllegalArgumentException("Rule not found: " + this.savingsRule);
                }
                for (TZDBRule tZDBRule : list) {
                    tZDBRule.addToBuilder(zoneRulesBuilder);
                }
            }
            return zoneRulesBuilder;
        }
    }

    private final class TZDBRule
    extends TZDBMonthDayTime {
        int startYear;
        int endYear;
        Period savingsAmount;
        String text;

        private TZDBRule() {
        }

        void addToBuilder(ZoneRulesBuilder zoneRulesBuilder) {
            this.adjustToFowards(2001);
            zoneRulesBuilder.addRuleToWindow(this.startYear, this.endYear, this.month, this.dayOfMonth, this.dayOfWeek, this.time, this.timeDefinition, this.savingsAmount);
        }
    }

    private abstract class TZDBMonthDayTime {
        MonthOfYear month = MonthOfYear.JANUARY;
        int dayOfMonth = 1;
        boolean adjustForwards = true;
        DayOfWeek dayOfWeek;
        LocalTime time = LocalTime.MIDNIGHT;
        ZoneRulesBuilder.TimeDefinition timeDefinition = ZoneRulesBuilder.TimeDefinition.WALL;

        private TZDBMonthDayTime() {
        }

        LocalDateTime toDateTime(int n) {
            LocalDate localDate;
            this.adjustToFowards(n);
            if (this.dayOfMonth == -1) {
                this.dayOfMonth = this.month.lengthInDays(n);
                localDate = LocalDate.date(n, this.month, this.dayOfMonth);
                if (this.dayOfWeek != null) {
                    localDate = localDate.with(DateAdjusters.previousOrCurrent(this.dayOfWeek));
                }
            } else {
                localDate = LocalDate.date(n, this.month, this.dayOfMonth);
                if (this.dayOfWeek != null) {
                    localDate = localDate.with(DateAdjusters.nextOrCurrent(this.dayOfWeek));
                }
            }
            localDate = TZDBZoneRulesCompiler.this.deduplicate(localDate);
            return LocalDateTime.dateTime(localDate, this.time);
        }

        void adjustToFowards(int n) {
            if (!this.adjustForwards && this.dayOfMonth > 0) {
                LocalDate localDate = LocalDate.date(n, this.month, this.dayOfMonth).minusDays(6L);
                this.dayOfMonth = localDate.getDayOfMonth();
                this.month = localDate.getMonthOfYear();
                this.adjustForwards = true;
            }
        }
    }
}

