/*
 * Decompiled with CFR 0.152.
 */
package javax.time.period.field;

import java.io.Serializable;
import javax.time.period.PeriodUnit;
import javax.time.period.PeriodUnits;
import javax.time.period.field.PeriodField;

public final class Weeks
extends PeriodField
implements Comparable<Weeks>,
Serializable {
    public static final Weeks ZERO = new Weeks(0);
    private static final long serialVersionUID = 1L;
    private final int weeks;

    public static Weeks weeks(int n) {
        if (n == 0) {
            return ZERO;
        }
        return new Weeks(n);
    }

    private Weeks(int n) {
        this.weeks = n;
    }

    private Object readResolve() {
        return Weeks.weeks(this.weeks);
    }

    @Override
    public int getAmount() {
        return this.weeks;
    }

    @Override
    public Weeks withAmount(int n) {
        return Weeks.weeks(n);
    }

    @Override
    public PeriodUnit getUnit() {
        return PeriodUnits.WEEKS;
    }

    @Override
    public Weeks plus(int n) {
        return (Weeks)super.plus(n);
    }

    public Weeks plus(Weeks weeks) {
        return this.plus(weeks.getAmount());
    }

    @Override
    public Weeks minus(int n) {
        return (Weeks)super.minus(n);
    }

    public Weeks minus(Weeks weeks) {
        return this.minus(weeks.getAmount());
    }

    @Override
    public Weeks multipliedBy(int n) {
        return (Weeks)super.multipliedBy(n);
    }

    @Override
    public Weeks dividedBy(int n) {
        return (Weeks)super.dividedBy(n);
    }

    @Override
    public Weeks negated() {
        return (Weeks)super.negated();
    }

    @Override
    public int compareTo(Weeks weeks) {
        int n = this.weeks;
        int n2 = weeks.weeks;
        return n < n2 ? -1 : (n == n2 ? 0 : 1);
    }

    public boolean isGreaterThan(Weeks weeks) {
        return this.compareTo(weeks) > 0;
    }

    public boolean isLessThan(Weeks weeks) {
        return this.compareTo(weeks) < 0;
    }

    @Override
    public String toString() {
        return "P" + this.weeks + "W";
    }
}

