/*
 * Decompiled with CFR 0.152.
 */
package javax.time.period.field;

import java.io.Serializable;
import javax.time.period.PeriodUnit;
import javax.time.period.PeriodUnits;
import javax.time.period.field.PeriodField;

public final class Years
extends PeriodField
implements Comparable<Years>,
Serializable {
    public static final Years ZERO = new Years(0);
    private static final long serialVersionUID = 1L;
    private final int years;

    public static Years years(int n) {
        if (n == 0) {
            return ZERO;
        }
        return new Years(n);
    }

    private Years(int n) {
        this.years = n;
    }

    private Object readResolve() {
        return Years.years(this.years);
    }

    @Override
    public int getAmount() {
        return this.years;
    }

    @Override
    public Years withAmount(int n) {
        return Years.years(n);
    }

    @Override
    public PeriodUnit getUnit() {
        return PeriodUnits.YEARS;
    }

    @Override
    public Years plus(int n) {
        return (Years)super.plus(n);
    }

    public Years plus(Years years) {
        return this.plus(years.getAmount());
    }

    @Override
    public Years minus(int n) {
        return (Years)super.minus(n);
    }

    public Years minus(Years years) {
        return this.minus(years.getAmount());
    }

    @Override
    public Years multipliedBy(int n) {
        return (Years)super.multipliedBy(n);
    }

    @Override
    public Years dividedBy(int n) {
        return (Years)super.dividedBy(n);
    }

    @Override
    public Years negated() {
        return (Years)super.negated();
    }

    @Override
    public int compareTo(Years years) {
        int n = this.years;
        int n2 = years.years;
        return n < n2 ? -1 : (n == n2 ? 0 : 1);
    }

    public boolean isGreaterThan(Years years) {
        return this.compareTo(years) > 0;
    }

    public boolean isLessThan(Years years) {
        return this.compareTo(years) < 0;
    }

    @Override
    public String toString() {
        return "P" + this.years + "Y";
    }
}

